<?php namespace App\Controllers;
//Conexiones
use Config\Database;
$dbSip        = \Config\Database::connect('thSipacha', true);

//Controladores
use CodeIgniter\Controller;
//Modelos
use App\Models\Auditoria;
use App\Models\Usuarios;
use App\Models\Hipodromos;
use App\Models\Carreras;
use App\Models\Caballos;
use App\Models\Configuracion;
use App\Models\CarreraFin; 
use App\Models\Jganadores;
//Librerias del Codeigneter4
$pager = \Config\Services::pager();

class ThResultadosJGanador extends Th
{

    public function ListarHipodromos()
    {      
    //Verifico Sesion de Usuario
    if (!session()->get('isLogged')){
        $mensaje   = "Presione clic en su opcion de menu.";
        $claseMens = "alert alert-danger";
        $titleMens = "<strong>¡Error!</strong> </br>";   
        $datos = array('mensaje'=>$mensaje,'titleMens'=>$titleMens,'claseMens'=>$claseMens);		
        return view('estructura/ingresomalo.php',$datos);
    }  	
        $datosUsuario= $this->SessionUser();
        $MenuIzquierdo = $this->MenuIzquierdo();
        $usu_id = $datosUsuario['id'];
        $MontoActual = $this->MontoDisponible($usu_id);

        $MenuIzquierdo[0]=" menu-open active";
        $MenuIzquierdo[1]="active";
        $MenuIzquierdo[2]="active";
    
        $dbSip = \Config\Database::connect('thSipacha', true);
        $Carreras = new Carreras($dbSip);  
    
        $ClasDiv   = "table-responsive table-hover";
        $ClasTabla = "table table-bordered table-striped";  
        $idDiv     = ""; 

        $fechahoy= date("Y")."-".date("m")."-".date("d"); 
        $builder = $Carreras -> builder ();
        $builder -> distinct();
        $builder-> Select('carr_fecha as tab_jugada, hip_nombre, tab_hipodromos.hip_id');
        $builder->join('tab_hipodromos','tab_carrera.hip_id = tab_hipodromos.hip_id','inner');
        $builder->where('tab_hipodromos.hip_clasificacion', '1'); //Carreras Nacionales
        $builder->where('tab_hipodromos.hip_estatus', '1'); //Hipodromo Activo
        //$builder->where('tab_carrera.carr_fecha>=', $fechahoy); //Fecha Activa >= HOY
        $builder->where('tab_carrera.carr_sem_cerrada', '0'); //Semana Abierta
        $datosCarreras = $builder->get(); 
        $element = $MontoActual;
        $element .= "        
        <div class='".$ClasDiv."' id='".$idDiv."'>
        <table class='".$ClasTabla."'> 
        <thead class='thead-dark'>
        <tr>
        <td style='background-color:#0b054a'><p style='color:#FFFFFF;'>
        <B>Hipodromos Nacionales</B></p></td></tr> 
        <tr> <tr><td>";
        foreach ($datosCarreras->getResultArray() as $row_item){
            $dia = saber_dia($row_item['tab_jugada']);
            /*$element .= " <td>           
            <a href='".BaseUrl()."ThResultadosJGanador/ListarCarrerasNac?th1=".$row_item['tab_jugada']."&th=".$row_item['hip_id']."' > <i class='fas fa-horse'></i>&nbsp;&nbsp;".$row_item['hip_nombre']."&nbsp;&nbsp;".$dia."&nbsp;&nbsp;".cambiarfecha($row_item['tab_jugada'])." </a>
            </td></tr>";*/
            $element .= "   
            <form  method='post' action='".BaseUrl()."/ThResultadosJGanador/ListarCarrerasNac'>
            <input name='th' type='hidden' value='".$row_item['hip_id']."'>
            <input name='th1' type='hidden' value='".$row_item['tab_jugada']."'>
            <button type='submit' class='btn btn-outline-info btn-block'>
            ".$row_item['hip_nombre']."&nbsp;&nbsp;".$dia."&nbsp;&nbsp;".cambiarfecha($row_item['tab_jugada'])."            
            </button>
            
            </form>
            ";
        }
        $element .="</td></tr></table></div>";
        //echo $element;

        $ClasDiv   = "table-responsive table-hover";
        $ClasTabla = "table table-bordered table-striped";  
        $idDiv     = ""; 

        $fechahoy= date("Y")."-".date("m")."-".date("d"); 
        $builder = $Carreras -> builder ();
        $builder -> distinct();
        $builder-> Select('carr_fecha as tab_jugada, hip_nombre, tab_hipodromos.hip_id');
        $builder->join('tab_hipodromos','tab_carrera.hip_id = tab_hipodromos.hip_id','inner');
        $builder->where('tab_hipodromos.hip_clasificacion', '0'); //Carreras Internacionales
        $builder->where('tab_hipodromos.hip_estatus', '1'); //Hipodromo Activo
        $builder->where('tab_carrera.carr_fecha>=', $fechahoy); //Fecha Activa >= HOY
        $datosCarreras = $builder->get(); 

        $element2 = "   
        <div class='".$ClasDiv."' id='".$idDiv."'>
        <table class='".$ClasTabla."'> 
        <thead class='thead-dark'>
        <tr>
        <td style='background-color:#008080'><p style='color:#FFFFFF;'><B>Hipodromos Interionales</B></p></td></tr> 
        <tr> <tr><td>";
        foreach ($datosCarreras->getResultArray() as $row_item){
            $dia = saber_dia($row_item['tab_jugada']);
            /*$element2 .= " <td>           
            <a href='".BaseUrl()."ThJugadasAGanadorInter/ListarCarrerasInter?th1=".$row_item['tab_jugada']."&th=".$row_item['hip_id']."' > <i class='fas fa-horse'></i>&nbsp;&nbsp;".$row_item['hip_nombre']."&nbsp;&nbsp;".$dia."&nbsp;&nbsp;".cambiarfecha($row_item['tab_jugada'])." </a>
            </td></tr>";*/
            $element2 .= "   
            <form  method='post' action='".BaseUrl()."/ThResultadosJGanador/ListarCarrerasInter'>
            <input name='th' type='hidden' value='".$row_item['hip_id']."'>
            <input name='th1' type='hidden' value='".$row_item['tab_jugada']."'>
            <button type='submit' class='btn btn-outline-warning btn-block'>
            ".$row_item['hip_nombre']."&nbsp;&nbsp;".$dia."&nbsp;&nbsp;".cambiarfecha($row_item['tab_jugada'])."            
            </button>
            
            </form>
            ";
        }
        $element2 .="</td></tr></table>";
        //echo $element2;

        $datos = array('datosUsuario'=>$datosUsuario,'MenuIzquierdo'=>$MenuIzquierdo,'HipodromosNacionales'=>$element,'HipodromosInternacionales'=>$element2);		
        return view('resultados/rjganadorhip.php',$datos);
    
    }

    
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
public function ListarCarrerasNac()
{      
    //Verifico Sesion de Usuario
    if (!session()->get('isLogged')){
        $mensaje   = "Presione clic en su opcion de menu.";
        $claseMens = "alert alert-danger";
        $titleMens = "<strong>¡Error!</strong> </br>";   
        $datos = array('mensaje'=>$mensaje,'titleMens'=>$titleMens,'claseMens'=>$claseMens);		
        return view('estructura/ingresomalo.php',$datos);
    }

    $request=\Config\Services::request();
    $hip_id = $request->getPostGet('th'); 
    $fecha_carr = $request->getPostGet('th1');

    $datosUsuario= $this->SessionUser();
    $MenuIzquierdo = $this->MenuIzquierdo();    
    $MenuIzquierdo[0]=" menu-open active";
    $MenuIzquierdo[1]="active";
    $MenuIzquierdo[2]="active";
    $usu_id = $datosUsuario['id'];
    $MontoActual = $this->MontoDisponible($usu_id);
    $dbSip = \Config\Database::connect('thSipacha', true);
    $Carreras = new Carreras($dbSip);  
    $Hipodromo = new Hipodromos($dbSip);  
    
    $ClasDiv   = "table-responsive table-hover";
    $ClasTabla = "table table-bordered table-striped";  
    $idDiv     = ""; 
    
    $datosHip = $Hipodromo -> find ($hip_id);
    $pos = ['1','2','3'];
    $carr_fechahora_actual = fechaActualConHoraMySql();
    //echo "..............................................................................". $carr_fechahora_actual.".....".$hip_id;
    $builder = $Carreras -> builder ();
    $builder -> distinct();
    $builder-> Select("carr_valida as carrera, tab_carrera.carr_id, hip_id,carr_fecha,carr_horainicio,carr_horafin,carr_valida,carr_dia,carr_metros,carr_cabfav,carr_estatus,carr_comentario, CONCAT( carr_fecha,' ',carr_horafin ) as carr_fechafin");
    //$builder->join('tab_carrerafin','tab_carrerafin.carr_id = tab_carrera.carr_id','inner');
    $builder->join('tab_caballos','tab_caballos.carr_id = tab_carrera.carr_id ','inner');
    $builder->where('tab_carrera.hip_id', $hip_id); //Hipodromo seleccionado
    //$builder->where('tab_carrera.carr_fecha>', $carr_fechahora_actual); //FechaFinCarrera > FechaHoraActual
    $builder->whereIn('tab_caballos.cab_posifinal', $pos); //Caballos Ganadores
    $builder->where('tab_carrera.carr_sem_cerrada', '0'); //Semana Abierta
    $builder->where('tab_carrera.carr_fecha',$fecha_carr); //Fecha selecionada
    $builder->orderBy('carr_valida','ASC');
    $datosCarreras = $builder->get(); 

    $element = $MontoActual;
    $element .= "  
    <div class='".$ClasDiv."' id='".$idDiv."'>
    <table class='".$ClasTabla."'> 
    <thead class='thead-dark'>
    <tr>
    <td style='background-color:#0b054a'><p style='color:#FFFFFF;'><B>HIPODROMO&nbsp;".$datosHip['hip_nombre']."&nbsp;".cambiarfecha($fecha_carr)."</B></p></td></tr> 
    <tr> <tr><td>";
    foreach ($datosCarreras->getResultArray() as $row_item){
        $element .= "  
        <form  method='post' action='".BaseUrl()."/ThResultadosJGanador/ListarCaballosNac'>
        <input name='th' type='hidden' value='".$row_item['carr_id']."'>
        <input name='th1' type='hidden' value='".$row_item['hip_id']."'>
        <input name='th2' type='hidden' value='".$row_item['carr_fecha']."'>
        <button type='submit' class='btn btn-outline-info btn-block'>
        Carrera&nbsp;&nbsp;".$row_item['carr_valida']."
        </button>
        </form>
        ";
    }
    $element .="</td></tr></table>";
    //echo $element;

    $datos = array('datosHip'=>$datosHip,'datosUsuario'=>$datosUsuario,'MenuIzquierdo'=>$MenuIzquierdo,'Carreras'=>$element);		
    return view('resultados/rjganadorcarr',$datos);

}

    
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
public function ListarCaballosNac()
{      
    //Verifico Sesion de Usuario
    if (!session()->get('isLogged')){
        $mensaje   = "Presione clic en su opcion de menu.";
        $claseMens = "alert alert-danger";
        $titleMens = "<strong>¡Error!</strong> </br>";   
        $datos = array('mensaje'=>$mensaje,'titleMens'=>$titleMens,'claseMens'=>$claseMens);		
        return view('estructura/ingresomalo.php',$datos);
    }

    $request=\Config\Services::request();
    $carr_id = $request->getPostGet('th'); 
    $hip_id = $request->getPostGet('th1');
    $fecha_carr = $request->getPostGet('th2');

    $datosUsuario= $this->SessionUser();
    $MenuIzquierdo = $this->MenuIzquierdo();
    $MenuIzquierdo[0]=" menu-open active";
    $MenuIzquierdo[1]="active";
    $MenuIzquierdo[2]="active";
    $usu_id = $datosUsuario['id'];
    $MontoActual = $this->MontoDisponible($usu_id);
    $dbSip = \Config\Database::connect('thSipacha', true);
    $Caballos = new Caballos($dbSip);  
    $Hipodromo = new Hipodromos($dbSip); 
    $Carreras = new Carreras($dbSip); 

    $ClasDiv   = "table-responsive table-hover";
    $ClasTabla = "table table-bordered table-striped";
    //$ClasDiv   ="";
    //$ClasTabla ="";  
    $idDiv     = ""; 
    $datosCarr = $Carreras -> find ($carr_id);
    $datosHip = $Hipodromo -> find ($hip_id);
    //echo "..............................................................................".".....".$hip_id;
    $builder = $Caballos -> builder ();
    $builder ->where('carr_id',$carr_id);  //
    $builder ->where('cab_posifinal<>','0'); 
    $builder->orderby('cab_posifinal','ASC');
    $datosCaballos = $builder->get(); 
    $element = $MontoActual;
    $element .= "   
    <div class='".$ClasDiv."' id='".$idDiv."'>
    <table class='".$ClasTabla."'> 
    <tr>
    <td colspan=3 style='background-color:#0b054a'><p style='color:#FFFFFF;'><B>Hipodromo&nbsp;".$datosHip['hip_nombre']."&nbsp;".cambiarfecha($fecha_carr)."</B></td>
    <td style='background-color:#0b054a'><p style='color:#FFFFFF;'><b> CARRERA N: ".$datosCarr['carr_valida']." de ".$datosCarr['carr_metros']."&nbsp;metros</b></p></td></tr> 
    
    <tr> 
    <tr style='background-color:#008080'>
    <td style='background-color:#3b83bd'> <b>N.</b></p></td>
    <td style='background-color:#3b83bd'> <b>CABALLO</b></p></td>
    <td style='background-color:#3b83bd'> <b>JINETE</b></p></td>
    <td style='background-color:#3b83bd'> <b>POSICION</b></p></td>
    </tr>";
    foreach ($datosCaballos->getResultArray() as $row_item){

        if ($row_item['cab_estatus']==1) {  //Caballos Activos
            $element .= "  
            <tr>
            <td><small>".$row_item['cab_posinicial']."</small></td>
            <td><small>".$row_item['cab_nombre']."</small></td>
            <td><small>".$row_item['cab_jinete']."</small></td>
            <td><small>".$row_item['cab_posifinal']."</small></td>";            
            $element .= " 
            </tr>
            ";  
        }else {
            $element .= "  
            <tr style='background-color:red'>
            <td><small>".$row_item['cab_posinicial']."</small></td>
            <td><small>".$row_item['cab_nombre']."</small></td>
            <td><small>".$row_item['cab_jinete']."</small></td>
            <td> <small>";               
            $element .= "  RETIRADO</small> </td> </tr> ";              
        }
      
    }
    $element .="</tr></table>";
    //echo $element;
    
    $datos = array('datosHip'=>$datosHip,'datosUsuario'=>$datosUsuario,'MenuIzquierdo'=>$MenuIzquierdo,'Caballos'=>$element);		
    return view('resultados/rjganadorcab.php',$datos);

}

    
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
public function ListarCarrerasInter()
{      
    //Verifico Sesion de Usuario
    if (!session()->get('isLogged')){
        $mensaje   = "Presione clic en su opcion de menu.";
        $claseMens = "alert alert-danger";
        $titleMens = "<strong>¡Error!</strong> </br>";   
        $datos = array('mensaje'=>$mensaje,'titleMens'=>$titleMens,'claseMens'=>$claseMens);		
        return view('estructura/ingresomalo.php',$datos);
    }

    $request=\Config\Services::request();
    $hip_id = $request->getPostGet('th'); 
    $fecha_carr = $request->getPostGet('th1');

    $datosUsuario= $this->SessionUser();
    $MenuIzquierdo = $this->MenuIzquierdo();    
    $MenuIzquierdo[0]=" menu-open active";
    $MenuIzquierdo[1]="active";
    $MenuIzquierdo[2]="active";
    $usu_id = $datosUsuario['id'];
    $MontoActual = $this->MontoDisponible($usu_id);
    $dbSip = \Config\Database::connect('thSipacha', true);
    $Carreras = new Carreras($dbSip);  
    $Hipodromo = new Hipodromos($dbSip);  
    
    $ClasDiv   = "table-responsive table-hover";
    $ClasTabla = "table table-bordered table-striped";  
    $idDiv     = ""; 
    
    $datosHip = $Hipodromo -> find ($hip_id);

    $carr_fechahora_actual = fechaActualConHoraMySql();
    //echo "..............................................................................". $carr_fechahora_actual.".....".$hip_id;
    $pos = ['1','2','3'];
    $builder = $Carreras -> builder ();
    $builder -> distinct();
    $builder-> Select("carr_valida as carrera, tab_carrera.carr_id, hip_id,carr_fecha,carr_horainicio,carr_horafin,carr_valida,carr_dia,carr_metros,carr_cabfav,carr_estatus,carr_comentario, CONCAT( carr_fecha,' ',carr_horafin ) as carr_fechafin");
    //$builder->join('tab_carrerafin','tab_carrerafin.carr_id = tab_carrera.carr_id','inner');
    $builder->join('tab_caballos','tab_caballos.carr_id = tab_carrera.carr_id ','inner');
    $builder->where('tab_carrera.hip_id', $hip_id); //Hipodromo seleccionado
    //$builder->where('tab_carrera.carr_fecha>', $carr_fechahora_actual); //FechaFinCarrera > FechaHoraActual
    //$builder->where('tab_caballos.cab_posifinal', '0'); //Caballo PorCorrer
    $builder->whereIn('tab_caballos.cab_posifinal', $pos); //Caballos Ganadores
    $builder->where('tab_carrera.carr_sem_cerrada', '0'); //Semana Abierta
    $builder->where('tab_carrera.carr_fecha',$fecha_carr); //Fecha selecionada
    $builder->orderBy('carr_valida','ASC');
    $datosCarreras = $builder->get(); 

    $element = $MontoActual;
    $element .= "  
    <div class='".$ClasDiv."' id='".$idDiv."'>
    <table class='".$ClasTabla."'> 
    <thead class='thead-dark'>
    <tr>
    <td style='background-color:#008080'><p style='color:#000000;'><B>HIPODROMO&nbsp;".$datosHip['hip_nombre']."&nbsp;".cambiarfecha($fecha_carr)."</B></p></td></tr> 
    <tr> <tr><td>";
    foreach ($datosCarreras->getResultArray() as $row_item){
        $element .= "  
        <form  method='post' action='".BaseUrl()."/ThResultadosJGanador/ListarCaballosInter'>
        <input name='th' type='hidden' value='".$row_item['carr_id']."'>
        <input name='th1' type='hidden' value='".$row_item['hip_id']."'>
        <input name='th2' type='hidden' value='".$row_item['carr_fecha']."'>
        <button type='submit' class='btn btn-outline-warning btn-block'>
        Carrera&nbsp;&nbsp;".$row_item['carr_valida']."
        </button>
        </form>
        ";
    }
    $element .="</td></tr></table>";
    //echo $element;

    $datos = array('datosHip'=>$datosHip,'datosUsuario'=>$datosUsuario,'MenuIzquierdo'=>$MenuIzquierdo,'Carreras'=>$element);		
    return view('resultados/rjganadorcarr',$datos);

}

    
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
public function ListarCaballosInter()
{      
    //Verifico Sesion de Usuario
    if (!session()->get('isLogged')){
        $mensaje   = "Presione clic en su opcion de menu.";
        $claseMens = "alert alert-danger";
        $titleMens = "<strong>¡Error!</strong> </br>";   
        $datos = array('mensaje'=>$mensaje,'titleMens'=>$titleMens,'claseMens'=>$claseMens);		
        return view('estructura/ingresomalo.php',$datos);
    }

    $request=\Config\Services::request();
    $carr_id = $request->getPostGet('th'); 
    $hip_id = $request->getPostGet('th1');
    $fecha_carr = $request->getPostGet('th2');

    $datosUsuario= $this->SessionUser();
    $MenuIzquierdo = $this->MenuIzquierdo();
    $MenuIzquierdo[0]=" menu-open active";
    $MenuIzquierdo[1]="active";
    $MenuIzquierdo[2]="active";
    $usu_id = $datosUsuario['id'];
    $MontoActual = $this->MontoDisponible($usu_id);
    $dbSip = \Config\Database::connect('thSipacha', true);
    $Caballos = new Caballos($dbSip);  
    $Hipodromo = new Hipodromos($dbSip); 
    $Carreras = new Carreras($dbSip); 

    $ClasDiv   = "table-responsive table-hover";
    $ClasTabla = "table table-bordered table-striped";
    //$ClasDiv   ="";
    //$ClasTabla ="";  
    $idDiv     = ""; 
    $datosCarr = $Carreras -> find ($carr_id);
    $datosHip = $Hipodromo -> find ($hip_id);
    //echo "..............................................................................".".....".$hip_id;
    $builder = $Caballos -> builder ();
    $builder ->where('carr_id',$carr_id);  //
    $builder ->where('cab_posifinal<>','0'); 
    $builder->orderby('cab_posifinal','ASC');
    $datosCaballos = $builder->get(); 
    $element = $MontoActual;
    $element .= "   
    <div class='".$ClasDiv."' id='".$idDiv."'>
    <table class='".$ClasTabla."'> 
    <tr>
    <td colspan=3 style='background-color:#008080'><p style='color:#000000;'><B>Hipodromo&nbsp;".$datosHip['hip_nombre']."&nbsp;".cambiarfecha($fecha_carr)."</B></td>
    <td style='background-color:#008080'><p style='color:#000000;'> <b>CARRERA N: ".$datosCarr['carr_valida']." de ".$datosCarr['carr_metros']."&nbsp;metros</b></p></td></tr>     
    
    <tr> 
    <tr style='background-color:#008080'>
    <td style='background-color:#F7D358'> <b>N.</b></p></td>
    <td style='background-color:#F7D358'> <b>CABALLO</b></p></td>
    <td style='background-color:#F7D358'> <b>JINETE</b></p></td>
    <td style='background-color:#F7D358'> <b>POSICION</b></p></td>
    </tr>";
    foreach ($datosCaballos->getResultArray() as $row_item){

        if ($row_item['cab_estatus']==1) {  //Caballos Activos
            $element .= "  
            <tr>
            <td><small>".$row_item['cab_posinicial']."</small></td>
            <td><small>".$row_item['cab_nombre']."</small></td>
            <td><small>".$row_item['cab_jinete']."</small></td>
            <td><small>".$row_item['cab_posifinal']."</small></td>";            
            $element .= " 
            </tr>
            ";  
        }else {
            $element .= "  
            <tr style='background-color:red'>
            <td><small>".$row_item['cab_posinicial']."</small></td>
            <td><small>".$row_item['cab_nombre']."</small></td>
            <td><small>".$row_item['cab_jinete']."</small></td>
            <td> <small>";               
            $element .= "  RETIRADO</small> </td> </tr> ";              
        }
      
    }
    $element .="</tr></table>";
    //echo $element;
    
    $datos = array('datosHip'=>$datosHip,'datosUsuario'=>$datosUsuario,'MenuIzquierdo'=>$MenuIzquierdo,'Caballos'=>$element);		
    return view('resultados/rjganadorcab.php',$datos);

}


}