<?php namespace App\Controllers;
//Conexiones
use Config\Database;
$dbSip        = \Config\Database::connect('thSipacha', true);

//Controladores
use CodeIgniter\Controller;
//Modelos
use App\Models\Auditoria;
use App\Models\Usuarios;
use App\Models\Hipodromos;
use App\Models\Carreras;
use App\Models\Caballos;
use App\Models\Configuracion;
use App\Models\CarreraFin; 
use App\Models\Jremates;
use App\Models\Jrematesdevueltos;
//Librerias del Codeigneter4
$pager = \Config\Services::pager();

class ThResultadosDeRemates extends Th
{

    public function ListarHipodromos()
    {      
    //Verifico Sesion de Usuario
    if (!session()->get('isLogged')){
        $mensaje   = "Presione clic en su opcion de menu.";
        $claseMens = "alert alert-danger";
        $titleMens = "<strong>¡Error!</strong> </br>";   
        $datos = array('mensaje'=>$mensaje,'titleMens'=>$titleMens,'claseMens'=>$claseMens);		
        return view('estructura/ingresomalo.php',$datos);
    }  	
        $datosUsuario= $this->SessionUser();
        $MenuIzquierdo = $this->MenuIzquierdo();
        $usu_id = $datosUsuario['id'];
        $MontoActual = $this->MontoDisponible($usu_id);

        $MenuIzquierdo[0]=" menu-open active";
        $MenuIzquierdo[1]="active";
        $MenuIzquierdo[2]="active";
    
        $dbSip = \Config\Database::connect('thSipacha', true);
        $Carreras = new Carreras($dbSip);  
    
        $ClasDiv   = "table-responsive table-hover";
        $ClasTabla = "table table-bordered table-striped";  
        $idDiv     = ""; 

        $fechahoy= date("Y")."-".date("m")."-".date("d"); 
        $builder = $Carreras -> builder ();
        $builder -> distinct();
        $builder-> Select('carr_fecha as tab_jugada, hip_nombre, tab_hipodromos.hip_id');
        $builder->join('tab_hipodromos','tab_carrera.hip_id = tab_hipodromos.hip_id','inner');
        $builder->where('tab_hipodromos.hip_clasificacion', '1'); //Carreras Nacionales
        $builder->where('tab_hipodromos.hip_estatus', '1'); //Hipodromo Activo
        $builder->where('tab_carrera.carr_fecha>=', $fechahoy); //Fecha Activa >= HOY
        $datosCarreras = $builder->get(); 
        $element = $MontoActual;
        $element .= "        
        <div class='".$ClasDiv."' id='".$idDiv."'>
        <table class='".$ClasTabla."'> 
        <thead class='thead-dark'>
        <tr>
        <td style='background-color:#0b054a'><p style='color:#FFFFFF;'>
        <B>Hipodromos Nacionales</B></p></td></tr> 
        <tr> <tr><td>";
        foreach ($datosCarreras->getResultArray() as $row_item){
            $dia = saber_dia($row_item['tab_jugada']);
            /*$element .= " <td>           
            <a href='".BaseUrl()."ThResultadosDeRemates/ListarCarrerasNac?th1=".$row_item['tab_jugada']."&th=".$row_item['hip_id']."' > <i class='fas fa-horse'></i>&nbsp;&nbsp;".$row_item['hip_nombre']."&nbsp;&nbsp;".$dia."&nbsp;&nbsp;".cambiarfecha($row_item['tab_jugada'])." </a>
            </td></tr>";*/
            $element .= "   
            <form action='".BaseUrl()."/ThResultadosDeRemates/ListarCarrerasNac'>
            <input name='th' type='hidden' value='".$row_item['hip_id']."'>
            <input name='th1' type='hidden' value='".$row_item['tab_jugada']."'>
            <button type='submit' class='btn btn-outline-info btn-block'>
            ".$row_item['hip_nombre']."&nbsp;&nbsp;".$dia."&nbsp;&nbsp;".cambiarfecha($row_item['tab_jugada'])."            
            </button>
            
            </form>
            ";
        }
        $element .="</td></tr></table></div>";
        //echo $element;

        $fechahoy= date("Y")."-".date("m")."-".date("d"); 
        $builder = $Carreras -> builder ();
        $builder -> distinct();
        $builder-> Select('carr_fecha as tab_jugada, hip_nombre, tab_hipodromos.hip_id');
        $builder->join('tab_hipodromos','tab_carrera.hip_id = tab_hipodromos.hip_id','inner');
        $builder->where('tab_hipodromos.hip_clasificacion', '0'); //Carreras Internacionales
        $builder->where('tab_hipodromos.hip_estatus', '1'); //Hipodromo Activo
        $builder->where('tab_carrera.carr_fecha>=', $fechahoy); //Fecha Activa >= HOY
        $datosCarreras = $builder->get(); 
        
        $element2 = "        
        <div class='".$ClasDiv."' id='".$idDiv."'>
        <table class='".$ClasTabla."'> 
        <thead class='thead-dark'>
        <tr>
        <td style='background-color:#008080'><p style='color:#FFFFFF;'>
        <B>Hipodromos Nacionales</B></p></td></tr> 
        <tr> <tr><td>";
        foreach ($datosCarreras->getResultArray() as $row_item){
            $dia = saber_dia($row_item['tab_jugada']);
            /*$element2 .= " <td>           
            <a href='".BaseUrl()."ThResultadosDeRemates/ListarCarrerasNac?th1=".$row_item['tab_jugada']."&th=".$row_item['hip_id']."' > <i class='fas fa-horse'></i>&nbsp;&nbsp;".$row_item['hip_nombre']."&nbsp;&nbsp;".$dia."&nbsp;&nbsp;".cambiarfecha($row_item['tab_jugada'])." </a>
            </td></tr>";*/
            $element2 .= "   
            <form action='".BaseUrl()."/ThResultadosDeRemates/ListarCarrerasInter'>
            <input name='th' type='hidden' value='".$row_item['hip_id']."'>
            <input name='th1' type='hidden' value='".$row_item['tab_jugada']."'>
            <button type='submit' class='btn btn-outline-warning btn-block'>
            ".$row_item['hip_nombre']."&nbsp;&nbsp;".$dia."&nbsp;&nbsp;".cambiarfecha($row_item['tab_jugada'])."            
            </button>
            
            </form>
            ";
        }
        $element2 .="</td></tr></table></div>";        
        //$element2="";
        $datos = array('datosUsuario'=>$datosUsuario,'MenuIzquierdo'=>$MenuIzquierdo,'HipodromosNacionales'=>$element,'HipodromosInternacionales'=>$element2);		
        return view('resultados/rremateship.php',$datos);
    
    }

    
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
public function ListarCarrerasNac()
{      
    //Verifico Sesion de Usuario
    if (!session()->get('isLogged')){
        $mensaje   = "Presione clic en su opcion de menu.";
        $claseMens = "alert alert-danger";
        $titleMens = "<strong>¡Error!</strong> </br>";   
        $datos = array('mensaje'=>$mensaje,'titleMens'=>$titleMens,'claseMens'=>$claseMens);		
        return view('estructura/ingresomalo.php',$datos);
    }

    $request=\Config\Services::request();
    $hip_id = $request->getPostGet('th'); 
    $fecha_carr = $request->getPostGet('th1');

    $datosUsuario= $this->SessionUser();
    $MenuIzquierdo = $this->MenuIzquierdo();    
    $MenuIzquierdo[0]=" menu-open active";
    $MenuIzquierdo[1]="active";
    $MenuIzquierdo[2]="active";
    $usu_id = $datosUsuario['id'];
    $MontoActual = $this->MontoDisponible($usu_id);
    $dbSip = \Config\Database::connect('thSipacha', true);
    $Carreras = new Carreras($dbSip);  
    $Hipodromo = new Hipodromos($dbSip);  
    
    $ClasDiv   = "table-responsive table-hover";
    $ClasTabla = "table table-bordered table-striped";  
    $idDiv     = ""; 
    
    $datosHip = $Hipodromo -> find ($hip_id);

    $carr_fechahora_actual = fechaActualConHoraMySql();
    //echo "..............................................................................". $carr_fechahora_actual.".....".$hip_id;
    $builder = $Carreras -> builder ();
    $builder -> distinct();
    $builder-> Select("carr_valida as carrera, tab_carrera.carr_id, hip_id,carr_fecha,carr_horainicio,carr_horafin,carr_valida,carr_dia,carr_metros,carr_cabfav,carr_estatus,carr_comentario, CONCAT( carr_fecha,' ',carr_horafin ) as carr_fechafin");
    $builder->join('tab_carrerafin','tab_carrerafin.carr_id = tab_carrera.carr_id','inner');
    $builder->join('tab_caballos','tab_caballos.carr_id = tab_carrera.carr_id ','inner');
    $builder->where('tab_carrera.hip_id', $hip_id); //Hipodromo seleccionado
    //$builder->where('tab_carrera.carr_fecha>=', $carr_fechahora_actual); //FechaFinCarrera >= FechaHoraActual
    $builder->where('tab_caballos.cab_posifinal<>', '0'); //Caballo Que ya corrieron
    $builder->where('tab_carrera.carr_sem_cerrada', '0'); //Semana Abierta
    $builder->where('tab_carrera.carr_fecha',$fecha_carr); //Fecha selecionada
    $builder->orderBy('carr_valida','ASC');
    $datosCarreras = $builder->get(); 

    $element = $MontoActual;
    $element .= "  
    <div class='".$ClasDiv."' id='".$idDiv."'>
    <table class='".$ClasTabla."'> 
    <thead class='thead-dark'>
    <tr>
    <td style='background-color:#0b054a'><p style='color:#FFFFFF;'><B>HIPODROMO&nbsp;".$datosHip['hip_nombre']."&nbsp;".cambiarfecha($fecha_carr)."</B></p></td></tr> 
    <tr> <tr><td>";
    foreach ($datosCarreras->getResultArray() as $row_item){
        $mensaje="";     $claseMens="";     $titleMens="";
        $url = BaseUrl() . "/ThResultadosDeRemates/ListarCaballosNac/". $row_item['carr_id'] ."/".$row_item['hip_id']."/".$row_item['carr_fecha'] ."/0/0/0";
        //echo "<br>".$url ;
        $element .= "  
        <form action='".$url."'>
        <button type='submit' class='btn btn-outline-info btn-block'>
        Carrera&nbsp;&nbsp;".$row_item['carr_valida']."
        </button>
        </form>
        ";
    }
    $element .="</td></tr></table>";
    //echo $element;
    $datos = array('datosHip'=>$datosHip,'datosUsuario'=>$datosUsuario,'MenuIzquierdo'=>$MenuIzquierdo,'Carreras'=>$element);		
    return view('resultados/rrematescarr.php',$datos);

}

    
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
public function ListarCaballosNac($carr_id,$hip_id,$fecha_carr,$mensaje,$claseMens,$titleMens)
{      
    //Verifico Sesion de Usuario
    if (!session()->get('isLogged')){
        $mensaje   = "Presione clic en su opcion de menu.";
        $claseMens = "alert alert-danger";
        $titleMens = "<strong>¡Error!</strong> </br>";   
        $datos = array('mensaje'=>$mensaje,'titleMens'=>$titleMens,'claseMens'=>$claseMens);		
        return view('estructura/ingresomalo.php',$datos);
    }
    //RecogeFormPost(); 

    $request=\Config\Services::request();
    $mensaje   = str_replace("%20"," ", $mensaje); 
    $claseMens = str_replace("%20"," ", $claseMens);    

    $element ="";$element2 = "";
    $datosUsuario= $this->SessionUser();
    $MenuIzquierdo = $this->MenuIzquierdo();
    $dbSip = \Config\Database::connect('thSipacha', true);
    $Hipodromo = new Hipodromos($dbSip); 
    $Carreras = new Carreras($dbSip); 
    $Caballos = new Caballos($dbSip); 
    $Jremates = new Jremates($dbSip); 
    $Configuracion = new Configuracion($dbSip);
    $datosHip = $Hipodromo -> find ($hip_id);
    $datosCarr = $Carreras -> find ($carr_id);  
        
    $datosConf = $Configuracion -> find (1);    
    $usu_id = $datosUsuario['id'];
    $MontoActual = $this->MontoDisponible($usu_id);
    $builder = $Jremates -> builder ();
    $builder->where('carr_id=', $carr_id); //Carrera Seleccionada
    $datosRemates = $builder->get(); 

    //Validación La Carrera este abierta
    $fecha_actual = strtotime(date("d-m-Y H:i:00",time()));  //$fecha_actual = strtotime("2020-06-28 17:20:00");
    //$fecha_carrera = strtotime("2020-07-28 17:20:00"); 
    $fecha_carrera = strtotime($datosCarr['carr_fecha']." ".$datosCarr['carr_horafin']);

    if($fecha_actual >= $fecha_carrera){
        echo "Carrera Cerrada, No se pudo efectuar la jugada";
        exit();
    }

    $ClasDiv   = "";
    $ClasTabla = "";     
    $idDiv     = ""; 
    foreach ($datosRemates->getResultArray() as $row_item){
        $datosCaballos = $Caballos -> find ($row_item['cab_id']); 
        //$rem_montoNuevo = $this-> rem_montoNuevo($row_item['rem_montojugada'],$datosConf);                  
        $rem_montoNuevo=0;
        if ($datosCaballos['cab_estatus']==1) {  //Caballos Activos
            if ($datosCaballos['cab_posifinal']==1) {  //Caballos Activos
                $element2 .= "  
                <tr style='background-color:#A9F5BC'>
                <td ><small>".$row_item['usu_login']."</small></td>
                <td ><small> ".$datosCaballos['cab_posinicial']."</small></td>
                <td ><small> ".$datosCaballos['cab_nombre']."</small></td>
                <td ><small> ".number_format($row_item['rem_montojugada'], 2,',', '.')."</small></td>";
                $element2 .= "</tr>";                 
            } else {            
                $element2 .= "  
                <tr>
                <td ><small>".$row_item['usu_login']."</small></td>
                <td ><small> ".$datosCaballos['cab_posinicial']."</small></td>
                <td ><small> ".$datosCaballos['cab_nombre']."</small></td>
                <td ><small> ".number_format($row_item['rem_montojugada'], 2,',', '.')."</small></td>";
                $element2 .= "</tr>"; 
            } 
        }else {              
            $element2 .= "  
            <tr style='background-color:red'>
            <td><small>".$row_item['usu_login']."</small></td>
            <td><small>".$datosCaballos['cab_posinicial']."</small></td>
            <td><small>".$datosCaballos['cab_nombre']."</small></td>
            <td><small>".number_format($row_item['rem_montojugada'], 2,',', '.')."</small></td>";
        }
        $premio = $row_item['rem_premiorep']; 
    }

    $element = "<small></small>&nbsp;&nbsp;&nbsp;&nbsp;".
    $MontoActual . "
    <div align=center class='".$ClasDiv."' id='".$idDiv."'>
    <table border = '1' class='".$ClasTabla."'> 
    <tr>
    <td colspan=2 style='background-color:#0b054a'><p style='color:#FFFFFF;'><B>".$datosHip['hip_nombre']."&nbsp;".cambiarfecha($fecha_carr)."</B></td>
    <td style='background-color:#0b054a'><p style='color:#FFFFFF;'><b>CARRERA N: ".$datosCarr['carr_valida']."</b></p></td>
    <td style='background-color:#0b054a' colspan=2><p style='color:#FFFFFF;'><b>Premio Bs.</b>".number_format($premio, 2,',', '.')."</p></td>
    </tr> 
    <tr> 
    <tr style='background-color:#0b054a'>
    <td style='background-color:#3b83bd'> <small> <b>USUARIO</b></small> </td>
    <td style='background-color:#3b83bd'> <small> <b>N</b></small></td>
    <td style='background-color:#3b83bd'> <small> <b>CABALLO</b></small></td>
    <td style='background-color:#3b83bd'> <small> <b>VENDIDO</b></small></td>
    </tr>";
    
    
    $element  = $element . $element2 ;
    $datos = array('datosHip'=>$datosHip,'datosUsuario'=>$datosUsuario,'MenuIzquierdo'=>$MenuIzquierdo,'Caballos'=>$element,'mensaje'=>$mensaje,'titleMens'=>$titleMens,'claseMens'=>$claseMens,'carr_id'=>$carr_id,'hip_id'=>$hip_id,'fecha_carr'=>$fecha_carr);
    return view('resultados/rrematescab.php',$datos);
}

    
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
public function ListarCarrerasInter()
{      
    //Verifico Sesion de Usuario
    if (!session()->get('isLogged')){
        $mensaje   = "Presione clic en su opcion de menu.";
        $claseMens = "alert alert-danger";
        $titleMens = "<strong>¡Error!</strong> </br>";   
        $datos = array('mensaje'=>$mensaje,'titleMens'=>$titleMens,'claseMens'=>$claseMens);		
        return view('estructura/ingresomalo.php',$datos);
    }

    $request=\Config\Services::request();
    $hip_id = $request->getPostGet('th'); 
    $fecha_carr = $request->getPostGet('th1');

    $datosUsuario= $this->SessionUser();
    $MenuIzquierdo = $this->MenuIzquierdo();    
    $MenuIzquierdo[0]=" menu-open active";
    $MenuIzquierdo[1]="active";
    $MenuIzquierdo[2]="active";
    $usu_id = $datosUsuario['id'];
    $MontoActual = $this->MontoDisponible($usu_id);
    $dbSip = \Config\Database::connect('thSipacha', true);
    $Carreras = new Carreras($dbSip);  
    $Hipodromo = new Hipodromos($dbSip);  
    
    $ClasDiv   = "table-responsive table-hover";
    $ClasTabla = "table table-bordered table-striped";  
    $idDiv     = ""; 
    
    $datosHip = $Hipodromo -> find ($hip_id);

    $carr_fechahora_actual = fechaActualConHoraMySql();
    //echo "..............................................................................". $carr_fechahora_actual.".....".$hip_id;
    $builder = $Carreras -> builder ();
    $builder -> distinct();
    $builder-> Select("carr_valida as carrera, tab_carrera.carr_id, hip_id,carr_fecha,carr_horainicio,carr_horafin,carr_valida,carr_dia,carr_metros,carr_cabfav,carr_estatus,carr_comentario, CONCAT( carr_fecha,' ',carr_horafin ) as carr_fechafin");
    $builder->join('tab_carrerafin','tab_carrerafin.carr_id = tab_carrera.carr_id','inner');
    $builder->join('tab_caballos','tab_caballos.carr_id = tab_carrera.carr_id ','inner');
    $builder->where('tab_carrera.hip_id', $hip_id); //Hipodromo seleccionado
    $builder->where('tab_carrera.carr_fecha>=', $carr_fechahora_actual); //FechaFinCarrera >= FechaHoraActual
    $builder->where('tab_caballos.cab_posifinal', '0'); //Caballo PorCorrer
    $builder->where('tab_carrera.carr_sem_cerrada', '0'); //Semana Abierta
    //$builder->where('tab_carrera.carr_fecha',$fecha_carr); //Fecha selecionada
    $builder->orderBy('carr_valida','ASC');
    $datosCarreras = $builder->get(); 

    $element = $MontoActual;
    $element .= "  
    <div class='".$ClasDiv."' id='".$idDiv."'>
    <table class='".$ClasTabla."'> 
    <thead class='thead-dark'>
    <tr>
    <td style='background-color:#008080'><p style='color:#000000;'><B>HIPODROMO&nbsp;".$datosHip['hip_nombre']."&nbsp;".cambiarfecha($fecha_carr)."</B></p></td></tr> 
    <tr> <tr><td>";
    foreach ($datosCarreras->getResultArray() as $row_item){
        $mensaje="";     $claseMens="";     $titleMens="";
        $url = BaseUrl() . "/ThResultadosDeRemates/ListarCaballosInter/". $row_item['carr_id'] ."/".$row_item['hip_id']."/".$row_item['carr_fecha'] ."/0/0/0";
        //echo "<br>".$url ;
        $element .= "  
        <form action='".$url."'>
        <button type='submit' class='btn btn-outline-warning btn-block'>
        Carrera&nbsp;&nbsp;".$row_item['carr_valida']."
        </button>
        </form>
        ";
    }
    $element .="</td></tr></table>";
    //echo $element;
    $datos = array('datosHip'=>$datosHip,'datosUsuario'=>$datosUsuario,'MenuIzquierdo'=>$MenuIzquierdo,'Carreras'=>$element);		
    return view('resultados/rrematescarr.php',$datos);

}

    
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
public function ListarCaballosInter($carr_id,$hip_id,$fecha_carr,$mensaje,$claseMens,$titleMens)
{      
    //Verifico Sesion de Usuario
    if (!session()->get('isLogged')){
        $mensaje   = "Presione clic en su opcion de menu.";
        $claseMens = "alert alert-danger";
        $titleMens = "<strong>¡Error!</strong> </br>";   
        $datos = array('mensaje'=>$mensaje,'titleMens'=>$titleMens,'claseMens'=>$claseMens);		
        return view('estructura/ingresomalo.php',$datos);
    }
    //RecogeFormPost(); 

    $request=\Config\Services::request();
    $mensaje   = str_replace("%20"," ", $mensaje); 
    $claseMens = str_replace("%20"," ", $claseMens);    

    $element ="";$element2 = "";
    $datosUsuario= $this->SessionUser();
    $MenuIzquierdo = $this->MenuIzquierdo();
    $dbSip = \Config\Database::connect('thSipacha', true);
    $Hipodromo = new Hipodromos($dbSip); 
    $Carreras = new Carreras($dbSip); 
    $Caballos = new Caballos($dbSip); 
    $Jremates = new Jremates($dbSip); 
    $Configuracion = new Configuracion($dbSip);
    $datosHip = $Hipodromo -> find ($hip_id);
    $datosCarr = $Carreras -> find ($carr_id);  
        
    $datosConf = $Configuracion -> find (1);    
    $usu_id = $datosUsuario['id'];
    $MontoActual = $this->MontoDisponible($usu_id);
    $builder = $Jremates -> builder ();
    $builder->where('carr_id=', $carr_id); //Carrera Seleccionada
    $datosRemates = $builder->get(); 

    //Validación La Carrera este abierta
    $fecha_actual = strtotime(date("d-m-Y H:i:00",time()));  //$fecha_actual = strtotime("2020-06-28 17:20:00");
    //$fecha_carrera = strtotime("2020-07-28 17:20:00"); 
    $fecha_carrera = strtotime($datosCarr['carr_fecha']." ".$datosCarr['carr_horafin']);

    if($fecha_actual >= $fecha_carrera){
        echo "Carrera Cerrada, No se pudo efectuar la jugada";
        exit();
    }

    $ClasDiv   = "";
    $ClasTabla = "";     
    $idDiv     = ""; 
    foreach ($datosRemates->getResultArray() as $row_item){
        $datosCaballos = $Caballos -> find ($row_item['cab_id']); 
        //$rem_montoNuevo = $this-> rem_montoNuevo($row_item['rem_montojugada'],$datosConf);                  
        $rem_montoNuevo=0;
        if ($datosCaballos['cab_estatus']==1) {  //Caballos Activos
            if ($datosCaballos['cab_posifinal']==1) {  //Caballos Activos
                $element2 .= "  
                <tr style='background-color:#A9F5BC'>
                <td ><small>".$row_item['usu_login']."</small></td>
                <td ><small> ".$datosCaballos['cab_posinicial']."</small></td>
                <td ><small> ".$datosCaballos['cab_nombre']."</small></td>
                <td ><small> ".number_format($row_item['rem_montojugada'], 2,',', '.')."</small></td>";
                $element2 .= "</tr>";                 
            } else {            
                $element2 .= "  
                <tr>
                <td ><small>".$row_item['usu_login']."</small></td>
                <td ><small> ".$datosCaballos['cab_posinicial']."</small></td>
                <td ><small> ".$datosCaballos['cab_nombre']."</small></td>
                <td ><small> ".number_format($row_item['rem_montojugada'], 2,',', '.')."</small></td>";
                $element2 .= "</tr>"; 
            } 
        }else {            
            $element2 .= "  
            <tr style='background-color:red'>
            <td><small>".$row_item['usu_login']."</small></td>
            <td><small>".$datosCaballos['cab_posinicial']."</small></td>
            <td><small>".$datosCaballos['cab_nombre']."</small></td>
            <td><small>".number_format($row_item['rem_montojugada'], 2,',', '.')."</small></td>";
        }
        $premio = $row_item['rem_premiorep']; 
    }

    $element = "<small></small>&nbsp;&nbsp;&nbsp;&nbsp;".
    $MontoActual . "
    <div align=center class='".$ClasDiv."' id='".$idDiv."'>
    <table border = '1' class='".$ClasTabla."'> 
    <tr>
    <td colspan=2 style='background-color:#008080'><p style='color:#000000;'><B>".$datosHip['hip_nombre']."&nbsp;".cambiarfecha($fecha_carr)."</B></td>
    <td style='background-color:#008080'><p style='color:#000000;'><b>CARRERA N: ".$datosCarr['carr_valida']."</b></p></td>
    <td style='background-color:#008080' colspan=2><p style='color:#000000;'><b>Premio Bs.</b>".number_format($premio, 2,',', '.')."</p></td>
    </tr> 
    <tr> 
    <tr style='background-color:#008080'>
    <td style='background-color:#F7D358'> <small> <b>USUARIO</b></small> </td>
    <td style='background-color:#F7D358'> <small> <b>N</b></small></td>
    <td style='background-color:#F7D358'> <small> <b>CABALLO</b></small></td>
    <td style='background-color:#F7D358'> <small> <b>VENDIDO</b></small></td>
    </tr>";
    
    
    $element  = $element . $element2 ;
    $datos = array('datosHip'=>$datosHip,'datosUsuario'=>$datosUsuario,'MenuIzquierdo'=>$MenuIzquierdo,'Caballos'=>$element,'mensaje'=>$mensaje,'titleMens'=>$titleMens,'claseMens'=>$claseMens,'carr_id'=>$carr_id,'hip_id'=>$hip_id,'fecha_carr'=>$fecha_carr);
    return view('resultados/rrematescab.php',$datos);
}
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


}