<?php namespace App\Controllers;
//Conexiones
//Controlador Th
//Controladores
use CodeIgniter\Controller;
//Modelos
use App\Models\Auditoria;
use App\Models\Usuarios;
use App\Models\Hipodromos;
use App\Models\Carreras;
use App\Models\Caballos;
use App\Models\Configuracion;
use App\Models\PollasMaestro;
use App\Models\PollasJugadas;
//Librerias del Codeigneter4
$pager = \Config\Services::pager();

class ThResultadosDePollas extends Th
{
    public function ListarHipodromos()
    {      
    //Verifico Sesion de Usuario
    if (!session()->get('isLogged')){
        $mensaje   = "Presione clic en su opcion de menu.";
        $claseMens = "alert alert-danger";
        $titleMens = "<strong>¡Error!</strong> </br>";   
        $datos = array('mensaje'=>$mensaje,'titleMens'=>$titleMens,'claseMens'=>$claseMens);		
        return view('estructura/ingresomalo.php',$datos);
    }  	
        $datosUsuario= $this->SessionUser();
        $usu_id = $datosUsuario['id'];
        $MontoActual = $this->MontoDisponible($usu_id);
        $MenuIzquierdo = $this->MenuIzquierdo();
        $MenuIzquierdo[0]=" menu-open active";
        $MenuIzquierdo[1]="active";
        $MenuIzquierdo[2]="active";
    
        $dbSip = \Config\Database::connect('thSipacha', true);
        $Carreras = new Carreras($dbSip);  
        $PollasMaestro = new PollasMaestro($dbSip);  
        
        //Inicio Hipodromos Nacionales
        $ClasDiv   = "table-responsive table-hover";
        $ClasTabla = "table table-bordered table-striped";  
        $idDiv     = ""; 
        $fechahoy= date("Y")."-".date("m")."-".date("d"); 
        $builder = $PollasMaestro -> builder ();
        //$queryNac = "SELECT DISTINCT tab_jugada, hip_nombre, tab_hipodromos.hip_id 
        //FROM tab_tablapollamaestro 
        //INNER JOIN tab_hipodromos ON tab_tablapollamaestro.hip_id = tab_hipodromos.hip_id 
        //WHERE tab_estatus =  '1' AND hip_estatus=1 AND hip_clasificacion=1  
        //ORDER BY tab_jugada";
        $builder -> distinct();
        $builder-> Select('tab_jugada, hip_nombre, tab_hipodromos.hip_id');
        $builder->join('tab_hipodromos','tab_tablapollamaestro.hip_id = tab_hipodromos.hip_id','inner');
        $builder->where('tab_hipodromos.hip_clasificacion', '1'); //Carreras Nacionales
        $builder->where('tab_hipodromos.hip_estatus', '1'); //Hipodromo Activo
        $builder->where('tab_jugada>=', $fechahoy); //Fecha Activa < HOY Polla Cerrada
        $datosPollas = $builder->get(); 
        $element = $MontoActual;
        $element .= "   
        <div class='".$ClasDiv."' id='".$idDiv."'>
        <table class='".$ClasTabla."'> 
        <thead class='thead-dark'>
        <tr>
        <td style='background-color:#0b054a'><p style='color:#FFFFFF;'><B>Hipodromos Nacionales</B></p></td></tr> 
        <tr> <tr><td>";
        foreach ($datosPollas->getResultArray() as $row_item){
            $dia = saber_dia($row_item['tab_jugada']);
            $element .= "   
            <form  method='post' action='".BaseUrl()."/ThResultadosDePollas/ListarPollasNac'  method='post'>
            <input name='th' type='hidden' value='".$row_item['hip_id']."'>
            <input name='th1' type='hidden' value='".$row_item['tab_jugada']."'>
            <button type='submit' class='btn btn-outline-info btn-block'>
            ".$row_item['hip_nombre']."&nbsp;&nbsp;".$dia."&nbsp;&nbsp;".cambiarfecha($row_item['tab_jugada'])."            
            </button>
            </form>
            ";
        }
        $element .="</td></tr></table>";
        //echo $element;
        //Fin Hipodromos Nacionales
        $fechahoy= date("Y")."-".date("m")."-".date("d"); 
        $builder = $PollasMaestro -> builder ();
        $builder -> distinct();
        $builder-> Select('tab_jugada as tab_jugada, hip_nombre, tab_hipodromos.hip_id');
        $builder->join('tab_hipodromos','tab_tablapollamaestro.hip_id = tab_hipodromos.hip_id','inner');
        $builder->where('tab_hipodromos.hip_clasificacion', '0'); //Carreras Internacionales
        $builder->where('tab_hipodromos.hip_estatus', '1'); //Hipodromo Activo
        $builder->where('tab_jugada>=', $fechahoy); //Fecha Activa >= HOY
        $datosPollas = $builder->get(); 
        //$element2 = $MontoActual;
        $element2 = "   
        <div class='".$ClasDiv."' id='".$idDiv."'>
        <table class='".$ClasTabla."'> 
        <thead class='thead-dark'>
        <tr>
        <td style='background-color:#008080'><p style='color:#FFFFFF;'><B>Hipodromos Internacionales</B></p></td></tr> 
        <tr> <tr><td>";
        foreach ($datosPollas->getResultArray() as $row_item){
            $dia = saber_dia($row_item['tab_jugada']);
            /*$element2 .= " <td>           
            <a href='".BaseUrl()."ThJugadasAGanadorNac/ListarCarrerasNac?th1=".$row_item['tab_jugada']."&th=".$row_item['hip_id']."' > <i class='fas fa-horse'></i>&nbsp;&nbsp;".$row_item['hip_nombre']."&nbsp;&nbsp;".$dia."&nbsp;&nbsp;".cambiarfecha($row_item['tab_jugada'])." </a>
            </td></tr>";*/
            $element2 .= "   
            <form  method='post' action='".BaseUrl()."/ThResultadosDePollas/ListarPollasInt'>
            <input name='th' type='hidden' value='".$row_item['hip_id']."'>
            <input name='th1' type='hidden' value='".$row_item['tab_jugada']."'>
            <button type='submit' class='btn btn-outline-warning btn-block'>
            ".$row_item['hip_nombre']."&nbsp;&nbsp;".$dia."&nbsp;&nbsp;".cambiarfecha($row_item['tab_jugada'])."            
            </button>
            
            </form>
            ";
        }
        $element2 .="</td></tr></table>";
        //echo $element2;        
        //Inicio Hipodromos Internacionales


        //Fin Hipodromos Internacionales
        $datos = array('datosUsuario'=>$datosUsuario,'MenuIzquierdo'=>$MenuIzquierdo,'HipodromosNacionales'=>$element,'HipodromosInternacionales'=>$element2);		
        return view('resultados/rpollaship.php',$datos);
    
    }

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
public function ListarPollasNac(){    
    //Verifico Sesion de Usuario
    if (!session()->get('isLogged')){
        $mensaje   = "Presione clic en su opcion de menu.";
        $claseMens = "alert alert-danger";
        $titleMens = "<strong>¡Error!</strong> </br>";   
        $datos = array('mensaje'=>$mensaje,'titleMens'=>$titleMens,'claseMens'=>$claseMens);		
        return view('estructura/ingresomalo.php',$datos);
    }  	
    $request=\Config\Services::request();
    $hip_id = $request->getPostGet('th'); 
    $fecha_carr = $request->getPostGet('th1');

        $datosUsuario= $this->SessionUser();
        $usu_id = $datosUsuario['id'];
        $MontoActual = $this->MontoDisponible($usu_id);
        $MenuIzquierdo = $this->MenuIzquierdo();
        $MenuIzquierdo[0]=" menu-open active";
        $MenuIzquierdo[1]="active";
        $MenuIzquierdo[2]="active";
    
        $dbSip = \Config\Database::connect('thSipacha', true);
        $PollasMaestro = new PollasMaestro($dbSip);  
    
        $ClasDiv   = "table-responsive table-hover";
        $ClasTabla = "table table-bordered table-striped";  
        $idDiv     = ""; 

        $actual = fechaActualConHoraMySql();
        $builder = $PollasMaestro -> builder ();
        $builder -> distinct();
        $builder-> Select("tab_id, CONCAT( tab_nombre,  ' en ', hip_nombre ,' del ', CONCAT(DAY( tab_jugada ) ,'/', MONTH( tab_cierre ),'/',YEAR( tab_cierre )), ' por Bs. ' , tab_monto) as boton, tab_carreras");
        $builder->join('tab_hipodromos','tab_tablapollamaestro.hip_id = tab_hipodromos.hip_id','inner');
        $builder->where('tab_estatus', '1'); //Polla Activa
        $builder->where('tab_tablapollamaestro.hip_id', $hip_id); //Hipodromo Seleccionado
        $builder->where('tab_jugada=', $fecha_carr); //Fecha de Polla
        $datosPollas = $builder->get(); 
        $element = $MontoActual;
        $element .= "   
        <div class='".$ClasDiv."' id='".$idDiv."'>
        <table class='".$ClasTabla."'> 
        <thead class='thead-dark'>
        <tr>
        <td style='background-color:#0b054a'><p style='color:#FFFFFF;'><B>Pollas Nacionales</B></p></td></tr> 
        <tr> <tr><td>";
        foreach ($datosPollas->getResultArray() as $row_item){
            $element .= "   
            <form action='".BaseUrl()."/ThResultadosDePollas/ResultadosPollasNac'  method='post'>
            <input name='th' type='hidden' value='".$row_item['tab_id']."'>
            <button type='submit' class='btn btn-outline-info btn-block'>
            ".$row_item['boton']."&nbsp;&nbsp;         
            </button>
            
            </form>
            ";
        }
        $element .="</td></tr></table>";
        //echo $element;
    
        $datos = array('datosUsuario'=>$datosUsuario,'MenuIzquierdo'=>$MenuIzquierdo,'Pollas'=>$element);		
        return view('resultados/rpollas.php',$datos);
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
public function ListarPollasInt(){    
    //Verifico Sesion de Usuario
    if (!session()->get('isLogged')){
        $mensaje   = "Presione clic en su opcion de menu.";
        $claseMens = "alert alert-danger";
        $titleMens = "<strong>¡Error!</strong> </br>";   
        $datos = array('mensaje'=>$mensaje,'titleMens'=>$titleMens,'claseMens'=>$claseMens);		
        return view('estructura/ingresomalo.php',$datos);
    }  	
    $request=\Config\Services::request();
    $hip_id = $request->getPostGet('th'); 
    $fecha_carr = $request->getPostGet('th1');

        $datosUsuario= $this->SessionUser();
        $usu_id = $datosUsuario['id'];
        $MontoActual = $this->MontoDisponible($usu_id);
        $MenuIzquierdo = $this->MenuIzquierdo();
        $MenuIzquierdo[0]=" menu-open active";
        $MenuIzquierdo[1]="active";
        $MenuIzquierdo[2]="active";
    
        $dbSip = \Config\Database::connect('thSipacha', true);
        $PollasMaestro = new PollasMaestro($dbSip);  
    
        $ClasDiv   = "table-responsive table-hover";
        $ClasTabla = "table table-bordered table-striped";  
        $idDiv     = ""; 

        $actual = fechaActualConHoraMySql();
        $builder = $PollasMaestro -> builder ();
        $builder -> distinct();
        $builder-> Select("tab_id, CONCAT( tab_nombre,  ' en ', hip_nombre ,' del ', CONCAT(DAY( tab_jugada ) ,'/', MONTH( tab_cierre ),'/',YEAR( tab_cierre )), ' por Bs. ' , tab_monto) as boton, tab_carreras");
        $builder->join('tab_hipodromos','tab_tablapollamaestro.hip_id = tab_hipodromos.hip_id','inner');
        $builder->where('tab_estatus', '1'); //Polla Activa
        $builder->where('tab_tablapollamaestro.hip_id', $hip_id); //Hipodromo Seleccionado
        $builder->where('tab_jugada=', $fecha_carr); //Fecha de Polla
        $datosPollas = $builder->get(); 
        $element = $MontoActual;
        $element .= "   
        <div class='".$ClasDiv."' id='".$idDiv."'>
        <table class='".$ClasTabla."'> 
        <thead class='thead-dark'>
        <tr>
        <td style='background-color:#008080'><p style='color:#000000;'><B>Pollas Internacionales</B></p></td></tr> 
        <tr> <tr><td>";
        foreach ($datosPollas->getResultArray() as $row_item){
            $element .= "   
            <form action='".BaseUrl()."/ThResultadosDePollas/ResultadosPollasInter'  method='post'>
            <input name='th' type='hidden' value='".$row_item['tab_id']."'>
            <button type='submit' class='btn btn-outline-warning btn-block'>
            ".$row_item['boton']."&nbsp;&nbsp;         
            </button>
            
            </form>
            ";
        }
        $element .="</td></tr></table>";
        //echo $element;
    
        $datos = array('datosUsuario'=>$datosUsuario,'MenuIzquierdo'=>$MenuIzquierdo,'Pollas'=>$element);		
        return view('resultados/rpollas.php',$datos);
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
public function ResultadosPollasNac()
{      
    RecogeFormPost();
   
    //Verifico Sesion de Usuario
    if (!session()->get('isLogged')){
        $mensaje   = "Presione clic en su opcion de menu.";
        $claseMens = "alert alert-danger";
        $titleMens = "<strong>¡Error!</strong> </br>";   
        $datos = array('mensaje'=>$mensaje,'titleMens'=>$titleMens,'claseMens'=>$claseMens);		
        return view('estructura/ingresomalo.php',$datos);
    }  
    $datosUsuario= $this->SessionUser();
    $usu_id = $datosUsuario['id'];
    $MontoActual = $this->MontoDisponible($usu_id);
    $MenuIzquierdo = $this->MenuIzquierdo();

    $request=\Config\Services::request();
    $tab_id = $request->getPostGet('th'); 
    
    $dbSip = \Config\Database::connect('thSipacha', true);
    $PollasMaestro = new PollasMaestro($dbSip); 
    $PollasJugadas = new PollasJugadas($dbSip); 
    $Hipodromo = new Hipodromos($dbSip); 
    $Caballos = new Caballos($dbSip); 
    $datosPollas = $PollasMaestro -> find ($tab_id);
    $datosHip = $Hipodromo -> find ($datosPollas['hip_id']);
    $builder = $PollasJugadas -> builder ();
    $builder->where('tab_id', $tab_id); //Polla Activa
    $builder->orderby('tab_tablapollasjugadas.tjug_suma','DESC');    
    $builder->orderby('tab_tablapollasjugadas.usu_id','ASC');   
    $datosPollasJugadas = $builder->get();  
    $TotalPollasSelladas = $datosPollasJugadas->resultID->num_rows; 
    $ClasDiv   = "table-responsive table-hover";
    $ClasTabla = "table-responsive table-hover";  
    $idDiv     = ""; 
    $element = $MontoActual;
    $element .= "   
    <div class='".$ClasDiv."' id='".$idDiv."' align=center>
    <table border=1 class='".$ClasTabla."'> 
    <tr>
    <td colspan=14 style='background-color:#0b054a'><p style='color:#FFFFFF;'><B>HIPODROMO&nbsp;".$datosHip['hip_nombre']."&nbsp;".cambiarfecha($datosPollas['tab_jugada'])." <br> ".$datosPollas['tab_nombre']."</B></p></td>
    <tr>
    <td colspan=7><p style='color:#000000;'>";
    if (trim($datosPollas['tab_pote'])==""){
        $element .= "<B></B></p></td>";
    } else{
        $element .= "<B>Pote:".$datosPollas['tab_pote']."</B></p></td>";
    }
    $element .= "  
    <td colspan=7><p style='color:red;'>
    <B>Paga Bs. ".  number_format($datosPollas['tab_paga'], 2,',', '.')."</B></p></td>    
    </tr> 
    <tr>
    <td colspan=14 style='background-color:#3b83bd' align=center><p style='color:#000000;'><B><small>Total Pollas Selladas:".$TotalPollasSelladas ."</small></B></p></td>
    <tr>        
    <tr>";
    $x=0;
    $element .= "<td style='background-color:#3b83bd'><p style='color:#FFFFFF;'><B> USUARIO</b></p></td>";    
    foreach ($datosPollasJugadas->getResultArray() as $row_item){
        $suma = 0;
        $carreras = explode(",", $row_item['tjug_combcarrvalidas']);
        $tcarr = count($carreras);
        $caballosPosIni = explode(",", $row_item['tjug_combcabvalidas']); 
        $tcarr = count($carreras);       
        $caballos = explode(",", $row_item['tjug_comb']);

        if ($x==0){
        for ($i=0;$i<$tcarr;$i++){
            $element .= "<td style='background-color:#3b83bd'><p style='color:#FFFFFF;'><B>C: ".$carreras[$i]." </b></p></td>";              
            $element .= "<td style='background-color:#3b83bd'><p style='color:#FFFFFF;'><B>P: ".$carreras[$i]." </b></p></td>";
        } 
        $element .= "<td style='background-color:#3b83bd'><p style='color:#FFFFFF;'><B> &nbsp; Total &nbsp; </b></p></td>";      
        }
        if ($row_item['usu_id']==$usu_id){
            $element .= "</tr><tr style='background-color:#A9F5BC'>";
        } else{
            $element .= "</tr><tr>";
        }
        
        $element .= "<td>".$row_item['usu_login']."</td>";              
        for ($i=0;$i<$tcarr;$i++){
            $datosCaballo = $Caballos -> find ($caballos[$i]);
            $puntos =0;
            if ($datosCaballo['cab_posifinal']==1){
                $puntos = $datosPollas['tab_ptos1'];
            }
            if ($datosCaballo['cab_posifinal']==2){
                $puntos = $datosPollas['tab_ptos2'];
            } 
            if ($datosCaballo['cab_posifinal']==3){
                $puntos = $datosPollas['tab_ptos3'];
            }     
            $suma = $suma + $puntos;                   
            $element .= "<td align=center>".$caballosPosIni[$i]."</td>";                                
            $element .= "<td align=center>".$puntos."</td>";                                
        }         
        $element .= "<td align=center>".$suma."</td>";                                
        
        $x= $x+1;

    }
    $element .="</td></tr></table>";        
    
    $datos = array('datosUsuario'=>$datosUsuario,'MenuIzquierdo'=>$MenuIzquierdo,'Pollas'=>$element);		
    return view('resultados/rpollas.php',$datos);    
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
public function ResultadosPollasInter()
{      
    RecogeFormPost();
   
    //Verifico Sesion de Usuario
    if (!session()->get('isLogged')){
        $mensaje   = "Presione clic en su opcion de menu.";
        $claseMens = "alert alert-danger";
        $titleMens = "<strong>¡Error!</strong> </br>";   
        $datos = array('mensaje'=>$mensaje,'titleMens'=>$titleMens,'claseMens'=>$claseMens);		
        return view('estructura/ingresomalo.php',$datos);
    }  
    $datosUsuario= $this->SessionUser();
    $usu_id = $datosUsuario['id'];
    $MontoActual = $this->MontoDisponible($usu_id);
    $MenuIzquierdo = $this->MenuIzquierdo();

    $request=\Config\Services::request();
    $tab_id = $request->getPostGet('th'); 
    
    $dbSip = \Config\Database::connect('thSipacha', true);
    $PollasMaestro = new PollasMaestro($dbSip); 
    $PollasJugadas = new PollasJugadas($dbSip); 
    $Hipodromo = new Hipodromos($dbSip); 
    $Caballos = new Caballos($dbSip); 
    $datosPollas = $PollasMaestro -> find ($tab_id);
    $datosHip = $Hipodromo -> find ($datosPollas['hip_id']);
    $builder = $PollasJugadas -> builder ();
    $builder->where('tab_id', $tab_id); //Polla Activa
    $builder->orderby('tab_tablapollasjugadas.tjug_suma','DESC');    
    $builder->orderby('tab_tablapollasjugadas.usu_id','ASC');   
    $datosPollasJugadas = $builder->get();  
    $TotalPollasSelladas = $datosPollasJugadas->resultID->num_rows; 
    $ClasDiv   = "table-responsive table-hover";
    $ClasTabla = "table-responsive table-hover";  
    $idDiv     = ""; 
    $element = $MontoActual;
    $element .= "   
    <div class='".$ClasDiv."' id='".$idDiv."' align=center>
    <table border=1 class='".$ClasTabla."'> 
    <tr>
    <td colspan=14 style='background-color:#008080'><p style='color:#000000;'><B>HIPODROMO&nbsp;".$datosHip['hip_nombre']."&nbsp;".cambiarfecha($datosPollas['tab_jugada'])." <br> ".$datosPollas['tab_nombre']."</B></p></td>
    <tr>
    <td colspan=7><p style='color:#000000;'>";
    if (trim($datosPollas['tab_pote'])==""){
        $element .= "<B></B></p></td>";
    } else{
        $element .= "<B>Pote:".$datosPollas['tab_pote']."</B></p></td>";
    }
    $element .= "  
    <td colspan=7><p style='color:red;'>
    <B>Paga Bs. ".  number_format($datosPollas['tab_paga'], 2,',', '.')."</B></p></td>    
    </tr> 
    <tr>
    <td colspan=14 style='background-color:#F7D358' align=center><p style='color:#000000;'><B><small>Total Pollas Selladas:".$TotalPollasSelladas ."</small></B></p></td>
    <tr>        
    <tr>";
    $x=0;
    $element .= "<td style='background-color:#F7D358'><p style='color:#000000;'><B> USUARIO</b></p></td>";    
    foreach ($datosPollasJugadas->getResultArray() as $row_item){
        $suma = 0;
        $carreras = explode(",", $row_item['tjug_combcarrvalidas']);
        $tcarr = count($carreras);
        $caballosPosIni = explode(",", $row_item['tjug_combcabvalidas']); 
        $tcarr = count($carreras);       
        $caballos = explode(",", $row_item['tjug_comb']);

        if ($x==0){
        for ($i=0;$i<$tcarr;$i++){
            $element .= "<td style='background-color:#F7D358'><p style='color:#000000;'><B>C: ".$carreras[$i]." </b></p></td>";              
            $element .= "<td style='background-color:#F7D358'><p style='color:#000000;'><B>P: ".$carreras[$i]." </b></p></td>";
        } 
        $element .= "<td style='background-color:#F7D358'><p style='color:#000000;'><B> &nbsp; Total &nbsp; </b></p></td>";      
        }
        if ($row_item['usu_id']==$usu_id){
            $element .= "</tr><tr style='background-color:#A9F5BC'>";
        } else{
            $element .= "</tr><tr>";
        }
        
        $element .= "<td>".$row_item['usu_login']."</td>";              
        for ($i=0;$i<$tcarr;$i++){
            $datosCaballo = $Caballos -> find ($caballos[$i]);
            $puntos =0;
            if ($datosCaballo['cab_posifinal']==1){
                $puntos = $datosPollas['tab_ptos1'];
            }
            if ($datosCaballo['cab_posifinal']==2){
                $puntos = $datosPollas['tab_ptos2'];
            } 
            if ($datosCaballo['cab_posifinal']==3){
                $puntos = $datosPollas['tab_ptos3'];
            }     
            $suma = $suma + $puntos;                   
            $element .= "<td align=center>".$caballosPosIni[$i]."</td>";                                
            $element .= "<td align=center>".$puntos."</td>";                                
        }         
        $element .= "<td align=center>".$suma."</td>";                                
        
        $x= $x+1;

    }
    $element .="</td></tr></table>";        
    
    $datos = array('datosUsuario'=>$datosUsuario,'MenuIzquierdo'=>$MenuIzquierdo,'Pollas'=>$element);		
    return view('resultados/rpollas.php',$datos);    
}
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


}