<?php namespace App\Controllers;
//Conexiones
use Config\Database;
$dbSip        = \Config\Database::connect('thSipacha', true);

//Controladores
use CodeIgniter\Controller;
//Modelos
use App\Models\Auditoria;
use App\Models\Usuarios;
use App\Models\Hipodromos;
use App\Models\Carreras;
use App\Models\Caballos;
use App\Models\Configuracion;
use App\Models\CarreraFin; 
use App\Models\Jremates;
use App\Models\Jrematesdevueltos;
//Librerias del Codeigneter4
$pager = \Config\Services::pager();

class ThJugadasARematesInter extends Th
{

    public function ListarHipodromosInter()
    {      
    //Verifico Sesion de Usuario
    if (!session()->get('isLogged')){
        $mensaje   = "Presione clic en su opcion de menu.";
        $claseMens = "alert alert-danger";
        $titleMens = "<strong>¡Error!</strong> </br>";   
        $datos = array('mensaje'=>$mensaje,'titleMens'=>$titleMens,'claseMens'=>$claseMens);		
        return view('estructura/ingresomalo.php',$datos);
    }  	
        $datosUsuario= $this->SessionUser();
        $MenuIzquierdo = $this->MenuIzquierdo();
        $usu_id = $datosUsuario['id'];
        $MontoActual = $this->MontoDisponible($usu_id);

        $MenuIzquierdo[0]=" menu-open active";
        $MenuIzquierdo[1]="active";
        $MenuIzquierdo[2]="active";
    
        $dbSip = \Config\Database::connect('thSipacha', true);
        $Carreras = new Carreras($dbSip);  
    
        $ClasDiv   = "table-responsive table-hover";
        $ClasTabla = "table table-bordered table-striped";  
        $idDiv     = ""; 

        $fechahoy= date("Y")."-".date("m")."-".date("d"); 
        $builder = $Carreras -> builder ();
        $builder -> distinct();
        $builder-> Select('carr_fecha as tab_jugada, hip_nombre, tab_hipodromos.hip_id');
        $builder->join('tab_hipodromos','tab_carrera.hip_id = tab_hipodromos.hip_id','inner');
        $builder->where('tab_hipodromos.hip_clasificacion', '0'); //Carreras Internacionales
        $builder->where('tab_hipodromos.hip_estatus', '1'); //Hipodromo Activo
        $builder->where('tab_carrera.carr_fecha>=', $fechahoy); //Fecha Activa >= HOY
        $datosCarreras = $builder->get(); 
        $element = $MontoActual;
        $element .= "        
        <div class='".$ClasDiv."' id='".$idDiv."'>
        <table class='".$ClasTabla."'> 
        <thead class='thead-dark'>
        <tr>
        <td style='background-color:#008080'><p style='color:#FFFFFF;'>
        <B>Hipodromos Nacionales</B></p></td></tr> 
        <tr> <tr><td>";
        foreach ($datosCarreras->getResultArray() as $row_item){
            $dia = saber_dia($row_item['tab_jugada']);
            /*$element .= " <td>           
            <a href='".BaseUrl()."ThJugadasARematesInter/ListarCarrerasInter?th1=".$row_item['tab_jugada']."&th=".$row_item['hip_id']."' > <i class='fas fa-horse'></i>&nbsp;&nbsp;".$row_item['hip_nombre']."&nbsp;&nbsp;".$dia."&nbsp;&nbsp;".cambiarfecha($row_item['tab_jugada'])." </a>
            </td></tr>";*/
            $element .= "   
            <form action='".BaseUrl()."/ThJugadasARematesInter/ListarCarrerasInter'>
            <input name='th' type='hidden' value='".$row_item['hip_id']."'>
            <input name='th1' type='hidden' value='".$row_item['tab_jugada']."'>
            <button type='submit' class='btn btn-outline-warning btn-block'>
            ".$row_item['hip_nombre']."&nbsp;&nbsp;".$dia."&nbsp;&nbsp;".cambiarfecha($row_item['tab_jugada'])."            
            </button>
            
            </form>
            ";
        }
        $element .="</td></tr></table></div>";
        //echo $element;
    
        $datos = array('datosUsuario'=>$datosUsuario,'MenuIzquierdo'=>$MenuIzquierdo,'Hipodromos'=>$element);		
        return view('juegosinter/jrhipodromosinter.php',$datos);
    
    }

    
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
public function ListarCarrerasInter()
{      
    //Verifico Sesion de Usuario
    if (!session()->get('isLogged')){
        $mensaje   = "Presione clic en su opcion de menu.";
        $claseMens = "alert alert-danger";
        $titleMens = "<strong>¡Error!</strong> </br>";   
        $datos = array('mensaje'=>$mensaje,'titleMens'=>$titleMens,'claseMens'=>$claseMens);		
        return view('estructura/ingresomalo.php',$datos);
    }

    $request=\Config\Services::request();
    $hip_id = $request->getPostGet('th'); 
    $fecha_carr = $request->getPostGet('th1');

    $datosUsuario= $this->SessionUser();
    $MenuIzquierdo = $this->MenuIzquierdo();    
    $MenuIzquierdo[0]=" menu-open active";
    $MenuIzquierdo[1]="active";
    $MenuIzquierdo[2]="active";
    $usu_id = $datosUsuario['id'];
    $MontoActual = $this->MontoDisponible($usu_id);
    $dbSip = \Config\Database::connect('thSipacha', true);
    $Carreras = new Carreras($dbSip);  
    $Hipodromo = new Hipodromos($dbSip);  
    
    $ClasDiv   = "table-responsive table-hover";
    $ClasTabla = "table table-bordered table-striped";  
    $idDiv     = ""; 
    
    $datosHip = $Hipodromo -> find ($hip_id);

    $carr_fechahora_actual = fechaActualConHoraMySql();
    //echo "..............................................................................". $carr_fechahora_actual.".....".$hip_id;
    $builder = $Carreras -> builder ();
    $builder -> distinct();
    $builder-> Select("carr_valida as carrera, tab_carrera.carr_id, hip_id,carr_fecha,carr_horainicio,carr_horafin,carr_valida,carr_dia,carr_metros,carr_cabfav,carr_estatus,carr_comentario, CONCAT( carr_fecha,' ',carr_horafin ) as carr_fechafin");
    $builder->join('tab_carrerafin','tab_carrerafin.carr_id = tab_carrera.carr_id','inner');
    $builder->join('tab_caballos','tab_caballos.carr_id = tab_carrera.carr_id ','inner');
    $builder->where('tab_carrera.hip_id', $hip_id); //Hipodromo seleccionado
    $builder->where('tab_carrera.carr_fecha>=', $carr_fechahora_actual); //FechaFinCarrera >= FechaHoraActual
    $builder->where('tab_caballos.cab_posifinal', '0'); //Caballo PorCorrer
    $builder->where('tab_carrera.carr_sem_cerrada', '0'); //Semana Abierta
    //$builder->where('tab_carrera.carr_fecha',$fecha_carr); //Fecha selecionada
    $builder->orderBy('carr_valida','ASC');
    $datosCarreras = $builder->get(); 

    $element = $MontoActual;
    $element .= "  
    <div class='".$ClasDiv."' id='".$idDiv."'>
    <table class='".$ClasTabla."'> 
    <thead class='thead-dark'>
    <tr>
    <td style='background-color:#008080'><p style='color:#FFFFFF;'><B>HIPODROMO&nbsp;".$datosHip['hip_nombre']."&nbsp;".cambiarfecha($fecha_carr)."</B></p></td></tr> 
    <tr> <tr><td>";
    foreach ($datosCarreras->getResultArray() as $row_item){
        $mensaje="";     $claseMens="";     $titleMens="";
        $url = BaseUrl() . "/ThJugadasARematesInter/ListarCaballosInter/". $row_item['carr_id'] ."/".$row_item['hip_id']."/".$row_item['carr_fecha'] ."/0/0/0";
        //echo "<br>".$url ;
        $element .= "  
        <form action='".$url."'>
        <button type='submit' class='btn btn-outline-warning btn-block'>
        Carrera&nbsp;&nbsp;".$row_item['carr_valida']."
        </button>
        </form>
        ";
    }
    $element .="</td></tr></table>";
    //echo $element;
    $datos = array('datosHip'=>$datosHip,'datosUsuario'=>$datosUsuario,'MenuIzquierdo'=>$MenuIzquierdo,'Carreras'=>$element);		
    return view('juegosinter/jrcarrerasinter.php',$datos);

}

    
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
public function ListarCaballosInter($carr_id,$hip_id,$fecha_carr,$mensaje,$claseMens,$titleMens)
{      
    //Verifico Sesion de Usuario
    if (!session()->get('isLogged')){
        $mensaje   = "Presione clic en su opcion de menu.";
        $claseMens = "alert alert-danger";
        $titleMens = "<strong>¡Error!</strong> </br>";   
        $datos = array('mensaje'=>$mensaje,'titleMens'=>$titleMens,'claseMens'=>$claseMens);		
        return view('estructura/ingresomalo.php',$datos);
    }
    //RecogeFormPost(); 

    $request=\Config\Services::request();
    $mensaje   = str_replace("%20"," ", $mensaje); 
    $claseMens = str_replace("%20"," ", $claseMens);    

    $element ="";$element2 = "";
    $datosUsuario= $this->SessionUser();
    $MenuIzquierdo = $this->MenuIzquierdo();
    $dbSip = \Config\Database::connect('thSipacha', true);
    $Hipodromo = new Hipodromos($dbSip); 
    $Carreras = new Carreras($dbSip); 
    $Caballos = new Caballos($dbSip); 
    $Jremates = new Jremates($dbSip); 
    $Configuracion = new Configuracion($dbSip);
    $datosHip = $Hipodromo -> find ($hip_id);
    $datosCarr = $Carreras -> find ($carr_id);  
        
    $datosConf = $Configuracion -> find (1);    
    $usu_id = $datosUsuario['id'];
    $MontoActual = $this->MontoDisponible($usu_id);
    $builder = $Jremates -> builder ();
    $builder->where('carr_id=', $carr_id); //Carrera Seleccionada
    $datosRemates = $builder->get(); 

    //Validación La Carrera este abierta
    $fecha_actual = strtotime(date("d-m-Y H:i:00",time()));  //$fecha_actual = strtotime("2020-06-28 17:20:00");
    //$fecha_carrera = strtotime("2020-07-28 17:20:00"); 
    $fecha_carrera = strtotime($datosCarr['carr_fecha']." ".$datosCarr['carr_horafin']);
    //foreach ($datosCarreras->getResultArray() as $row_item){
    //$fecha_carrera = strtotime($datosCarr['carr_fecha']." ".$datosCarr['carr_horafin']);
    //}
      
    if($fecha_actual >= $fecha_carrera){
        echo "Carrera Cerrada, No se pudo efectuar la jugada";
        exit();
    }

    $ClasDiv   = "";
    $ClasTabla = "";     
    $idDiv     = ""; 
    foreach ($datosRemates->getResultArray() as $row_item){
        $datosCaballos = $Caballos -> find ($row_item['cab_id']); 
        $rem_montoNuevo = $this-> rem_montoNuevo($row_item['rem_montojugada'],$datosConf);                  
        if ($datosCaballos['cab_estatus']==1) {  //Caballos Activos
            $element2 .= "  
            <tr>
            <td ><small>".$row_item['usu_login']."</small></td>
            <td ><small> ".$datosCaballos['cab_posinicial']."</small></td>
            <td ><small> ".$datosCaballos['cab_nombre']."</small></td>
            <td ><small> ".number_format($row_item['rem_montojugada'], 2,',', '.')."</small></td>
            <td ><small> ".number_format($rem_montoNuevo, 2,',', '.')."</small></td>";        
            $element2 .= "  
            <td>
            <form  method='post' action='".BaseUrl()."/ThJugadasARematesInter/JugarARemates'>
            <input name='rem_id' type='hidden' value='".$row_item['rem_id']."'>
            <button type='submit' class='btn btn-outline-warning btn-block btn-sm'><small>
            Rematar </small>
            </button>
            </td>
            </form>
            </tr>
            ";  
        }else {              
            $element2 .= "  
            <tr style='background-color:red'>
            <td><small>".$row_item['usu_login']."</small></td>
            <td><small>".$datosCaballos['cab_posinicial']."</small></td>
            <td><small>".$datosCaballos['cab_nombre']."</small></td>
            <td><small>".number_format($row_item['rem_montojugada'], 2,',', '.')."</small></td>
            <td><small>".number_format($rem_montoNuevo, 2,',', '.')."</small></td>
            <td><small>RETIRADO<small></td>";               
        }
        $premio = $row_item['rem_premiorep'];
      
    }

    $element = "<small><button onclick='goBack()' class='btn btn-warning'>Volver</button></small>&nbsp;&nbsp;&nbsp;&nbsp;".
    $MontoActual . "
    <div align=center class='".$ClasDiv."' id='".$idDiv."'>
    <table border = '1' class='".$ClasTabla."'> 
    <tr>
    <td colspan=3 style='background-color:#008080'><p style='color:#FFFFFF;'><small><B>".$datosHip['hip_nombre']."&nbsp;".cambiarfecha($fecha_carr)."</B></small></td>
    <td style='background-color:#008080'><p style='color:#FFFFFF;'><small><b>CARRERA".$datosCarr['carr_valida']."</b></small></p></td>
    <td style='background-color:#008080' colspan=2><p style='color:#FFFFFF;'><small><b>Premio Bs.</b>".number_format($premio, 2,',', '.')."</small></p></td>
    </tr> 
    <tr> 
    <tr style='background-color:#008080'>
    <td style='background-color:#F7D358'> <small> <b>USUARIO</b></small> </td>
    <td style='background-color:#F7D358'> <small> <b>N</b></small></td>
    <td style='background-color:#F7D358'> <small> <b>CABALLO</b></small></td>
    <td style='background-color:#F7D358'> <small> <b>VENDIDO</b></small></td>
    <td style='background-color:#F7D358'> <small> <b>VENTA</b></small></td>
    <td style='background-color:#F7D358'> <small> <b>APUESTA</b></small></td>
    </tr>";
    
    
    $element  = $element . $element2 ;
    $datos = array('datosHip'=>$datosHip,'datosUsuario'=>$datosUsuario,'MenuIzquierdo'=>$MenuIzquierdo,'Caballos'=>$element,'mensaje'=>$mensaje,'titleMens'=>$titleMens,'claseMens'=>$claseMens,'carr_id'=>$carr_id,'hip_id'=>$hip_id,'fecha_carr'=>$fecha_carr);
    return view('juegosinter/jrcaballosinter.php',$datos);
}


////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
public function JugarARemates()
{      
    //Verifico Sesion de Usuario
    if (!session()->get('isLogged')){
        $mensaje   = "Presione clic en su opcion de menu.";
        $claseMens = "alert alert-danger";
        $titleMens = "<strong>¡Error!</strong> </br>";   
        $datos = array('mensaje'=>$mensaje,'titleMens'=>$titleMens,'claseMens'=>$claseMens);		
        return view('estructura/ingresomalo.php',$datos);
    }    
    
    //RecogeFormPost(); 
    $element="";$element2="";
    $request=\Config\Services::request();
    $rem_id = $request->getPostGet('rem_id'); 
    $datosUsuario= $this->SessionUser();
    $MenuIzquierdo = $this->MenuIzquierdo();
    $dbSip = \Config\Database::connect('thSipacha', true);
    $Auditoria = new Auditoria($dbSip);  
    $Caballos = new Caballos($dbSip);  
    $Hipodromo = new Hipodromos($dbSip); 
    $Configuracion = new Configuracion($dbSip);
    $Carreras = new Carreras($dbSip); 
    $Jremates = new Jremates($dbSip); 
    $Jrematesdevueltos = new Jrematesdevueltos($dbSip); 

    $datosRemates = $Jremates -> find ($rem_id); 
    $hip_id = $datosRemates['hip_id'];
    $carr_id = $datosRemates['carr_id'];
    $cab_id =  $datosRemates['cab_id'];
    $datosHip = $Hipodromo -> find ($hip_id);
    $datosCarr = $Carreras -> find ($carr_id);
    $datosCab = $Caballos -> find ($cab_id);
    $datosConf = $Configuracion -> find (1);    
    $datosUsuario= $this->SessionUser();
    $usu_id = $datosUsuario['id'];
    $MontoActual = $this->MontoDisponible($usu_id);
    $rem_montoventa = $this->rem_montoNuevo($datosRemates['rem_montojugada'],$datosConf);  
//-------------------------------------------------------------------------------------------
//Valido que la carrera este abierta
    //Validación La Carrera este abierta
    $fecha_actual = strtotime(date("d-m-Y H:i:00",time()));  //$fecha_actual = strtotime("2020-06-28 17:20:00");
    $fecha_carrera = strtotime($datosCarr['carr_fecha']." ".$datosCarr['carr_horafin']);
    if($fecha_actual >= $fecha_carrera){
        $mensaje   = "Carrera Cerrada, No se pudo efectuar la jugada";
        $claseMens = "alert alert-danger";
        $titleMens = "<strong>¡Error!</strong> </br>";   
        echo "Carrera Cerrada, No se pudo efectuar la jugada";
        echo "<br><a href='javascript:history.back(1)'> <button class='btn btn-outline-warning btn-block'> Volver </button></a>";
        exit();        
    }
//-------------------------------------------------------------------------------------------
    //Valido el saldo disponible usuario comprador del remate
    $dbSipVirtual = \Config\Database::connect('thSipachaVirtual', true);
    $Usuarios = new Usuarios($dbSipVirtual);     
    $builder = $Usuarios -> builder ();
    $builder->where('id', $usu_id); 
    $datosUsuarioAct = $builder->get(); 
    $row_item = $datosUsuarioAct -> getRow (); 
    $saldoDisponibleAnt = $row_item -> usu_montodisp; 
    $usu_rematesjug = $row_item -> usu_rematesjug; 
    $usu_login = $row_item -> username;   
    if ($saldoDisponibleAnt<$rem_montoventa) {
        echo "Saldo insuficiente";
        echo "<br><a href='javascript:history.back(1)'> <button class='btn btn-outline-warning btn-block'> Volver </button></a>";
        exit();
    }
    $saldoDisponibleNew = $saldoDisponibleAnt - $rem_montoventa;
//-------------------------------------------------------------------------------------------
// Devuelvo el dinero al usuario que remato el caballo antes de este
$MontoDevolver = $datosRemates['rem_montojugada'];
$BJrematesdevueltos = $Jrematesdevueltos -> builder ();
$BJrematesdevueltos->where('remd_usu_id', $usu_id); 
$BJrematesdevueltos->where('remd_rem_id', $rem_id); 
$BJrematesdevueltos = $BJrematesdevueltos->get(); 
$row = $BJrematesdevueltos -> getRow ();   
if (isset( $row )){  
    $MontoDevolver =  $row -> remd_montojugado; 
}   
$UsuarioDevolver = $datosRemates['usu_id'];
$datosUsuarioDevolver = $Usuarios -> find ($UsuarioDevolver);
$datos = ['usu_montodisp' => $datosUsuarioDevolver['usu_montodisp']+$MontoDevolver];
$UpdateUsuario = $Usuarios -> Update($datosUsuarioDevolver['id'],$datos); //Aumenta -- Devuelve el dinero al usuario
$au_descripcion ="Aumenta su saldo disponible en Bs.". number_format($MontoDevolver, 2,',', '.')." por Remate devuelto del Caballo:".$datosCab['cab_nombre']. " en la carrera: ". $datosCarr['carr_valida'] . " del hipodromo: ". $datosHip['hip_nombre'] ." de fecha: " . cambiarfecha($datosCarr['carr_fecha']) ."<br>Se actualiza su monto disponible segun jugada de pollas de Bs.:". number_format($datosUsuarioDevolver['usu_montodisp'], 2,',', '.') . " a Bs.". number_format($datos['usu_montodisp'], 2,',', '.');
//echo $au_descripcion; 
$datosAuditoria = [
    'au_fecha'=>date("Y") . "-" . date("m") . "-" . date("d"),
    'au_hora'=>strftime("%H:%M:%S"),
    'au_evento'=>"INSERT",
    'au_descripcion'=>$au_descripcion,
    'au_ip'=>ObtenerIP(),
    'usu_id'=>$datosUsuarioDevolver['id'],
    'au_usulogin'=>$datosUsuarioDevolver['username'],
    'au_so'=>PHP_OS,
    'au_mostrar'=>1
    ];
$audit    = $Auditoria->insert($datosAuditoria);
//------------------------------------------------------------------------------------------
// Inserto la jugada de remate----AQUI -AQUI -AQUI -AQUI -AQUI -AQUI -AQUI -AQUI -AQUI -AQUI 
//------------------------------------------------------------------------------------------
$datosUsuario = $Usuarios -> find ($usu_id);
$datos = ['usu_id' => $usu_id,
          'usu_login' => $datosUsuario['username'],
          'rem_fechajugada' => fechaActualConHoraMySql(),
          'rem_montojugada' => $rem_montoventa
];
$UpdateRemates = $Jremates -> Update($rem_id,$datos);   //Efectivamente se ejecuta la jugada
//print_r($datos);
//Disminuir monto del usuario y Aumentar la estadisticas
$saldoDisponibleNew = $saldoDisponibleAnt - $rem_montoventa;
$datos = ['usu_montodisp' => $saldoDisponibleNew,
          'usu_rematesjug' => $usu_rematesjug + 1
];
$UpdateUsuario = $Usuarios -> Update($usu_id,$datos); //Disminuye -- Resta el dinero de la jugada del remate
$au_descripcion ="Disminuye su saldo disponible en Bs.". number_format($rem_montoventa, 2,',', '.')." por Remate Jugado al Caballo:".$datosCab['cab_nombre']. " en la carrera: ". $datosCarr['carr_valida'] . " del hipodromo: ". $datosHip['hip_nombre'] ." de fecha: " . cambiarfecha($datosCarr['carr_fecha']) ."<br>Se actualiza su monto disponible segun jugada de remate de Bs.:" .number_format( $saldoDisponibleAnt, 2,',', '.') . " a Bs.". number_format($saldoDisponibleNew, 2,',', '.');
//echo $au_descripcion;
$datosAuditoria = [
    'au_fecha'=>date("Y") . "-" . date("m") . "-" . date("d"),
    'au_hora'=>strftime("%H:%M:%S"),
    'au_evento'=>"INSERT",
    'au_descripcion'=>$au_descripcion,
    'au_ip'=>ObtenerIP(),
    'usu_id'=>$usu_id,
    'au_usulogin'=>$usu_login,
    'au_so'=>PHP_OS,
    'au_mostrar'=>1
    ];
$audit    = $Auditoria->insert($datosAuditoria);
//-------------------------------------------------------------------------------------------
//Actualizo el premio a repartir
//SUMA TODAS LAS JUGADAS Y RESTA EL %%%%%%%%%%%%%%%%%%%%%
$dbSip = \Config\Database::connect('thSipacha', true);
$datosRemateActualizado = $Jremates -> builder ();
$datosRemateActualizado->select('SUM(rem_montojugada) as sumado'); 
$datosRemateActualizado->where('carr_id', $carr_id); 
$datosRemateActualizado = $Jremates->get(); 
$row = $datosRemateActualizado -> getRow (); 
if (isset( $row )){  
    $datos = ['suma' => $row -> sumado] ; 
} 
$porcent = $datosConf['rem_porcentajegananciainter']/100;
$rem_porcentajegananciainter =$datos ['suma'] * ($porcent);
$rem_premiorep = intval($datos ['suma'] - $rem_porcentajegananciainter);
/*
echo "<hr>rem_id: ". $rem_id ;
echo "<hr>Suma: ". $datos ['suma']  ;
echo "<hr>%%: ". $porcent;
echo "<hr>%%: ".$rem_porcentajegananciainter  ;
echo "<hr>Premio a Repartir: ". $rem_premiorep ;
*/
$builder = $Jremates -> builder ();
$builder->set('rem_premiorep', $rem_premiorep, FALSE);
$builder->where('carr_id', $carr_id);
$builder->update(); // //Modifico el Premio a Repartir

//-------------------------------------------------------------------------------------
//Inserto la jugada en la tabla de rematesdevueltos para saber 
//el ultimo monto jugado por el usuario y poder devolver el monto exacto
$dbSip = \Config\Database::connect('thSipacha', true);
$datos = ['remd_usu_id' => $usu_id,
          'remd_rem_id' => $rem_id,
          'remd_montojugado' => $rem_montoventa
];
$InsertJrematesdevueltos = $Jrematesdevueltos->insert($datos);
$mensaje   = "Remate Jugado con Exito";
$claseMens = "alert alert-success";
$titleMens = "Felicidades"; 
//Datos de la vista
$url = BaseUrl() . "/ThJugadasARematesInter/ListarCaballosInter/".$carr_id."/".$hip_id."/".$datosCarr['carr_fecha'] ."/".$mensaje."/".$claseMens."/".$titleMens;
return redirect()->to($url); 
}
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
public function rem_montoNuevo($rem_monto,$datosConf)
{      $rem_montoNuevo =0;
        //Rango de Remates Nacionales
        if($rem_monto<=$datosConf['rem_rango1hastainter']){
            //echo "<br>entro1<=".$datosConf['rem_rango1hastainter'];
            $rem_montoNuevo = $rem_monto + $datosConf['rem_rango1sumanac'];
        }
        if (($rem_monto>$datosConf['rem_rango2desdeinter']) && ($rem_monto<=$datosConf['rem_rango2hastainter'])) {
            //echo "<br>entro2>".$datosConf['rem_rango2desdeinter']."<=".$datosConf['rem_rango2hastainter'];
            $rem_montoNuevo = $rem_monto + $datosConf['rem_rango2sumanac'];
        } 
        if (($rem_monto>$datosConf['rem_rango3desdeinter']) && ($rem_monto<=$datosConf['rem_rango3hastainter'])) {
            //echo "<br>entro3";
            $rem_montoNuevo = $rem_monto + $datosConf['rem_rango3sumanac'];
        }  
        if($rem_monto>$datosConf['rem_rango4desdeinter']){
            //echo "<br>entro4";
            $rem_montoNuevo = $rem_monto + $datosConf['rem_rango4sumanac'];
        }  
        return $rem_montoNuevo;
}


}