<?php namespace App\Controllers;
//Conexiones
use Config\Database;
$dbSip        = \Config\Database::connect('thSipacha', true);

//Controladores
use CodeIgniter\Controller;
//Modelos
use App\Models\Auditoria;
use App\Models\Usuarios;
use App\Models\Hipodromos;
use App\Models\Carreras;
use App\Models\Caballos;
use App\Models\Configuracion;
use App\Models\PollasMaestro;
use App\Models\PollasJugadas;
//Librerias del Codeigneter4
$pager = \Config\Services::pager();

class ThJugadasAPollasNac extends Th
{
    public function ListarHipodromosNac()
    {      
    //Verifico Sesion de Usuario
    if (!session()->get('isLogged')){
        $mensaje   = "Presione clic en su opcion de menu.";
        $claseMens = "alert alert-danger";
        $titleMens = "<strong>¡Error!</strong> </br>";   
        $datos = array('mensaje'=>$mensaje,'titleMens'=>$titleMens,'claseMens'=>$claseMens);		
        return view('estructura/ingresomalo.php',$datos);
    }  	
        $datosUsuario= $this->SessionUser();
        $usu_id = $datosUsuario['id'];
        $MontoActual = $this->MontoDisponible($usu_id);
        $MenuIzquierdo = $this->MenuIzquierdo();
        $MenuIzquierdo[0]=" menu-open active";
        $MenuIzquierdo[1]="active";
        $MenuIzquierdo[2]="active";
    
        $dbSip = \Config\Database::connect('thSipacha', true);
        $Carreras = new Carreras($dbSip);  
        $PollasMaestro = new PollasMaestro($dbSip);  
    
        $ClasDiv   = "table-responsive table-hover";
        $ClasTabla = "table table-bordered table-striped";  
        $idDiv     = ""; 

        $fechahoy= date("Y")."-".date("m")."-".date("d"); 
        $builder = $PollasMaestro -> builder ();
        $builder -> distinct();
        $builder-> Select('tab_jugada as tab_jugada, hip_nombre, tab_hipodromos.hip_id');
        $builder->join('tab_hipodromos','tab_tablapollamaestro.hip_id = tab_hipodromos.hip_id','inner');
        $builder->where('tab_hipodromos.hip_clasificacion', '1'); //Carreras Nacionales
        $builder->where('tab_hipodromos.hip_estatus', '1'); //Hipodromo Activo
        $builder->where('tab_jugada>=', $fechahoy); //Fecha Activa >= HOY
        $datosPollas = $builder->get(); 
        $element = $MontoActual;
        $element .= "   
        <div class='".$ClasDiv."' id='".$idDiv."'>
        <table class='".$ClasTabla."'> 
        <thead class='thead-dark'>
        <tr>
        <td style='background-color:#0b054a'><p style='color:#FFFFFF;'><B>Hipodromos Nacionales</B></p></td></tr> 
        <tr> <tr><td>";
        foreach ($datosPollas->getResultArray() as $row_item){
            $dia = saber_dia($row_item['tab_jugada']);
            /*$element .= " <td>           
            <a href='".BaseUrl()."ThJugadasAGanadorNac/ListarCarrerasNac?th1=".$row_item['tab_jugada']."&th=".$row_item['hip_id']."' > <i class='fas fa-horse'></i>&nbsp;&nbsp;".$row_item['hip_nombre']."&nbsp;&nbsp;".$dia."&nbsp;&nbsp;".cambiarfecha($row_item['tab_jugada'])." </a>
            </td></tr>";*/
            $element .= "   
            <form  method='post' action='".BaseUrl()."/ThJugadasAPollasNac/ListarPollasNac'  method='post'>
            <input name='th' type='hidden' value='".$row_item['hip_id']."'>
            <input name='th1' type='hidden' value='".$row_item['tab_jugada']."'>
            <button type='submit' class='btn btn-outline-info btn-block'>
            ".$row_item['hip_nombre']."&nbsp;&nbsp;".$dia."&nbsp;&nbsp;".cambiarfecha($row_item['tab_jugada'])."            
            </button>
            
            </form>
            ";
        }
        $element .="</td></tr></table>";
        //echo $element;
    
        $datos = array('datosUsuario'=>$datosUsuario,'MenuIzquierdo'=>$MenuIzquierdo,'Hipodromos'=>$element);		
        return view('juegosnac/jpollashipnac.php',$datos);
    
    }

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
public function ListarPollasNac(){    
    //Verifico Sesion de Usuario
    if (!session()->get('isLogged')){
        $mensaje   = "Presione clic en su opcion de menu.";
        $claseMens = "alert alert-danger";
        $titleMens = "<strong>¡Error!</strong> </br>";   
        $datos = array('mensaje'=>$mensaje,'titleMens'=>$titleMens,'claseMens'=>$claseMens);		
        return view('estructura/ingresomalo.php',$datos);
    }  	
    $request=\Config\Services::request();
    $hip_id = $request->getPostGet('th'); 
    $fecha_carr = $request->getPostGet('th1');

        $datosUsuario= $this->SessionUser();
        $usu_id = $datosUsuario['id'];
        $MontoActual = $this->MontoDisponible($usu_id);
        $MenuIzquierdo = $this->MenuIzquierdo();
        $MenuIzquierdo[0]=" menu-open active";
        $MenuIzquierdo[1]="active";
        $MenuIzquierdo[2]="active";
    
        $dbSip = \Config\Database::connect('thSipacha', true);
        $PollasMaestro = new PollasMaestro($dbSip);  
    
        $ClasDiv   = "table-responsive table-hover";
        $ClasTabla = "table table-bordered table-striped";  
        $idDiv     = ""; 
        /*
		$query = "SELECT tab_id, CONCAT( tab_nombre,  ' en ', hip_nombre ,' del ', CONCAT(DAY( tab_jugada ) ,'/', MONTH( tab_cierre ),'/',YEAR( tab_cierre )), ' por Bs. ' , tab_monto) as boton, tab_carreras  
        FROM tab_tablapollamaestro 
        INNER JOIN tab_hipodromos ON tab_tablapollamaestro.hip_id = tab_hipodromos.hip_id 
        WHERE tab_estatus = 1 AND tab_tablapollamaestro.hip_id = '".$hip_id."'  
        AND tab_jugada='".$fecha_carr."' and tab_pagada = 0 and tab_cierre>='".$actual."' 
        ORDER BY hip_nombre, tab_inicio  ";
        */
        //$fechahoy= date("Y")."-".date("m")."-".date("d"); 
        $actual = fechaActualConHoraMySql();
        $builder = $PollasMaestro -> builder ();
        $builder -> distinct();
        $builder-> Select("tab_id, CONCAT( tab_nombre,  ' en ', hip_nombre ,' del ', CONCAT(DAY( tab_jugada ) ,'/', MONTH( tab_cierre ),'/',YEAR( tab_cierre )), ' por Bs. ' , tab_monto) as boton, tab_carreras");
        $builder->join('tab_hipodromos','tab_tablapollamaestro.hip_id = tab_hipodromos.hip_id','inner');
        $builder->where('tab_estatus', '1'); //Polla Activa
        $builder->where('tab_tablapollamaestro.hip_id', $hip_id); //Hipodromo Seleccionado
        $builder->where('tab_pagada>=', '0'); // Polla Sin Pagar
        $builder->where('tab_jugada>=', $fecha_carr); //Fecha de Polla
        $builder->where('tab_cierre>=', $actual); //Polla Abierta Segun Fecha y Hora
        //$builder->orderby('hip_nombre, tab_inicio','ASC');
        $datosPollas = $builder->get(); 
        $element = $MontoActual;
        $element .= "   
        <div class='".$ClasDiv."' id='".$idDiv."'>
        <table class='".$ClasTabla."'> 
        <thead class='thead-dark'>
        <tr>
        <td style='background-color:#0b054a'><p style='color:#FFFFFF;'><B>Pollas Nacionales</B></p></td></tr> 
        <tr> <tr><td>";
        foreach ($datosPollas->getResultArray() as $row_item){
            $element .= "   
            <form action='".BaseUrl()."/ThJugadasAPollasNac/ListarCarrerasPollasNac'  method='post'>
            <input name='th' type='hidden' value='".$row_item['tab_id']."'>
            <button type='submit' class='btn btn-outline-info btn-block'>
            ".$row_item['boton']."&nbsp;&nbsp;         
            </button>
            
            </form>
            ";
        }
        $element .="</td></tr></table>";
        //echo $element;
    
        $datos = array('datosUsuario'=>$datosUsuario,'MenuIzquierdo'=>$MenuIzquierdo,'Pollas'=>$element);		
        return view('juegosnac/jpollasnac.php',$datos);
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
public function ListarCarrerasPollasNac()
{      
    //Verifico Sesion de Usuario
    if (!session()->get('isLogged')){
        $mensaje   = "Presione clic en su opcion de menu.";
        $claseMens = "alert alert-danger";
        $titleMens = "<strong>¡Error!</strong> </br>";   
        $datos = array('mensaje'=>$mensaje,'titleMens'=>$titleMens,'claseMens'=>$claseMens);		
        return view('estructura/ingresomalo.php',$datos);
    }  
    $datosUsuario= $this->SessionUser();
    $usu_id = $datosUsuario['id'];
    $MontoActual = $this->MontoDisponible($usu_id);
    $MenuIzquierdo = $this->MenuIzquierdo();

    $request=\Config\Services::request();
    $tab_id = $request->getPostGet('th'); 
    $fecha_polla=$request->getPostGet('th1'); 
    
    $dbSip = \Config\Database::connect('thSipacha', true);
    $PollasMaestro = new PollasMaestro($dbSip); 
    $Hipodromo = new Hipodromos($dbSip); 
    $datosHip = $Hipodromo -> find ($hip_id);
    $builder = $PollasMaestro -> builder ();
    $builder->where('tab_id', $tab_id); //Fecha Activa >= HOY
    $datosPollas = $builder->get();     
    foreach ($datosPollas->getResultArray() as $row_item){
        $carrerash = $row_item['tab_carreras'];
        $carreras = explode(",", $row_item['tab_carreras']);
        $hip_id = $row_item['hip_id'];
        $fecha_polla = $row_item['tab_jugada'];
        $tab_nombre = $row_item['tab_nombre'];
        $tab_monto = $row_item['tab_monto'];
    }
    $datosHip = $Hipodromo -> find ($hip_id);
    $longitud = count($carreras);
    //echo "<hr>".$longitud ;
    //print_r($carreras);
    $element = $MontoActual;
    $ClasDiv   = "table-responsive table-hover";
    $ClasTabla = "table table-bordered table-striped";  
    $ClasTabla = "table table-bordered";
    $idDiv     = "";     
    $element .= "   
    <form action='".BaseUrl()."/ThJugadasAPollasNac/FormJugarPollas' id='formulario' name='formulario'>
    <div class='".$ClasDiv."' id='".$idDiv."'>
    <table class='".$ClasTabla."'> 
    <tr>
    <input name='longitud' type='hidden' value='".$longitud."'>
    <input name='carreras' type='hidden' value='".$carrerash."'>
    <input name='tab_id' type='hidden' value='".$tab_id."'>
    <td colspan=4 style='background-color:#0b054a'><p style='color:#FFFFFF;'><B>HIPODROMO&nbsp;".$datosHip['hip_nombre']."&nbsp;".cambiarfecha($fecha_polla)." <br> ".$tab_nombre." en Bs. ".number_format($tab_monto, 2,',', '.')."</B></p></td>
    </tr>";       
    //Recorro las Carreras
    for($x=0; $x<$longitud; $x++)
    {
    //echo "<hr>Carrera : ".$carreras[$x] ;
    $Carreras = new Carreras($dbSip); 
    $builder = $Carreras -> builder ();
    $builder->where('carr_id', $carreras[$x]); //Fecha Activa >= HOY
    $datosCarrera = $builder->get();     
    foreach ($datosCarrera->getResultArray() as $row){
        $element .= "   
        <tr>
        <td colspan=4 style='background-color:#3b83bd'><p style='color:#FFFFFF;'><B>CARRERA &nbsp;".$row['carr_valida']." de ".$row['carr_metros']." mteros</B></p></td>
        </tr>";   
        //Listar Los Caballos de cada Carrera
        $Caballos = new Caballos($dbSip); 
        $builder = $Caballos -> builder ();
        $builder->where('carr_id', $carreras[$x]); //Fecha Activa >= HOY
        //echo "<hr>".$carreras[$x];
        $datosCaballos = $builder->get();     
        $element .= "   
        <tr>
        <td style='background-color:#3b83bd'><p style='color:#FFFFFF;'><b>Sel.</b></p></td>
        <td style='background-color:#3b83bd'><p style='color:#FFFFFF;'><b>N</b></p></td>
        <td style='background-color:#3b83bd'><p style='color:#FFFFFF;'><b>Caballo</b></p></td>
        <td style='background-color:#3b83bd'><p style='color:#FFFFFF;'><b>Jinete</b></p></td>
        </tr>";        
        $i=0;
        foreach ($datosCaballos->getResultArray() as $row){
            //echo "<hr>cab_estatus: ";
            //echo $row['cab_id']."-".$row['cab_estatus'];
            if ($row['cab_estatus']==1) {   //Caballos Activos
                $element .= "   
                <tr>
                <td align=center>
                <input type='checkbox' id='cabcarr".$x."' class='form-check-input' name='cabcarr".$x."[]' value=".$row['cab_id'].">
                </td>
                <td> <label class='form-check-label' for='exampleCheck1'>".$row['cab_posinicial']."</label> </td>
                <td>".$row['cab_nombre']."</td>
                <td>".$row['cab_jinete']."</td>
                </tr>"; 
                } else {
                    $element .= "   
                    <tr style='background-color:red'>
                    <td align=center> &nbsp;</td>
                    <td> <label class='form-check-label' for='exampleCheck1'>".$row['cab_posinicial']."</label> </td>
                    <td>".$row['cab_nombre']."</td>
                    <td>RETIRADO</td>
                    </tr>";                 
                }
                $i = $i + 1;     
        }               
    }    
    }  
    $element .= "</table></div>
    <button type='submit' class='btn btn-info btn-block'>Jugar Pollas</button>
    </form>";  
    //echo $element;
    $datos = array('datosUsuario'=>$datosUsuario,'MenuIzquierdo'=>$MenuIzquierdo,'Caballos'=>$element);		
    return view('juegosnac/jpollascabnac.php',$datos);    
}
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
public function MultiplicadorDePollas()
{
    //RecogeFormPost();  
    $tjug_comb="";
    $dbSip = \Config\Database::connect('thSipacha', true);
    $request=\Config\Services::request();
    $contCarr0 = $request->getPostGet('contCarr0'); 
    $contCarr1 = $request->getPostGet('contCarr1'); 
    $contCarr2 = $request->getPostGet('contCarr2'); 
    $contCarr3 = $request->getPostGet('contCarr3'); 
    $contCarr4 = $request->getPostGet('contCarr4');  
    $contCarr5 = $request->getPostGet('contCarr5');     
    $cabcarr0="";$cabcarr1="";$cabcarr3="";$cabcarr4="";$cabcarr5="";    
    $carreras = $request->getPostGet('carreras'); 
    $tab_id = $request->getPostGet('tab_id');  
    $longitud = $request->getPostGet('longitud');   
    $PollasMaestro = new PollasMaestro($dbSip); 
    $datosPollas = $PollasMaestro -> find ($tab_id); 
    $tab_precio = $datosPollas['tab_monto'];
    //echo "<hr>longitud".$longitud;
    $ClasDiv   = "table-responsive table-hover";
    $ClasTabla = "table table-bordered table-striped";  
    $ClasTabla = "table table-bordered";
    $idDiv     = "";     
    $element = "<div class=".$ClasDiv."><table class=".$ClasTabla."><tr><td bgcolor='red'>No ha completado una combinacion para pollas</td></tr></table></div>";
//--------------------------------------------------------    
	if ($contCarr0 >=1) { 
        for ($x = 0; $x < $contCarr0; $x++) {
            if ($x==($contCarr0-1)){
                $cabcarr0 .= $x;
            }
            else {
                $cabcarr0 .= $x.",";
            }
        }
        $cabcarr0 = explode(",", $cabcarr0 );
        //echo "<br>cabcarr0:". $cabcarr0;
        //echo "<br>cabcarr0:";  //print_r($cabcarr0);
      }   
      
      if ($contCarr1 >=1) { 
        for ($x = 0; $x < $contCarr1; $x++) {
            if ($x==($contCarr1-1)){
                $cabcarr1 .= $x;
            }
            else {
                $cabcarr1 .= $x.",";
            }
        }
        $cabcarr1 = explode(",", $cabcarr1 );
        //echo "<br>cabcarr1:". $cabcarr1;
        //echo "<br>cabcarr1:";  //print_r($cabcarr1);
      }

      if ($contCarr2 >=1) { 
        $cabcarr2 ="";
        for ($x = 0; $x < $contCarr2; $x++) {
            //echo "<hr>contCarr2:". $contCarr2;
            $cabcarr2 .= $x;
            if ($x!=($contCarr2-1)){
                $cabcarr2 .= ",";
            }
        }
        $cabcarr2 = explode(",", $cabcarr2 );
        //echo "<br>cabcarr2:";  //print_r($cabcarr2);
        }      

    if ($contCarr3 >=1) { 
        for ($x = 0; $x < $contCarr3; $x++) {
            if ($x==($contCarr3-1)){
                $cabcarr3 .= $x;
            }
            else {
                $cabcarr3 .= $x.",";
            }
        }
        $cabcarr3 = explode(",", $cabcarr3 );
        //echo "<br>cabcarr3:". $cabcarr3;
        //echo "<br>cabcarr3:";  //print_r($cabcarr3);
    }

    if ($contCarr4 >=1) { 
        for ($x = 0; $x < $contCarr4; $x++) {
            if ($x==($contCarr4-1)){
                $cabcarr4 .= $x;
            }
            else {
                $cabcarr4 .= $x.",";
            }
        }
        $cabcarr4 = explode(",", $cabcarr4 );
        //echo "<br>cabcarr4:". $cabcarr4;
        //echo "<br>cabcarr4:";  //print_r($cabcarr4);
      }    
      if ($contCarr5 >=1) { 
        for ($x = 0; $x < $contCarr5; $x++) {
            if ($x==($contCarr5-1)){
                $cabcarr5 .= $x;
            }
            else {
                $cabcarr5 .= $x.",";
            }
        }
        $cabcarr5 = explode(",", $cabcarr5 );
        //echo "<br>cabcarr5:". $cabcarr5;
        //echo "<br>cabcarr5:";  //print_r($cabcarr5);
      }
      //echo "<br>"; 

//--------------------------------------------------------

//--------------------------------------------------------      
$tjug_comb =0;
    if($longitud==5){
        if(($contCarr0<=0)||($contCarr1<=0)||($contCarr2<=0)||($contCarr3<=0)||($contCarr4<=0)){
            //echo "No ha completado combinacion de pollas";
            echo $element;
            exit();
        }else{
            //echo "Si hay Pollas 5--";
            $tjug_comb = $this->CountPermuta5Carreras($cabcarr0,$cabcarr1,$cabcarr2,$cabcarr3,$cabcarr4);
        }
        //print_r ($tjug_comb );
    }

    if($longitud==6){
        if(($contCarr0<=0)||($contCarr1<=0)||($contCarr2<=0)||($contCarr3<=0)||($contCarr4<=0)||($contCarr5<=0)){
            //echo "No ha completado combinacion de pollas";
            echo $element;
            exit();            
        }else{
            //echo "Si hay Pollas 6--";
            $tjug_comb = $this->CountPermuta6Carreras($cabcarr0,$cabcarr1,$cabcarr2,$cabcarr3,$cabcarr4,$cabcarr5);
    }
    //print_r ($tjug_comb );    
    }
    //echo "<hr><hr>";
    //echo ("Cantidada de Pollas:".$tjug_comb);
    //echo "<hr>";     
    //echo "<br>tjug_comb".$tjug_comb;
    $MontoJugado = $datosPollas['tab_monto'] * $tjug_comb;
    if ($tjug_comb>0){
        //$element = "<div class=".$ClasDiv."><table class=".$ClasTabla."><tr><td  bgcolor='#A9F5BC'>Pollas: ". $tjug_comb ."<td><td>* Bs.".number_format($datosPollas['tab_monto'], 2,',', '.')."</td><td>Total Bs.".number_format($MontoJugado, 2,',', '.') ."<td></tr></table></div>";
        $datosUsuario= $this->SessionUser();
        $MontoActual = $this->MontoDisponible($datosUsuario['id']);
        $element = "<table><tr><td  bgcolor='#A9F5BC'>".$MontoActual."<br>Pollas por sellar:&nbsp;". $tjug_comb ."&nbsp;*&nbsp;Bs.".number_format($datosPollas['tab_monto'], 2,',', '.')."&nbsp;Total Bs.".number_format($MontoJugado, 2,',', '.') ."</td></tr></table></div>";
    } 
    echo $element;
}
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
public function FormJugarPollas()
{
    //Verifico Sesion de Usuario
    if (!session()->get('isLogged')){
        $mensaje   = "Presione clic en su opcion de menu.";
        $claseMens = "alert alert-danger";
        $titleMens = "<strong>¡Error!</strong> </br>";   
        $datos = array('mensaje'=>$mensaje,'titleMens'=>$titleMens,'claseMens'=>$claseMens);		
        return view('estructura/ingresomalo.php',$datos);
    }      
    //RecogeFormPost();  
    $mensaje   = "Jugadas de Pollas realizadas con exitos";
    $claseMens = "alert alert-success";
    $titleMens = "<strong>¡Felicidades!</strong> </br>";     
    $datosUsuario= $this->SessionUser();
    $MenuIzquierdo = $this->MenuIzquierdo();
    $usu_id = $datosUsuario['id'];
    $MontoActual = $this->MontoDisponible($usu_id);
    $request=\Config\Services::request();
    $carreras = $request->getPostGet('carreras'); 
    $tab_id = $request->getPostGet('tab_id');
    //$fecha_polla = $request->getPostGet('fecha_polla');
    $dbSip = \Config\Database::connect('thSipacha', true);
    $PollasJugadas = new PollasJugadas($dbSip); 
    $carreras = explode(",", $carreras);
    $longitud = count($carreras);                
    $PollasMaestro = new PollasMaestro($dbSip); 
    $Hipodromo = new Hipodromos($dbSip); 
    $datosPolla = $PollasMaestro -> find ($tab_id);
    $hip_id = $datosPolla['hip_id'];
    $datosHip = $Hipodromo -> find ($hip_id);
    $tab_nombre =  $datosPolla['tab_nombre'];
    $fecha_polla = $datosPolla['tab_jugada'];
    $contCarr0 =0;$contCarr1 =0;$contCarr2 =0;$contCarr4 =0;$contCarr5 =0;
    $cabcarr0 = $request->getPostGet('cabcarr0'); 
    $cabcarr1 = $request->getPostGet('cabcarr1'); 
    $cabcarr2 = $request->getPostGet('cabcarr2'); 
    $cabcarr3 = $request->getPostGet('cabcarr3'); 

    //Valido que la polla aun este abierta
    $actual = fechaActualConHoraMySql();
    $tab_cierre = $datosPolla['tab_cierre'];
    //echo "<br>tab_cierre".$tab_cierre ;
    //echo "<br>actual".$actual ;
    if ($tab_cierre < $actual){
        echo "Lo sentimos, esta polla ya cerro";
        echo "<br><a href='".BaseUrl()."/Th/MenuNacional/".$datosUsuario['id']."'> <button class='btn btn-outline-info btn-block'> Opciones de Juegos Nacionales </button></a>";
        echo "<br><a href='".BaseUrl()."/Th/MenuInternacional/".$datosUsuario['id']."'> <button class='btn btn-outline-info btn-block'> Opciones de Juegos Internacionales </button></a>";
        exit();        
    }

    if (is_array($cabcarr0)){
        $contCarr0 = count($cabcarr0);
        }
        if (is_array($cabcarr1)){
        $contCarr1 = count($cabcarr1);
        }
        if (is_array($cabcarr2)){
        $contCarr2 = count($cabcarr2);
        }
        if (is_array($cabcarr3)){
        $contCarr3 = count($cabcarr3);
        }

    if ($longitud>=5) {
    $cabcarr4 = $request->getPostGet('cabcarr4'); 
    if (is_array($cabcarr4)){
        $contCarr4 = count($cabcarr4);
        }    
    }
    if ($longitud>=6) {
    $cabcarr5 = $request->getPostGet('cabcarr5'); 
    if (is_array($cabcarr5)){
        $contCarr5 = count($cabcarr5);
        }    
    }
    /*    
    echo "<hr>Holaaaaaaaaaaaaaaaaaa<br><hr>cabcarr0="; 
    print_r($cabcarr0); echo "</br>cabcarr1=";
    print_r($cabcarr1); echo "</br>cabcarr2=";
    print_r($cabcarr2); echo "</br>cabcarr3=";
    print_r($cabcarr3); echo "</br>cabcarr4=";
    print_r($cabcarr4); echo "</br>cabcarr5=";
    print_r($cabcarr5);
    echo "<br>"; 
    */
    //Valido que de todas las carreras se haya selecionado por lo menos un caballo                           
    //$carrerash = $carreras;

    $ClasDiv   = "table-responsive table-hover";
    $ClasTabla = "table table-bordered table-striped";  
    $idDiv     = "";     
    $element = "<div class=".$ClasDiv."><table class=".$ClasTabla."><tr><td bgcolor='red'>No ha completado una combinacion para pollas</td></tr></table><br> <a href='javascript:history.back(1)'> <button class='btn btn-outline-info btn-block'> Volver </button></a></div>";
    if($longitud==5){
        if(($contCarr0<=0)||($contCarr1<=0)||($contCarr2<=0)||($contCarr3<=0)||($contCarr4<=0)){
            //echo "No ha completado combinacion de pollas 5";
            echo $element;
            exit();
        }else{
            //echo "Si hay Pollas 5--";
            $tjug_comb = $this->CountPermuta5Carreras($cabcarr0,$cabcarr1,$cabcarr2,$cabcarr3,$cabcarr4);
        }
        //print_r ($tjug_comb );
    }

    if($longitud==6){
        if(($contCarr0<=0)||($contCarr1<=0)||($contCarr2<=0)||($contCarr3<=0)||($contCarr4<=0)||($contCarr5<=0)){
            //echo "No ha completado combinacion de pollas 6";
            echo $element;
            exit();            
        }else{
            //echo "Si hay Pollas 6--";
            $tjug_comb = $this->CountPermuta6Carreras($cabcarr0,$cabcarr1,$cabcarr2,$cabcarr3,$cabcarr4,$cabcarr5);
    }
    }
    //Validar que se seleccione al menos un caballo por cada carrera
    //Busco los datos de la carrera
    $Carreras = new Carreras($dbSip); 
    $tjug_combcarrvalidas="";
    for($x=0; $x<$longitud; $x++)
    {
        $builder = $Carreras -> builder ();
        $builder->where('carr_id', $carreras[$x]); //Fecha Activa >= HOY
        $datosCarrera = $builder->get();     
        foreach ($datosCarrera->getResultArray() as $row){
            if ($x<($longitud-1)){
                $tjug_combcarrvalidas .= $row['carr_valida'].",";
            } else {
                $tjug_combcarrvalidas .= $row['carr_valida']; 
            }
        }
    }
   //echo $tjug_combcarrvalidas;
    //Busco las Permutas
    switch ($longitud) {
        case "5":
            $tjug_comb = $this->Permuta5Carreras($cabcarr0,$cabcarr1,$cabcarr2,$cabcarr3,$cabcarr4);
          break;
        case "6":
            $tjug_comb = $this->Permuta6Carreras($cabcarr0,$cabcarr1,$cabcarr2,$cabcarr3,$cabcarr4,$cabcarr5);
          break;
          default:
             $tjug_comb = "";          
      }
    //print_r ($tjug_comb);
    
    //Valido el saldo disponible
    $cont_tjug_comb = count($tjug_comb);
    $datosUsuario= $this->SessionUser();
    $usu_id = $datosUsuario['id'];
    $dbSipVirtual = \Config\Database::connect('thSipachaVirtual', true);
    $Usuarios = new Usuarios($dbSipVirtual);     
    $builder = $Usuarios -> builder ();
    $builder->where('id', $usu_id); 
    $datosUsuarioAct = $builder->get(); 
    $row_item = $datosUsuarioAct -> getRow ();   
    if (isset( $row_item )){  
        $datosUsuarioAct = [ 'usu_montodisp' => $row_item -> usu_montodisp,
                             'usu_pollasjug' =>  $row_item -> usu_pollasjug];
        }    
    $saldoDisponibleAnt = $datosUsuarioAct['usu_montodisp'];    
    $MontoJugado = $datosPolla['tab_monto'] * $cont_tjug_comb;
    if ($saldoDisponibleAnt<$MontoJugado) {
        echo "Saldo insuficiente";
        echo "<br><a href='javascript:history.back(1)'> <button class='btn btn-outline-info btn-block'> Volver </button></a>";
        exit();
    }
    $saldoDisponibleNew = $saldoDisponibleAnt - $MontoJugado;
    
    //Busco los datos de los caballos de las permutas seleccionadas
    //Busco los datos de la carrera
    //$dbSip = \Config\Database::connect('thSipacha', true);
    $Caballos = new Caballos($dbSip); 
    for($x=0; $x<count($tjug_comb); $x++)
    {
        $CaballosPermtas = explode(",", $tjug_comb[$x]);
        //echo "<hr>";
        //print_r($CaballosPermtas);
        //echo "<hr>";
        $CaballosPosicion=""; 
        for($y=0; $y<count($CaballosPermtas); $y++)
        {        
        $builder = $Caballos -> builder ();
        $builder->where('cab_id', $CaballosPermtas[$y]); //Fecha Activa >= HOY
        $datosCaballos = $builder->get();     
        foreach ($datosCaballos->getResultArray() as $row){
            if ($y<($longitud-1)){
                $CaballosPosicion .= $row['cab_posinicial'].",";
            } else {
                $CaballosPosicion .= $row['cab_posinicial']; 
            }
        }      
       }        
       $tjug_combcabvalidas[$x] = $CaballosPosicion;         
    }
    //echo "<br>";
        
    //echo $tjug_combcarrvalidas;  //Combinacion de  Carreras Validas
    //print_r($tjug_combcabvalidas); //Caballos Elegidos Por Carreras

    //Crear el cuadro de Jugadas
    $ClasDiv   = "table-responsive table-hover";
    $ClasTabla = "table table-bordered table-striped";  
    $idDiv     = ""; 
    $carrValidas=  explode(",", $tjug_combcarrvalidas);
    $longitud = count($carrValidas);
    $element = "        
    <div class='".$ClasDiv."' id='".$idDiv."'>
    <table class='".$ClasTabla."'> ";
    //Fila de Carreras Validas para la Polla
    $element .="<tr>";
    for($x=0; $x<$longitud; $x++)
    {
        $element .= "<td style='background-color:#3b83bd'><p style='color:#FFFFFF;'><b>C:".$carrValidas[$x]."</b></p></td>"; 
    }
    $element .= "</tr>";
    //Filas de Caballos Elegidos para las Pollas
    $longitud = count($tjug_combcabvalidas);

    for($x=0; $x<$longitud; $x++)
    {
        $element .= "<tr>";
        $cabJugados=  explode(",", $tjug_combcabvalidas[$x]);
        for($i=0; $i<count($cabJugados); $i++)
        {
        $element .= "<td>".$cabJugados[$i]."</td>"; 
        }
        $element .= "</tr>";
      
        //Aqui debo insertar las pollas jugadas
        //------------------------------------------------------------------------------------//
        $datos =[
            'tab_id'=> $tab_id, 
            'usu_id'=> $datosUsuario['id'], 
            'usu_login'=>$datosUsuario['username'], 
            'tjug_comb'=>$tjug_comb[$x], 
            'tjug_combcarrvalidas'=>$tjug_combcarrvalidas, 
            'tjug_combcabvalidas'=>$tjug_combcabvalidas[$x], 
            'tjug_suma'=>0, 
            'tjug_ip'=>ObtenerIP(), 
            'tjug_fechahora'=>fechaActualConHoraMySql(), 
            'tjug_montojugado'=>$datosPolla['tab_monto'], 
            'tjug_montoganado'=>0
        ];
        $guardar= $PollasJugadas->save($datos);
        //$au_descripcion = "Jugada de polla en el Hipodromo: ".$datosHip['hip_nombre']." para el dia: ".cambiarfecha($datos['carr_fecha'])." en las carreras ". $datosCab['tjug_combcarrvalidas']. " con la siguiente combinacion: ". $datos['tjug_combcabvalidas'] . " por un monto de Bs. ".number_format($datos['tjug_montojugado'], 2,',', '.') .". <br>Se actualiza su monto disponible segun jugada de pollas de Bs.:". number_format($saldoDisponible, 2,',', '.') . " a Bs.". number_format($saldoDisponiblenew, 2,',', '.');
        //------------------------------------------------------------------------------------//
        //echo "<hr>";
        //print_r($datos);        
    }
    $element .= "</table></div>";
    //echo "<hr>".$element;
    
    //Insertar la auditoria
    $Auditoria = new Auditoria($dbSip); 
    if ($cont_tjug_comb ==1){
        $au_descripcion = "Jugada de ".$cont_tjug_comb." polla en el Hipodromo: ".$datosHip['hip_nombre']." para el dia: ".cambiarfecha($datosPolla['tab_jugada'])." en las carreras ". $datos['tjug_combcarrvalidas']. " por un total de Bs. ".number_format($MontoJugado, 2,',', '.') ."<br>Se actualiza su monto disponible segun jugada de pollas de Bs.:". number_format($saldoDisponibleAnt, 2,',', '.') . " a Bs.". number_format($saldoDisponibleNew, 2,',', '.');
    } else {
        $au_descripcion = "Jugada de ".$cont_tjug_comb." pollas en el Hipodromo: ".$datosHip['hip_nombre']." para el dia: ".cambiarfecha($datosPolla['tab_jugada'])." en las carreras ". $datos['tjug_combcarrvalidas']. " por un monto de Bs. ".number_format($datos['tjug_montojugado'], 2,',', '.') ." cada una, generando un total de Bs. ".number_format($MontoJugado, 2,',', '.') ."<br>Se actualiza su monto disponible segun jugada de pollas de Bs.:". number_format($saldoDisponibleAnt, 2,',', '.') . " a Bs.". number_format($saldoDisponibleNew, 2,',', '.');
    }
    $datosAuditoria = [
        'au_fecha'=>date("Y") . "-" . date("m") . "-" . date("d"),
        'au_hora'=>strftime("%H:%M:%S"),
        'au_evento'=>"INSERT",
        'au_descripcion'=>$au_descripcion,
        'au_ip'=>ObtenerIP(),
        'usu_id'=>$datosUsuario['id'],
        'au_usulogin'=>$datosUsuario['username'],
        'au_so'=>PHP_OS,
        'au_mostrar'=>1
        ];
    $audit    = $Auditoria->insert($datosAuditoria);
    //Disminuir monto del usuario y Aumentar la estadisticas
    $datos =[
        'usu_montodisp' => $saldoDisponibleNew,
        'usu_pollasjug' => $datosUsuarioAct['usu_pollasjug'] + $cont_tjug_comb
    ];
    $UpdateUsuario = $Usuarios -> Update($usu_id,$datos); //Disminuye monto de usuario    
    $datosUsuario= $this->SessionUser();
    $usu_id = $datosUsuario['id'];
    $MontoActual = $this->MontoDisponible($usu_id);
    $element2 = $MontoActual;
    $element2 .= "        
    <div class='".$ClasDiv."' id='".$idDiv."'>
    <table class='".$ClasTabla."'> ";    
    $element2 .= "
    <tr>
    <td colspan=4 style='background-color:#0b054a'><p style='color:#FFFFFF;'><B>HIPODROMO&nbsp;".$datosHip['hip_nombre']."&nbsp;".cambiarfecha($fecha_polla)."  ".$tab_nombre." en Bs. ".number_format($tab_monto, 2,',', '.')."</B></p></td>
    </tr>    
    <tr>
    <td style='background-color:#3b83bd'><p style='color:#FFFFFF;'><b> Precio Bs.   </b></p></td>
    <td style='background-color:#3b83bd'><p style='color:#FFFFFF;'><b> Pollas  </b></p></td>
    <td style='background-color:#3b83bd'><p style='color:#FFFFFF;'><b> Monto Bs.  </b></p></td>
    </tr>";


    $element2 .= "<tr>
    <td>". number_format($datosPolla['tab_monto'], 2,',', '.')." </td>
    <td>". $cont_tjug_comb." </td>";
 
        $mensaje   = "Jugada realizada con exito.";
        $claseMens = "alert alert-success";
        $titleMens = "<strong>¡Felicidades!</strong> </br>";          
        $element2 .="<td>".  number_format($MontoJugado, 2,',', '.')." </td>";
    
    $element2 .="</tr>";    
    $element2 .= "</table></div>";
    //echo $element2;
    $element = $element2 . $element;
    $datos = array('mensaje'=>$mensaje,'titleMens'=>$titleMens,'claseMens'=>$claseMens,'datosUsuario'=>$datosUsuario,'PollasJugadas'=>$element);		
    return view('juegosnac/jpollascabnac2.php',$datos);     

}
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
public function Permuta5Carreras($acabcarr0,$acabcarr1,$acabcarr2,$acabcarr3,$acabcarr4)
{      
    ////////////////////////////////////////////////////////////////////////////////////////////////77777
    //PERMUTAS DE 5 CARRERAS
    ////////////////////////////////////////////////////////////////////////
/*    
    echo "<hr>Holaaaaaaaaaaaaaaaaaa<br><hr>acabcarr0="; 
    print_r($acabcarr0); echo "</br>acabcarr1=";
    print_r($acabcarr1); echo "</br>acabcarr2=";
    print_r($acabcarr2); echo "</br>acabcarr3=";
    print_r($acabcarr3); echo "</br>acabcarr4=";
    print_r($acabcarr4); echo "</br>"; 
*/
    
   $x=0;
    for($a=0; $a<count($acabcarr0); $a++) {
        for($b=0; $b<count($acabcarr1); $b++) {
            for($c=0; $c<count($acabcarr2); $c++) {
                for($d=0; $d<count($acabcarr3); $d++) {  
                    for($e=0; $e<count($acabcarr4); $e++) {
                        $permuta = $acabcarr0[$a];
                        $permuta .= ",".$acabcarr1[$b];
                        $permuta .= ",".$acabcarr2[$c];
                        $permuta .= ",".$acabcarr3[$d];
                        $permuta .= ",".$acabcarr4[$e];
                        $permutas[$x]=$permuta;
                        //echo "<hr> Permuta: a=".$a."d=".$d." Permuta: ". $permuta ;                          
                        $x=$x+1;
                    }         
                }         
            }         
        }        
    }
    
    return $permutas;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
public function Permuta6Carreras($acabcarr0,$acabcarr1,$acabcarr2,$acabcarr3,$acabcarr4,$acabcarr5)
{      
    ////////////////////////////////////////////////////////////////////////////////////////////////77777
    //PERMUTAS DE 6 CARRERAS
    ////////////////////////////////////////////////////////////////////////
    /*
    echo "<hr>Holaaaaaaaaaaaaaaaaaa<br><hr>acabcarr0="; 
    print_r($acabcarr0); echo "</br>acabcarr1=";
    print_r($acabcarr1); echo "</br>acabcarr2=";
    print_r($acabcarr2); echo "</br>acabcarr3=";
    print_r($acabcarr3); echo "</br>acabcarr4=";
    print_r($acabcarr4); echo "</br>acabcarr5=";
    print_r($acabcarr5);
   */
   $x=0;
    for($a=0; $a<count($acabcarr0); $a++) {
        for($b=0; $b<count($acabcarr1); $b++) {
            for($c=0; $c<count($acabcarr2); $c++) {
                for($d=0; $d<count($acabcarr3); $d++) {  
                    for($e=0; $e<count($acabcarr4); $e++) {
                        for($f=0; $f<count($acabcarr5); $f++) {
                        $permuta = $acabcarr0[$a];
                        $permuta .= ",".$acabcarr1[$b];
                        $permuta .= ",".$acabcarr2[$c];
                        $permuta .= ",".$acabcarr3[$d];
                        $permuta .= ",".$acabcarr4[$e];
                        $permuta .= ",".$acabcarr5[$f];
                        $permutas[$x]=$permuta;
                        //echo "<hr> Permuta: a=".$a."d=".$d." Permuta: ". $permuta ;                          
                        $x=$x+1;
                        }
                    }         
                }         
            }         
        }        
    }
    
    return $permutas;
}
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
public function CountPermuta5Carreras($acabcarr0,$acabcarr1,$acabcarr2,$acabcarr3,$acabcarr4)
{      
    ////////////////////////////////////////////////////////////////////////////////////////////////77777
    //CUENTA PERMUTAS DE 5 CARRERAS
    ////////////////////////////////////////////////////////////////////////
    
   $x=0;
    for($a=0; $a<count($acabcarr0); $a++) {
        for($b=0; $b<count($acabcarr1); $b++) {
            for($c=0; $c<count($acabcarr2); $c++) {
                for($d=0; $d<count($acabcarr3); $d++) {  
                    for($e=0; $e<count($acabcarr4); $e++) {
                        $permuta = $acabcarr0[$a];
                        $permuta .= ",".$acabcarr1[$b];
                        $permuta .= ",".$acabcarr2[$c];
                        $permuta .= ",".$acabcarr3[$d];
                        $permuta .= ",".$acabcarr4[$e];
                        $permutas[$x]=$permuta;
                        //echo "<hr> Permuta: a=".$a."d=".$d." Permuta: ". $permuta ;                          
                        $x=$x+1;
                    }         
                }         
            }         
        }        
    }
    
    return count($permutas);
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
public function CountPermuta6Carreras($acabcarr0,$acabcarr1,$acabcarr2,$acabcarr3,$acabcarr4,$acabcarr5)
{      
    ////////////////////////////////////////////////////////////////////////////////////////////////77777
    //CUENTA PERMUTAS DE 6 CARRERAS
    ////////////////////////////////////////////////////////////////////////
   $x=0;
    for($a=0; $a<count($acabcarr0); $a++) {
        for($b=0; $b<count($acabcarr1); $b++) {
            for($c=0; $c<count($acabcarr2); $c++) {
                for($d=0; $d<count($acabcarr3); $d++) {  
                    for($e=0; $e<count($acabcarr4); $e++) {
                        for($f=0; $f<count($acabcarr5); $f++) {
                        $permuta = $acabcarr0[$a];
                        $permuta .= ",".$acabcarr1[$b];
                        $permuta .= ",".$acabcarr2[$c];
                        $permuta .= ",".$acabcarr3[$d];
                        $permuta .= ",".$acabcarr4[$e];
                        $permuta .= ",".$acabcarr5[$f];
                        $permutas[$x]=$permuta;
                        //echo "<hr> Permuta: a=".$a."d=".$d." Permuta: ". $permuta ;                          
                        $x=$x+1;
                        }
                    }         
                }         
            }         
        }        
    }
    
    return count($permutas);
}


}