<?php namespace App\Controllers;
//Conexiones
use Config\Database;
$dbSip        = \Config\Database::connect('thSipacha', true);

//Controladores
use CodeIgniter\Controller;
//Modelos
use App\Models\Auditoria;
use App\Models\Usuarios;
use App\Models\Hipodromos;
use App\Models\Carreras;
use App\Models\Caballos;
use App\Models\Configuracion;
use App\Models\CarreraFin; 
use App\Models\Jganadores;
//Librerias del Codeigneter4
$pager = \Config\Services::pager();

class ThJugadasAGanadorInter extends Th
{

    public function ListarHipodromosInter()
    {      
    //Verifico Sesion de Usuario
    if (!session()->get('isLogged')){
        $mensaje   = "Presione clic en su opcion de menu.";
        $claseMens = "alert alert-danger";
        $titleMens = "<strong>¡Error!</strong> </br>";   
        $datos = array('mensaje'=>$mensaje,'titleMens'=>$titleMens,'claseMens'=>$claseMens);		
        return view('estructura/ingresomalo.php',$datos);
    }  	
        $datosUsuario= $this->SessionUser();
        $MenuIzquierdo = $this->MenuIzquierdo();
        $usu_id = $datosUsuario['id'];
        $MontoActual = $this->MontoDisponible($usu_id);        
        $MenuIzquierdo[0]=" menu-open active";
        $MenuIzquierdo[1]="active";
        $MenuIzquierdo[2]="active";
    
        $dbSip = \Config\Database::connect('thSipacha', true);
        $Carreras = new Carreras($dbSip);  
    
        $ClasDiv   = "table-responsive table-hover";
        $ClasTabla = "table table-bordered table-striped";  
        $idDiv     = ""; 

        $fechahoy= date("Y")."-".date("m")."-".date("d"); 
        $builder = $Carreras -> builder ();
        $builder -> distinct();
        $builder-> Select('carr_fecha as tab_jugada, hip_nombre, tab_hipodromos.hip_id');
        $builder->join('tab_hipodromos','tab_carrera.hip_id = tab_hipodromos.hip_id','inner');
        $builder->where('tab_hipodromos.hip_clasificacion', '0'); //Carreras Interionales
        $builder->where('tab_hipodromos.hip_estatus', '1'); //Hipodromo Activo
        $builder->where('tab_carrera.carr_fecha>=', $fechahoy); //Fecha Activa >= HOY
        $datosCarreras = $builder->get(); 
        $element = $MontoActual;
        $element .= "   
        <div class='".$ClasDiv."' id='".$idDiv."'>
        <table class='".$ClasTabla."'> 
        <thead class='thead-dark'>
        <tr>
        <td style='background-color:#008080'><p style='color:#FFFFFF;'><B>Hipodromos Interionales</B></p></td></tr> 
        <tr> <tr><td>";
        foreach ($datosCarreras->getResultArray() as $row_item){
            $dia = saber_dia($row_item['tab_jugada']);
            /*$element .= " <td>           
            <a href='".BaseUrl()."ThJugadasAGanadorInter/ListarCarrerasInter?th1=".$row_item['tab_jugada']."&th=".$row_item['hip_id']."' > <i class='fas fa-horse'></i>&nbsp;&nbsp;".$row_item['hip_nombre']."&nbsp;&nbsp;".$dia."&nbsp;&nbsp;".cambiarfecha($row_item['tab_jugada'])." </a>
            </td></tr>";*/
            $element .= "   
            <form  method='post' action='".BaseUrl()."/ThJugadasAGanadorInter/ListarCarrerasInter'>
            <input name='th' type='hidden' value='".$row_item['hip_id']."'>
            <input name='th1' type='hidden' value='".$row_item['tab_jugada']."'>
            <button type='submit' class='btn btn-outline-warning btn-block'>
            ".$row_item['hip_nombre']."&nbsp;&nbsp;".$dia."&nbsp;&nbsp;".cambiarfecha($row_item['tab_jugada'])."            
            </button>
            
            </form>
            ";
        }
        $element .="</td></tr></table>";
        //echo $element;
  
        $datos = array('MontoActual'=>$MontoActual,'datosUsuario'=>$datosUsuario,'MenuIzquierdo'=>$MenuIzquierdo,'Hipodromos'=>$element);		
        return view('juegosinter/jghipodromosinter.php',$datos);
    
    }

    
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
public function ListarCarrerasInter()
{      
    //Verifico Sesion de Usuario
    if (!session()->get('isLogged')){
        $mensaje   = "Presione clic en su opcion de menu.";
        $claseMens = "alert alert-danger";
        $titleMens = "<strong>¡Error!</strong> </br>";   
        $datos = array('mensaje'=>$mensaje,'titleMens'=>$titleMens,'claseMens'=>$claseMens);		
        return view('estructura/ingresomalo.php',$datos);
    }

    $request=\Config\Services::request();
    $hip_id = $request->getPostGet('th'); 
    $fecha_carr = $request->getPostGet('th1');

    $datosUsuario= $this->SessionUser();
    $MenuIzquierdo = $this->MenuIzquierdo();
    $MenuIzquierdo[0]=" menu-open active";
    $MenuIzquierdo[1]="active";
    $MenuIzquierdo[2]="active";
    $usu_id = $datosUsuario['id'];
    $MontoActual = $this->MontoDisponible($usu_id);
    $dbSip = \Config\Database::connect('thSipacha', true);
    $Carreras = new Carreras($dbSip);  
    $Hipodromo = new Hipodromos($dbSip);  
    
    $ClasDiv   = "table-responsive table-hover";
    $ClasTabla = "table table-bordered table-striped";  
    $idDiv     = ""; 
    
    $datosHip = $Hipodromo -> find ($hip_id);

    $carr_fechahora_actual = fechaActualConHoraMySql();
    //echo "..............................................................................". $carr_fechahora_actual.".....".$hip_id;
    $builder = $Carreras -> builder ();
    $builder -> distinct();
    $builder-> Select("carr_valida as carrera, tab_carrera.carr_id, hip_id,carr_fecha,carr_horainicio,carr_horafin,carr_valida,carr_dia,carr_metros,carr_cabfav,carr_estatus,carr_comentario, CONCAT( carr_fecha,' ',carr_horafin ) as carr_fechafin");
    $builder->join('tab_carrerafin','tab_carrerafin.carr_id = tab_carrera.carr_id','inner');
    $builder->join('tab_caballos','tab_caballos.carr_id = tab_carrera.carr_id ','inner');
    $builder->where('tab_carrera.hip_id', $hip_id); //Hipodromo seleccionado
    $builder->where('tab_carrera.carr_fecha>', $carr_fechahora_actual); //FechaFinCarrera > FechaHoraActual
    $builder->where('tab_caballos.cab_posifinal', '0'); //Caballo PorCorrer
    $builder->where('tab_carrera.carr_sem_cerrada', '0'); //Semana Abierta
    $builder->where('tab_carrera.carr_fecha',$fecha_carr); //Fecha selecionada
    $builder->orderBy('carr_valida','ASC');
    $datosCarreras = $builder->get(); 
    $element = $MontoActual;
    $element .= "   
    <div class='".$ClasDiv."' id='".$idDiv."'>
    <table class='".$ClasTabla."'> 
    <thead class='thead-dark'>
    <tr>
    <td style='background-color:#008080'><p style='color:#FFFFFF;'><B>HIPODROMO&nbsp;".$datosHip['hip_nombre']."&nbsp;".cambiarfecha($fecha_carr)."</B></p></td></tr> 
    <tr> <tr><td>";
    foreach ($datosCarreras->getResultArray() as $row_item){
        /*$element .= " <td>           
        <a href='".BaseUrl()."ThJugadasAGanadorInter/ListarCaballosInter?th2=".$row_item['carr_fecha']."&th1=".$row_item['hip_id']."&th=".$row_item['carr_id']."' > <i class='fas fa-horse'></i>&nbsp;&nbsp;".$row_item['carr_valida']."&nbsp;&nbsp;CARRERA </a>
        </td></tr>";*/
        $element .= "  
        <form  method='post' action='".BaseUrl()."/ThJugadasAGanadorInter/ListarCaballosInter'>
        <input name='th' type='hidden' value='".$row_item['carr_id']."'>
        <input name='th1' type='hidden' value='".$row_item['hip_id']."'>
        <input name='th2' type='hidden' value='".$row_item['carr_fecha']."'>
        <button type='submit' class='btn btn-outline-warning btn-block'>
        Carrera&nbsp;&nbsp;".$row_item['carr_valida']."
        </button>
        </form>
        ";
    }
    $element .="</td></tr></table>";
    //echo $element;
    $datos = array('MontoActual'=>$MontoActual,'datosHip'=>$datosHip,'datosUsuario'=>$datosUsuario,'MenuIzquierdo'=>$MenuIzquierdo,'Carreras'=>$element);		
    return view('juegosinter/jgcarrerasinter.php',$datos);

}

    
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
public function ListarCaballosInter()
{      
    //Verifico Sesion de Usuario
    if (!session()->get('isLogged')){
        $mensaje   = "Presione clic en su opcion de menu.";
        $claseMens = "alert alert-danger";
        $titleMens = "<strong>¡Error!</strong> </br>";   
        $datos = array('mensaje'=>$mensaje,'titleMens'=>$titleMens,'claseMens'=>$claseMens);		
        return view('estructura/ingresomalo.php',$datos);
    }

    $request=\Config\Services::request();
    $carr_id = $request->getPostGet('th'); 
    $hip_id = $request->getPostGet('th1');
    $fecha_carr = $request->getPostGet('th2');

    $datosUsuario= $this->SessionUser();
    $MenuIzquierdo = $this->MenuIzquierdo();
    $MenuIzquierdo[0]=" menu-open active";
    $MenuIzquierdo[1]="active";
    $MenuIzquierdo[2]="active";
    $usu_id = $datosUsuario['id'];
    $MontoActual = $this->MontoDisponible($usu_id);
    $dbSip = \Config\Database::connect('thSipacha', true);
    $Caballos = new Caballos($dbSip);  
    $Hipodromo = new Hipodromos($dbSip); 
    $Carreras = new Carreras($dbSip); 

    $ClasDiv   = "table-responsive table-hover";
    $ClasTabla = "table table-bordered table-striped";  
    $idDiv     = ""; 
    $datosCarr = $Carreras -> find ($carr_id);
    $datosHip = $Hipodromo -> find ($hip_id);
    //echo "..............................................................................".".....".$hip_id;
    $builder = $Caballos -> builder ();
    $builder ->where('carr_id',$carr_id);
    $datosCaballos = $builder->get(); 
    $element = $MontoActual;
    $element .= "   
    <div class='".$ClasDiv."' id='".$idDiv."'>
    <table class='".$ClasTabla."'> 
    <tr>
    <td colspan=3 style='background-color:#008080'><p style='color:#FFFFFF;'><B>Hipodromo&nbsp;".$datosHip['hip_nombre']."&nbsp;".cambiarfecha($fecha_carr)."</B></td>
    <td style='background-color:#008080'><p style='color:#FFFFFF;'><b> CARRERA N:".$datosCarr['carr_valida']." de ".$datosCarr['carr_metros']."&nbsp;metros</b></p></td></tr> 
    
    <tr> 
    <tr style='background-color:#008080'>
    <td style='background-color:#F7D358'> <b>N.</b></p></td>
    <td style='background-color:#F7D358'> <b>CABALLO</b></p></td>
    <td style='background-color:#F7D358'> <b>JINETE</b></p></td>
    <td style='background-color:#F7D358'> <b>APUESTA</b></p></td>
    </tr>";
    foreach ($datosCaballos->getResultArray() as $row_item){

        if ($row_item['cab_estatus']==1) {   //Caballos Activos
            $element .= "  
            <tr>
            <td><small>".$row_item['cab_posinicial']."</small></td>
            <td><small>".$row_item['cab_nombre']."</small></td>
            <td><small>".$row_item['cab_jinete']."</small></td>
            <td> ";            
            $element .= "  
            <form   method='post' action='".BaseUrl()."/ThJugadasAGanadorInter/FormJugarAGanador'>
            <input name='th' type='hidden' value='".$row_item['cab_id']."'>
            <input name='th1' type='hidden' value='".$row_item['carr_id']."'>
            <input name='th2' type='hidden' value='".$datosHip['hip_id']."'>
            <input name='th3' type='hidden' value='".$fecha_carr."'>
            <button type='submit' class='btn btn-outline-warning btn-block  btn-sm'>
            Apostar
            </button>
            </td>
            </form>
            </tr>
            ";  
        }else {
            $element .= "  
            <tr style='background-color:red'>
            <td><small>".$row_item['cab_posinicial']."</small></td>
            <td><small>".$row_item['cab_nombre']."</small></td>
            <td><small>".$row_item['cab_jinete']."</small></td>
            <td> <small>";               
            $element .= "  RETIRADO </small></td> </tr> ";              
        }
      
    }
    $element .="</tr></table>";
    //echo $element;
    $usu_id = $datosUsuario['id'];
    $MontoActual = $this->MontoDisponible($usu_id);    
    $datos = array('MontoActual'=>$MontoActual,'datosHip'=>$datosHip,'datosUsuario'=>$datosUsuario,'MenuIzquierdo'=>$MenuIzquierdo,'Caballos'=>$element);		
    return view('juegosinter/jgcaballosinter.php',$datos);

}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
public function FormJugarAGanador()
{      
    //Verifico Sesion de Usuario
    if (!session()->get('isLogged')){
        $mensaje   = "Presione clic en su opcion de menu.";
        $claseMens = "alert alert-danger";
        $titleMens = "<strong>¡Error!</strong> </br>";   
        $datos = array('mensaje'=>$mensaje,'titleMens'=>$titleMens,'claseMens'=>$claseMens);		
        return view('estructura/ingresomalo.php',$datos);
    }    
    $request=\Config\Services::request();
    $carr_id = $request->getPostGet('th1'); 
    $hip_id = $request->getPostGet('th2');
    $fecha_carr = $request->getPostGet('th3');
    $cab_id = $request->getPostGet('th');
    $datosUsuario= $this->SessionUser();
    $MenuIzquierdo = $this->MenuIzquierdo();
    $MenuIzquierdo[0]=" menu-open active";
    $MenuIzquierdo[1]="active";
    $MenuIzquierdo[2]="active";
    $usu_id = $datosUsuario['id'];
    $dbSip = \Config\Database::connect('thSipacha', true);
    $Caballos = new Caballos($dbSip);  
    $Hipodromo = new Hipodromos($dbSip); 
    $Configuracion = new Configuracion($dbSip);
    $Carreras = new Carreras($dbSip); 
    $datosHip = $Hipodromo -> find ($hip_id);
    $datosCarr = $Carreras -> find ($carr_id);
    $datosCab = $Caballos -> find ($cab_id);
    $datosConf = $Configuracion -> find (1);
    $usu_id = $datosUsuario['id'];
    $MontoActual = $this->MontoDisponible($usu_id);    
    $datos = array('MontoActual'=>$MontoActual,'datosConf'=>$datosConf,'datosCab'=>$datosCab,'datosHip'=>$datosHip,'datosUsuario'=>$datosUsuario,'MenuIzquierdo'=>$MenuIzquierdo,'datosCarr'=>$datosCarr);		
    return view('juegosinter/jgforminter.php',$datos);    
}
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
public function MultiplicaGanadores()
{      
    $request=\Config\Services::request();
    $cantGanadores = intval($request->getPostGet('cantGanadores')); 
    $un_ganador = intval($request->getPostGet('un_ganador'));   
    $monto = $un_ganador * $cantGanadores;
    echo number_format($monto, 2,',', '.');
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
public function FormJugarAGanador2()
{      
    //Verifico Sesion de Usuario
    if (!session()->get('isLogged')){
        $mensaje   = "Presione clic en su opcion de menu.";
        $claseMens = "alert alert-danger";
        $titleMens = "<strong>¡Error!</strong> </br>";   
        $datos = array('mensaje'=>$mensaje,'titleMens'=>$titleMens,'claseMens'=>$claseMens);		
        return view('estructura/ingresomalo.php',$datos);
    }

    //RecogeFormPost();
    $request=\Config\Services::request();
    $cantGanadores = $request->getPostGet('number');
    $cab_id = $request->getPostGet('th');
    $carr_id = $request->getPostGet('th1'); 
    $hip_id = $request->getPostGet('th2');
    $fecha_carr = $request->getPostGet('th3');

    $datosUsuario= $this->SessionUser();
    $MenuIzquierdo = $this->MenuIzquierdo();
    $MenuIzquierdo[0]=" menu-open active";
    $MenuIzquierdo[1]="active";
    $MenuIzquierdo[2]="active";
    $usu_id = $datosUsuario['id'];
    $dbSip = \Config\Database::connect('thSipacha', true);
    $Caballos = new Caballos($dbSip);  
    $Hipodromo = new Hipodromos($dbSip); 
    $Configuracion = new Configuracion($dbSip);
    $Carreras = new Carreras($dbSip); 
    $Auditoria = new Auditoria($dbSip); 
    //$CarreraFin = new CarreraFin($dbSip);
    $Jganadores = new Jganadores($dbSip); 
    $datosHip = $Hipodromo -> find ($hip_id);
    $datosCarr = $Carreras -> find ($carr_id);
    //$datosCarrFin = $CarreraFin -> find ($carr_id);
    $datosCab = $Caballos -> find ($cab_id);
    //$datosJganadores = $Jganadores;
    $datosConf   = $Configuracion -> find (1);
    $montoJugado = $cantGanadores * $datosConf['jugada_ganador_inter'];

    //Validación del monto mínimo a jugar 
    $jugada_minima_a_ganador_inter = $datosConf['jugada_minima_a_ganador_inter'];
    if($montoJugado < $jugada_minima_a_ganador_inter){
        $mensaje   = "Monto Juado es Inferior al permitido";
        $claseMens = "alert alert-danger";
        $titleMens = "<strong>¡Error!</strong> </br>";   
        $datos = array('mensaje'=>$mensaje,'titleMens'=>$titleMens,'claseMens'=>$claseMens,'datosCarr'=>$datosCarr,'datosCab'=>$datosCab,'datosHip'=>$datosHip,'datosUsuario'=>$datosUsuario,'MenuIzquierdo'=>$MenuIzquierdo,'datosCarr'=>$datosCarr,'datosConf'=>$datosConf);		
        return view('juegosInter/jgforminter.php',$datos);
    }

    //Validación La Carrera este abierta
    $fecha_actual=fechaActualConHoraMySql() ;
    $fecha_actual = strtotime(date("d-m-Y H:i:00",time()));  //$fecha_actual = strtotime("2020-06-28 17:20:00");
    $fecha_carrera = strtotime($datosCarr['carr_fecha']." ".$datosCarr['carr_horafin']);
    if($fecha_actual >= $fecha_carrera){
        $mensaje   = "Carrera Cerrada, No se pudo efectuar la jugada";
        $claseMens = "alert alert-danger";
        $titleMens = "<strong>¡Error!</strong> </br>";   
        $datos = array('mensaje'=>$mensaje,'titleMens'=>$titleMens,'claseMens'=>$claseMens,'datosCarr'=>$datosCarr,'datosCab'=>$datosCab,'datosHip'=>$datosHip,'datosUsuario'=>$datosUsuario,'MenuIzquierdo'=>$MenuIzquierdo,'datosCarr'=>$datosCarr,'datosConf'=>$datosConf);		
        return view('juegosInter/jgforminter.php',$datos);
    }

    //Valido que la cantidad jugada por el usuario no supere el monto configurado como maximo jugada_maxima_a_ganador_Inter
    $jugada_maxima_a_ganador_Inter = $datosConf['jugada_maxima_a_ganador_inter'];
    $datosJganadores = $Jganadores -> builder ();
    $datosJganadores->select('SUM(jgan_monto) as sumado'); 
    $datosJganadores->where('usu_id', $usu_id); 
    $datosJganadores->where('cab_id', $cab_id); 
    $datosJganadores = $datosJganadores->get(); 
    $row = $datosJganadores -> getRow ();   
    if (isset( $row )){  
        $datosJganadores = ['suma' => $row -> sumado] ; 
    }   
    $sumaJugada = $datosJganadores['suma'] + $montoJugado;
    $puedeJugar = $jugada_maxima_a_ganador_Inter -  $datosJganadores['suma'];
    if ($sumaJugada>$jugada_maxima_a_ganador_Inter){
        $mensaje   = "Con esta jugada usted supera el monto que puede jugar a este ejemplar.</br> Sólo puede jugar:". number_format($puedeJugar, 2, ',', '.');
        $claseMens = "alert alert-danger";
        $titleMens = "<strong>¡Error!</strong> </br>";   
        $datos = array('mensaje'=>$mensaje,'titleMens'=>$titleMens,'claseMens'=>$claseMens,'datosCarr'=>$datosCarr,'datosCab'=>$datosCab,'datosHip'=>$datosHip,'datosUsuario'=>$datosUsuario,'MenuIzquierdo'=>$MenuIzquierdo,'datosCarr'=>$datosCarr,'datosConf'=>$datosConf);		
        return view('juegosinter/jgforminter.php',$datos);        
    }
    
    //Valido Sí ya existe una jugada identica a esta
    /*
    $datosJganadores = $Jganadores -> builder ();
    $datosJganadores->select('*'); 
    $datosJganadores->where('usu_id',  $usu_id); 
    $datosJganadores->where('cab_id',  $cab_id); 
    $datosJganadores->where('carr_id', $carr_id); 
    $datosJganadores->where('hip_id',  $hip_id); 
    $datosJganadores->where('jgan_monto', $montoJugado); 
    $datosJganadores = $datosJganadores->get(); 
    $TotalJug = $datosJganadores->resultID->num_rows;
    if ($TotalJug>=1){
        $mensaje   = "Esta Jugada ya existe, por favor intente otro monto";
        $claseMens = "alert alert-danger";
        $titleMens = "<strong>¡Error!</strong> </br>";   
        $datos = array('mensaje'=>$mensaje,'titleMens'=>$titleMens,'claseMens'=>$claseMens,'datosCarr'=>$datosCarr,'datosCab'=>$datosCab,'datosHip'=>$datosHip,'datosUsuario'=>$datosUsuario,'MenuIzquierdo'=>$MenuIzquierdo,'datosCarr'=>$datosCarr,'datosConf'=>$datosConf);		
        return view('juegosinter/jgforminter.php',$datos);         
    }
     */

    //Valido que el monto de la Jugada no supere el saldo disponible
    $dbSipVirtual = \Config\Database::connect('thSipachaVirtual', true);
    $Usuarios = new Usuarios($dbSipVirtual);     
    $builder = $Usuarios -> builder ();
    $builder->where('id', $usu_id); 
    $datosUsuarioAct = $builder->get(); 
    $row_item = $datosUsuarioAct -> getRow ();   
    if (isset( $row_item )){  
        $datosUsuarioAct = [ 'usu_montodisp' => $row_item -> usu_montodisp,
                             'usu_ganjug' =>  $row_item -> usu_ganjug];
        }    
    $saldoDisponible = $datosUsuarioAct['usu_montodisp'];
    $usu_ganjug = $datosUsuarioAct['usu_ganjug'];
    $saldoDisponiblenew = $saldoDisponible - $montoJugado;
    //echo $montoJugado.">".$saldoDisponible ;
    
    if (intval($montoJugado)>intval($saldoDisponible)){
        //echo "Entre....";
        $mensaje   = "Monto de la jugada supera su saldo disponible";
        $claseMens = "alert alert-danger";
        $titleMens = "<strong>¡Error!</strong> </br>";   
        $MontoActual = $this->MontoDisponible($usu_id);    
        //echo "MontoActual:".$MontoActual ;
        $datos = array('MontoActual'=>$MontoActual,'mensaje'=>$mensaje,'titleMens'=>$titleMens,'claseMens'=>$claseMens,'datosCarr'=>$datosCarr,'datosCab'=>$datosCab,'datosHip'=>$datosHip,'datosUsuario'=>$datosUsuario,'MenuIzquierdo'=>$MenuIzquierdo,'datosCarr'=>$datosCarr,'datosConf'=>$datosConf);		
        return view('juegosinter/jgforminter.php',$datos);           
    }
 
    $datos =[
        'usu_montodisp' => $saldoDisponiblenew
    ];
    $UpdateUsuario = $Usuarios -> Update($usu_id,$datos); //Disminuye monto de usuario
    if ($UpdateUsuario===false) {
        var_dump($Usuarios->errors());
    }
    
    //Insertar Apuesta
    $datos = [
        'usu_id'    => $datosUsuario['id'],
        'usu_login' => $datosUsuario['username'],
        'hip_id' => $hip_id,
        'carr_id' => $carr_id,
        'carr_fecha' => $datosCarr['carr_fecha'],
        'carr_valida' => $datosCarr['carr_valida'],
        'cab_id' => $datosCab['cab_id'],
        'cab_posinicial' => $datosCab['cab_posinicial'],
        'jgan_monto' => $montoJugado,
        'jgan_ganadores' => $cantGanadores
    ];
    $guardar= $Jganadores->save($datos);
    if ($guardar===false) {
        var_dump($Jganadores->errors());
    }else{
        $mensaje   = "Jugada Realida con Exito";
        $claseMens = "alert alert-success";
        $titleMens = "<strong>¡Felicidades!</strong> </br>";         
    } 
    
     
    //Insertar Auditoria
    if ($cantGanadores==1){
        $au_descripcion = "Jugada de ".$cantGanadores." ganador en el Hipodromo: ".$datosHip['hip_nombre']." para el dia: ".cambiarfecha($datosCarr['carr_fecha'])." al Caballo ". $datosCab['cab_posinicial']."-". $datosCab['cab_nombre']. ", en la carrera: ". $datosCarr['carr_valida'] . " por un monto de Bs. ".number_format($montoJugado, 2,',', '.') .". <br>Se actualiza su monto disponible segun jugada a ganador de Bs.:". number_format($saldoDisponible, 2,',', '.') . " a Bs.". number_format($saldoDisponiblenew, 2,',', '.');
    } else {
        $au_descripcion = "Jugada de ".$cantGanadores." ganadores en el Hipodromo: ".$datosHip['hip_nombre']." para el dia: ".cambiarfecha($datosCarr['carr_fecha'])." al Caballo ". $datosCab['cab_posinicial']."-". $datosCab['cab_nombre']. ", en la carrera: ". $datosCarr['carr_valida'] . " por un monto de Bs. ".number_format($montoJugado, 2,',', '.') .". <br>Se actualiza su monto disponible segun jugada a ganador de Bs.:". number_format($saldoDisponible, 2,',', '.') . " a Bs.". number_format($saldoDisponiblenew, 2,',', '.');
    }
    
    $datosAuditoria = [
        'au_fecha'=>date("Y") . "-" . date("m") . "-" . date("d"),
        'au_hora'=>strftime("%H:%M:%S"),
        'au_evento'=>"INSERT",
        'au_descripcion'=>$au_descripcion,
        'au_ip'=>ObtenerIP(),
        'usu_id'=>$datosUsuario['id'],
        'au_usulogin'=>$datosUsuario['username'],
        'au_so'=>PHP_OS,
        'au_mostrar'=>1
        ];
    $audit    = $Auditoria->insert($datosAuditoria);
    // El Aumento de la estadistica de jugadas a ganador se hace con trigers
    $usu_id = $datosUsuario['id'];
    $MontoActual = $this->MontoDisponible($usu_id);    
    $datos = array('MontoActual'=>$MontoActual,'cantGanadores'=>$cantGanadores,'montoJugado'=>$montoJugado,'mensaje'=>$mensaje,'titleMens'=>$titleMens,'claseMens'=>$claseMens,'datosCarr'=>$datosCarr,'datosCab'=>$datosCab,'datosHip'=>$datosHip,'datosUsuario'=>$datosUsuario,'MenuIzquierdo'=>$MenuIzquierdo,'datosCarr'=>$datosCarr);
    return view('juegosinter/jgforminter2.php',$datos);    
}


}
