<?php namespace App\Controllers;
//Conexiones
use Config\Database;
$dbSip        = \Config\Database::connect('thSipacha', true);

//Controladores
use CodeIgniter\Controller;
//Modelos
use App\Models\Auditoria;
use App\Models\Usuarios;
use App\Models\Hipodromos;
use App\Models\Carreras;
use App\Models\Caballos;
use App\Models\Configuracion; 
use App\Models\Dupletas;
use App\Models\DupletaCaballos;
use App\Models\DupletasJugadas;

//Librerias del Codeigneter4
$pager = \Config\Services::pager();

class ThJugadasADupletasInter extends Th
{

    public function ListarHipodromosInter()
    {      
    //Verifico Sesion de Usuario
    if (!session()->get('isLogged')){
        $mensaje   = "Presione clic en su opcion de menu.";
        $claseMens = "alert alert-danger";
        $titleMens = "<strong>¡Error!</strong> </br>";   
        $datos = array('mensaje'=>$mensaje,'titleMens'=>$titleMens,'claseMens'=>$claseMens);		
        return view('estructura/ingresomalo.php',$datos);
    }  	
        $datosUsuario= $this->SessionUser();
        $MenuIzquierdo = $this->MenuIzquierdo();
        $usu_id = $datosUsuario['id'];
        $MontoActual = $this->MontoDisponible($usu_id);

        $MenuIzquierdo[0]=" menu-open active";
        $MenuIzquierdo[1]="active";
        $MenuIzquierdo[2]="active";
    
        $dbSip = \Config\Database::connect('thSipacha', true);
        $Carreras = new Carreras($dbSip);  
    
        $ClasDiv   = "table-responsive table-hover";
        $ClasTabla = "table table-bordered table-striped";  
        $idDiv     = ""; 

        $fechahoy= date("Y")."-".date("m")."-".date("d"); 
        $builder = $Carreras -> builder ();
        $builder -> distinct();
        $builder-> Select('carr_fecha as tab_jugada, hip_nombre, tab_hipodromos.hip_id');
        $builder->join('tab_hipodromos','tab_carrera.hip_id = tab_hipodromos.hip_id','inner');
        $builder->where('tab_hipodromos.hip_clasificacion', '0'); //Carreras Internacionales
        $builder->where('tab_hipodromos.hip_estatus', '1'); //Hipodromo Activo
        $builder->where('tab_carrera.carr_fecha>=', $fechahoy); //Fecha Activa >= HOY
        $datosDupletas = $builder->get(); 
        $element = $MontoActual;
        $element .= "        
        <div class='".$ClasDiv."' id='".$idDiv."'>
        <table class='".$ClasTabla."'> 
        <thead class='thead-dark'>
        <tr>
        <td style='background-color:#F7D358'><p style='color:#000000;'>
        <B>Hipodromos Internacionales</B></p></td></tr> 
        <tr> <tr><td>";
        foreach ($datosDupletas->getResultArray() as $row_item){
            $dia = saber_dia($row_item['tab_jugada']);
            $element .= "   
            <form  method='post' action='".BaseUrl()."/ThJugadasADupletasInter/ListarDupletasInternacionales'>
            <input name='th' type='hidden' value='".$row_item['hip_id']."'>
            <input name='th1' type='hidden' value='".$row_item['tab_jugada']."'>
            <button type='submit' class='btn btn-outline-warning btn-block'>
            ".$row_item['hip_nombre']."&nbsp;&nbsp;".$dia."&nbsp;&nbsp;".cambiarfecha($row_item['tab_jugada'])."            
            </button>
            </form>
            ";
        }
        $element .="</td></tr></table></div>";
        //echo $element;
    
        $datos = array('datosUsuario'=>$datosUsuario,'MenuIzquierdo'=>$MenuIzquierdo,'Hipodromos'=>$element);		
        return view('juegosinter/jdhipodromosinter.php',$datos);
    
    }
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
public function ListarDupletasInternacionales()
{      
    //Verifico Sesion de Usuario
    if (!session()->get('isLogged')){
        $mensaje   = "Presione clic en su opcion de menu.";
        $claseMens = "alert alert-danger";
        $titleMens = "<strong>¡Error!</strong> </br>";   
        $datos = array('mensaje'=>$mensaje,'titleMens'=>$titleMens,'claseMens'=>$claseMens);		
        return view('estructura/ingresomalo.php',$datos);
    }

    $request=\Config\Services::request();
    $hip_id = $request->getPostGet('th'); 
    $fecha_carr = $request->getPostGet('th1');

    $datosUsuario= $this->SessionUser();
    $MenuIzquierdo = $this->MenuIzquierdo();    
    $MenuIzquierdo[0]=" menu-open active";
    $MenuIzquierdo[1]="active";
    $MenuIzquierdo[2]="active";
    $usu_id = $datosUsuario['id'];
    $MontoActual = $this->MontoDisponible($usu_id);

    $dbSip = \Config\Database::connect('thSipacha', true);
    $Dupletas = new Dupletas($dbSip);  
    $Hipodromo = new Hipodromos($dbSip); 
    $ClasDiv   = "table-responsive table-hover";
    $ClasTabla = "table table-bordered table-striped";  
    $idDiv     = ""; 

    $fechahoy = fechaActualConHoraMySql();
    $builder = $Dupletas -> builder ();
    $builder -> distinct();
    $builder-> Select("dup_id, dup_nombre AS boton, dup_carreras");
    $builder->join('tab_hipodromos','tab_dupletamaestro.hip_id = tab_hipodromos.hip_id ','inner');
    $builder->where('dup_estatus', '1'); //Dupleta Activa
    $builder->where('tab_dupletamaestro.hip_id', $hip_id); //Hipodromo Seleccionado
    $builder->where('tab_hipodromos.hip_estatus', '1'); //Hipodromo Activo
    $builder->where('dup_jugada', $fecha_carr); //Fecha Seleccionada
    $builder->where('dup_pagada=', 0); //Dupleta No pagada
    $builder->where('dup_cierre<=', $fechahoy); //Fecha Activa >= HOY 
    $datosDupletas = $builder->get(); 

    $datosHip = $Hipodromo -> find ($hip_id);

    $element = $MontoActual;
    $element .= "  
    <div class='".$ClasDiv."' id='".$idDiv."'>
    <table class='".$ClasTabla."'> 
    <thead class='thead-dark'>
    <tr>
    <td style='background-color:#F7D358'><p style='color:#000000;'><B>HIPODROMO&nbsp;".$datosHip['hip_nombre']."&nbsp;".cambiarfecha($fecha_carr)."</B></p></td></tr> 
    <tr> <tr><td>";
    foreach ($datosDupletas->getResultArray() as $row_item){
        $element .= "                                                                                                      
        <form  method='post' action='".BaseUrl()."/ThJugadasADupletasInter/ListarDupletaCaballosInter/".$row_item['dup_id']."/".$hip_id."/".$fecha_carr."/0/0/0'>
        <input name='th' type='hidden' value='".$row_item['dup_id']."'>
        <input name='th1' type='hidden' value='".$hip_id."'>
        <input name='th2' type='hidden' value='".$fecha_carr."'>
        <button type='submit' class='btn btn-outline-warning btn-block'>
        Dupleta&nbsp;&nbsp;".$row_item['boton']."
        </button>
        </form>
        ";
    }
    $element .="</td></tr></table>";
    //echo $element;

    $datos = array('datosHip'=>$datosHip,'datosUsuario'=>$datosUsuario,'MenuIzquierdo'=>$MenuIzquierdo,'Dupletas'=>$element);		
    return view('juegosinter/jdupletasinter.php',$datos);

}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

public function ListarDupletaCaballosInter($dup_id,$hip_id,$fecha_carr,$titleMens,$claseMens,$mensaje)
{      
    $mensaje   = str_replace("%20"," ", $mensaje); 
    $claseMens = str_replace("%20"," ", $claseMens);       
//Verifico Sesion de Usuario
if (!session()->get('isLogged')){
    $mensaje   = "Presione clic en su opcion de menu.";
    $claseMens = "alert alert-danger";
    $titleMens = "<strong>¡Error!</strong> </br>";   
    $datos = array('mensaje'=>$mensaje,'titleMens'=>$titleMens,'claseMens'=>$claseMens);		
    return view('estructura/ingresomalo.php',$datos);
}  	
    $datosUsuario= $this->SessionUser();
    $MenuIzquierdo = $this->MenuIzquierdo();
    $usu_id = $datosUsuario['id'];
    $MontoActual = $this->MontoDisponible($usu_id);

    $MenuIzquierdo[0]=" menu-open active";
    $MenuIzquierdo[1]="active";
    $MenuIzquierdo[2]="active";

    $request=\Config\Services::request();
    //$dup_id = $request->getPostGet('th'); 
    //$hip_id = $request->getPostGet('th1');
    //$fecha_carr = $request->getPostGet('th2'); 
    $dupj_montojugado=0;
    
    
    $dbSip = \Config\Database::connect('thSipacha', true);
    $Dupletas = new Dupletas($dbSip); 
    $Hipodromo = new Hipodromos($dbSip);  
    $Caballos  = new Caballos($dbSip);
    $DupletaCaballos  = new DupletaCaballos($dbSip);
    $DupletasJugadas  = new DupletasJugadas($dbSip);
    
    
    $datosDupleta = $Dupletas -> find ($dup_id);    
    $datosHip = $Hipodromo -> find ($datosDupleta['hip_id']);        
    $carrerasDup = explode ( "," , $datosDupleta['dup_carreras']);

    //Pasar por Form
    $dupj_comb= $datosDupleta['dup_carreras'];
    $dupj_combcarrvalidas= $datosDupleta['dup_validas'];

    $datosCaballosCarr1 = $Caballos -> builder ();
    $datosCaballosCarr1->where('carr_id', $carrerasDup[0]); 
    $datosCaballosCarr1 = $datosCaballosCarr1->get(); 
    $TotalCabCarr1 = $datosCaballosCarr1->resultID->num_rows;
    
    $datosCaballosCarr2 = $Caballos -> builder ();
    $datosCaballosCarr2->where('carr_id', $carrerasDup[1]); 
    $datosCaballosCarr2 = $datosCaballosCarr2->get(); 
    $TotalCabCarr2 = $datosCaballosCarr2->resultID->num_rows;

    $ClasDiv   = "table-responsive table-hover";
    $ClasTabla = "table table-bordered table-striped";  
    $idDiv     = ""; 
    $tmontodupleta=0;
    $cabRetV=0;
    $usu_montocomprado=0;
    $element = $MontoActual;

                //Todos los caballos de la carrera vertical	
                $element="";$c=0; $cabHgan=""; $cabRetH ="";
                foreach ($datosCaballosCarr1->getResultArray() as $reg1)
                {
                    for ($i=0; $i<=$TotalCabCarr1; $i++)
                    {
                        if ($i==0){
                        $carrerahorizontal[$c] = $reg1['cab_id'];
                        }
                    } 				
                $c= $c + 1;	
                }
                //print_r($carrerahorizontal);
                //echo "<br>";
                //Fin caballos Verticales
                //Todos los caballos de la carrera horizontal	
                $element="";$c=0; $cabVgan=""; $cabRetV ="";
                foreach ($datosCaballosCarr2->getResultArray() as $reg2)
                {
                    for ($i=0; $i<=$TotalCabCarr2; $i++)
                    {							
                        $carreravertical[$c] = $reg2['cab_id'];
                    } 				
                $c= $c + 1;	
                }               
                //print_r($carreravertical);
                $ClasDiv   = "table-responsive table-hover";
                $ClasTabla = "table table-bordered table-striped"; 
                $ClasDiv   = "";
                $ClasTabla = "";                  
                $idDiv     = ""; 
                $coll=count($carrerahorizontal)+1;
                $MontoActual = $this->MontoDisponible($usu_id);    
                $element = $MontoActual ;
                $element .= "<div class='".$ClasDiv."' id='".$idDiv."'>
                <table border=1 class='".$ClasTabla."'>";
                $element .= "<tr><td style='background-color:#F7D358' colspan=".$coll."><p style='color:#000000;'>
                <b>Dupleta para ".$datosHip['hip_nombre']." en Fecha: ".cambiarfecha($fecha_carr)." Paga: ".number_format($datosDupleta['dup_paga'], 2,',', '.')."
                </td></tr>";
                $entre = 0; $cabClasH = ''; $cabClasV="";
                for ($contador=0; $contador<=count($carreravertical); $contador++){
                $element .= '<tr>';
                for ($contador2=0; $contador2<count($carrerahorizontal); $contador2++){
                    if ($contador!=0){
                    $cabjug = $carrerahorizontal[$contador2]. ",".$carreravertical[$contador-1];
                    }
                    //echo "<br>".$cabjug;
                    if (($contador==0)&&($contador2==0)){
                        $element .= '<td style="background-color:#F7D358"><small><b><p style="color:#000000;">'.$datosDupleta['dup_nombre'].'</b></p></small></td>';
                        $entre = 0;
                    }       
                    if (($contador==0)&&($contador2>=0)){
                        $datosCabH = $Caballos -> find ($carrerahorizontal[$contador2]);
                        $entre = 1;
                        if ($datosCabH['cab_estatus']==1){ // Caballo Activo
                            $element .= '<td style="background-color:#F7D358"><small><p style="color:#000000;"><b>'.$datosCabH['cab_posinicial']."-".$datosCabH['cab_nombre'].'</b></p></small></td>'; //Caballos Horizontales Activos
                        } else {
                            $cabClasH = $contador2;
                            $element .= '<td style="background-color:red"><small><p style="color:#000000;"><b>'.$datosCabH['cab_posinicial']."-".$datosCabH['cab_nombre'].'</b></p></small></td>'; //Caballos Horizontales Retirados
                        }
                    }  

                    if (($contador>=1)&&($contador2==0)){
                        $datosCabV = $Caballos -> find ($carreravertical[$contador-1]);
                        $entre = 0;
                        if ($datosCabV['cab_estatus']==1){ // Caballo Activo Vertical
                            $element .= '<td style="background-color:#F7D358"><small><p style="color:#000000;"><b>'.$datosCabV['cab_posinicial']."-".$datosCabV['cab_nombre'].'</b></p></small></td>'; //Caballos Verticales Activos
                        } else {
                            $cabClasV = $contador; //Caballo Retirado Vertical
                            $element .= '<td style="background-color:red"><small><p style="color:#000000;"><b>'.$datosCabV['cab_posinicial']."-".$datosCabV['cab_nombre'].'</b></p></small></td>'; //Caballos Verticales Retirados
                        }                        
                    }                                                    

                    //--------------------------------------------------------------
                    if ($entre == 0) {
                        //$element .= '<td><small>'.$cabjug.'</small></td>'; //Combinacion Dupleta
                        $usu_comprador = "CASA";
                        $builder = $DupletasJugadas -> builder ();
                        $builder ->where('dupj_comb',$cabjug);
                        $builder ->where('dupj_combcarrvalidas',$datosDupleta['dup_validas']);
                        $builder ->where('dup_id',$dup_id);
                        $datos_dup = $builder->get();     
                        $existe = $datos_dup->resultID->num_rows;
                        $row = $datos_dup -> getRow ();   
                        if (isset( $row )){  
                            $comprador = $row -> usu_login;
                            $dupj_montojugado = $row -> dupj_montojugado;
                        } 
                        
                        $montodupleta=0;$cabmontoH=0; $cabmontoV =0;
                        $builder = $DupletaCaballos -> builder ();
                        $builder ->where('cab_id',$carrerahorizontal[$contador2]);
                        $datosCaballosH = $builder->get(); 
                        $row_item = $datosCaballosH -> getRow (); 
                        if (isset( $row_item )){  
                            $cabmontoH = $row_item -> cab_monto;
                            }   
                        $builder = $DupletaCaballos -> builder ();
                        $builder ->where('cab_id',$carreravertical[$contador-1]);
                        $datosCaballosV = $builder->get(); 
                        $row_item = $datosCaballosV -> getRow (); 
                        if (isset( $row_item )){  
                            $cabmontoV = $row_item -> cab_monto;
                            }  
                        $montodupleta = $cabmontoH + $cabmontoV ;
                        if (($cabClasH!=$contador2) and ($cabClasV!=$contador)){
                            $element .= "<td align=center><small>"; 
                            
                        } else {
                            $element .= "<td style='background-color:red'  align=center><small>";
                            $existe=1;
                            $comprador = "CASA";
                        }  
                        $element .= "<form  method='post' action='".BaseUrl()."ThJugadasADupletasInter/JugarDupletasInter'  method='post'>";
                        // Aqui se Juega ---------------------------------------------------------------------------------------------------------------------
                        $CabPosIni = explode ( "," , $cabjug); 
                        $datosCabPosIni = $Caballos -> find ($CabPosIni[0]);
                        $dupj_combcabvalidas = $datosCabPosIni['cab_posinicial'].",";
                        $datosCabPosIni = $Caballos -> find ($CabPosIni[1]);
                        $dupj_combcabvalidas .= $datosCabPosIni['cab_posinicial'];
                        if ($existe ==0) {
                            //$element .=  "<p align=center><font size='1' color='#F7D358'><b>CASA</b></font>"; // La CASA  ---- Aqui se Juega
                            //$element .=  "<p align=center><font size='1' color='#F7D358'><b>".number_format($montodupleta, 2, ',', '.')."</b></font></p>"; // Aqui se esrcibe el monto a jugar                                                   
                            $element .= "<p align=center><font size='1' color='#000000'><b>".$dupj_combcabvalidas."</b></font><br>"; 
                            $element .= "
                            <input name='hip_id' type='hidden' value='".$hip_id."'> 
                            <input name='dup_id' type='hidden' value='".$dup_id."'>
                            <input name='dupj_comb' type='hidden' value='".$cabjug."'>
                            <input name='dupj_combcarrvalidas' type='hidden' value='".$datosDupleta['dup_validas']."'>
                            <input name='dupj_combcabvalidas' type='hidden' value='".$dupj_combcabvalidas."'>
                            <input name='dupj_montojugado' type='hidden' value='".$montodupleta."'> 
                            <input name='dupj_montoganado' type='hidden' value='".$datosDupleta['dup_paga']."'> 
                            <button type='submit' class='btn btn-outline-warning btn-sm'><small>
                            ".number_format($montodupleta, 2, ',', '.')."</small>
                            </button>
                            ";                                                    
                        } else {  
                            $element .=  "<p align=center><font size='1' color='#000000'><b>".$comprador."</b></font></p>"; // Aqui se esrcibe el usuario comprador de la combinacion de la dupleta
                            $element .=  "<p align=center><font size='1' color='#000000'><b>".number_format($dupj_montojugado, 2, ',', '.')."</b></font></p>"; // Aqui se esrcibe el monto pagado por la combinacion                        
                        }
                        $element .= '</form>';
                        $element .= '</small></td>'; 
                        }



                }
                $element .= '</tr>';
                }
                

                $element .= '</table></div>';
                
                $datos = array('datosUsuario'=>$datosUsuario,'MenuIzquierdo'=>$MenuIzquierdo,'Dupleta'=>$element,'mensaje'=>$mensaje,'titleMens'=>$titleMens,'claseMens'=>$claseMens);		
                return view('juegosinter/jdforminter.php',$datos);
        
}
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    public function JugarDupletasInter()
    {      
        //RecogeFormPost();
    //Verifico Sesion de Usuario
    if (!session()->get('isLogged')){
        $mensaje   = "Presione clic en su opcion de menu.";
        $claseMens = "alert alert-danger";
        $titleMens = "<strong>¡Error!</strong> </br>";   
        $datos = array('mensaje'=>$mensaje,'titleMens'=>$titleMens,'claseMens'=>$claseMens);		
        return view('estructura/ingresomalo.php',$datos);
    }  
    $dbSip = \Config\Database::connect('thSipacha', true);
    $Dupletas = new Dupletas($dbSip);  
    $Hipodromo = new Hipodromos($dbSip);      
    $request=\Config\Services::request();
    $hip_id = $request->getPostGet('hip_id'); 
    $dup_id = $request->getPostGet('dup_id'); 
    $dupj_comb = $request->getPostGet('dupj_comb'); 
    $dupj_combcarrvalidas = $request->getPostGet('dupj_combcarrvalidas'); 
    $dupj_combcabvalidas = $request->getPostGet('dupj_combcabvalidas'); 
    $dupj_montojugado = $request->getPostGet('dupj_montojugado'); 
    $dupj_montoganado = $request->getPostGet('dupj_montoganado'); 

    $datosUsuario= $this->SessionUser();
    $usu_id = $datosUsuario['id'];
    $MontoActual = $this->MontoDisponible($usu_id);    
    $error=0; 
    $mensaje   = "0";
    $claseMens = "0";
    $titleMens = "0";      
    $datosDupleta = $Dupletas -> find ($dup_id);
    $datosHip = $Hipodromo -> find ($hip_id);

    //Verifico Dupleta aun este abierta para jugar  
    $fecha_actual = strtotime(date("d-m-Y H:i:00",time()));  //$fecha_actual
    $fecha_dupleta = strtotime($datosDupleta['dup_cierre']); 
    if($fecha_actual >= $fecha_dupleta){
        $mensaje   = "Dupleta Cerrada.";
        $claseMens = "alert alert-danger";
        $titleMens = "Error";  
        $error=1;       
    }

    //-------------------------------------------------------------------------------------------
    //Valido el saldo disponible usuario comprador la dupleta
    $dbSipVirtual = \Config\Database::connect('thSipachaVirtual', true);
    $Usuarios = new Usuarios($dbSipVirtual);     
    $builder = $Usuarios -> builder ();
    $builder->where('id', $usu_id); 
    $datosUsuarioAct = $builder->get(); 
    $row_item = $datosUsuarioAct -> getRow (); 
    $saldoDisponibleAnt = $row_item -> usu_montodisp; 
    $usu_dupjug = $row_item -> usu_dupjug; 
    //$usu_login = $row_item -> username;   
    if ($saldoDisponibleAnt<$dupj_montojugado) {
        $mensaje   = "Saldo Insuficiente.";
        $claseMens = "alert alert-danger";
        $titleMens = "Error";  
        $error=1;  
    }
    
    //-------------------------------------------------------------------------------------------
    //Valido el saldo disponible usuario comprador la dupleta
    $dbSip = \Config\Database::connect('thSipacha', true);
    $Auditoria = new Auditoria($dbSip);  
    $DupletasJugadas  = new DupletasJugadas($dbSip);
    $builder = $DupletasJugadas -> builder ();
    $builder ->where('dupj_comb',$dupj_comb);
    $builder ->where('dupj_combcarrvalidas',$dupj_combcarrvalidas);
    $builder ->where('dup_id',$dup_id);
    $datos_dup = $builder->get();     
    $existe = $datos_dup->resultID->num_rows;
    $row = $datos_dup -> getRow ();   
    if ($existe >= 1){
        $mensaje   = "Jugada ya Realizada por otro usuario.";
        $claseMens = "alert alert-danger";
        $titleMens = "Error";  
        $error=1;  
    }
if ($error ==0) {
    //-------------------------------------------------------------------------------------------    
    //Inserta la Jugada de la Dupleta
    $datos=[
        'dup_id' => $dup_id,
        'usu_id' => $usu_id,
        'usu_login' => $datosUsuario['username'],
        'dupj_comb' => $dupj_comb,
        'dupj_combcarrvalidas' => $dupj_combcarrvalidas,
        'dupj_combcabvalidas' => $dupj_combcabvalidas,
        'dupj_ip' => ObtenerIP(),
        'dupj_fechahora' => fechaActualConHoraMySql(),
        'dupj_montojugado' => $dupj_montojugado,
        'dupj_montoganado' => $dupj_montoganado
    ];
    print_r($datos);
    $insertDup    = $DupletasJugadas->insert($datos);
    //-------------------------------------------------------------------------------------------    
    //Inserto Auditoria al Usuario
    $saldoDisponibleNew = $saldoDisponibleAnt - $dupj_montojugado;
    $au_descripcion ="Disminuye su saldo disponible en Bs.". number_format($dupj_montojugado, 2,',', '.')." por Dupleta Jugada: ".$datosDupleta['dup_nombre']." a los Caballos:".$dupj_combcabvalidas. " respectivamente. En el hipodromo: ". $datosHip['hip_nombre'] ." de fecha: " . cambiarfecha($datosDupleta['dup_jugada']) ."<br>Se actualiza su monto disponible segun jugada de dupleta de Bs.:" .number_format( $saldoDisponibleAnt, 2,',', '.') . " a Bs.". number_format($saldoDisponibleNew, 2,',', '.');
    $datosAuditoria = [
        'au_fecha'=>date("Y") . "-" . date("m") . "-" . date("d"),
        'au_hora'=>strftime("%H:%M:%S"),
        'au_evento'=>"INSERT",
        'au_descripcion'=>$au_descripcion,
        'au_ip'=>ObtenerIP(),
        'usu_id'=>$datosUsuario['id'],
        'au_usulogin'=>$datosUsuario['username'],
        'au_so'=>PHP_OS,
        'au_mostrar'=>1
        ];
    $audit    = $Auditoria->insert($datosAuditoria);    

    //-------------------------------------------------------------------------------------------    
    //Disminuyo saldo disponible y aumento estadistica
    $dbSipVirtual = \Config\Database::connect('thSipachaVirtual', true);
    $Usuarios = new Usuarios($dbSipVirtual);     
    $datos = ['usu_montodisp' => $saldoDisponibleNew,
              'usu_dupjug' => $usu_dupjug + 1
    ];
    $UpdateUsuario = $Usuarios -> Update($usu_id,$datos); //Disminuye -- Resta el dinero de la jugada dela dupleat
    $mensaje   = "Dupleta Jugada con Exito";
    $claseMens = "alert alert-success";
    $titleMens = "Felicidades";   
//Datos de la vista
}
$url = BaseUrl() . "/ThJugadasADupletasInter/ListarDupletaCaballosInter/".$dup_id."/".$hip_id."/".$datosDupleta['dup_jugada']."/".$titleMens."/".$claseMens."/".$mensaje;
return redirect()->to($url);       
 }
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
}