<?php namespace App\Controllers;
//Conexiones
use Config\Database;
$dbSip  = \Config\Database::connect('thSipacha', true);

//Controladores
use CodeIgniter\Controller;
//Modelos
use App\Models\Auditoria;
use App\Models\Usuarios;
use App\Models\Bancos;
use App\Models\Retiros;
use App\Models\Configuracion;
//Librerias del Codeigneter4
$pager = \Config\Services::pager();

class SipachaVirtualRetiros extends Th
{
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
public function FormEnviarRetiro($mensaje,$claseMens,$titleMens){
    //Verifico Sesion de Usuario
    $session = session();
    if (!session()->get('isLogged')){
        $mensaje   = "Presione clic en su opcion de menu.";
        $claseMens = "alert alert-danger";
        $titleMens = "<strong>¡Error!</strong> </br>";   
        $datos = array('mensaje'=>$mensaje,'titleMens'=>$titleMens,'claseMens'=>$claseMens);		
        return view('estructura/ingresomalo.php',$datos);
    }  	
    $mensaje   = str_replace("%20"," ", $mensaje); 
    $claseMens = str_replace("%20"," ", $claseMens);      
    $datosUsuario= $this->SessionUser();
    $MenuIzquierdo = $this->MenuIzquierdo();
    $usu_id = $datosUsuario['id'];
    $MontoActual = $this->MontoDisponible($usu_id);
    $FormRetiro="";
    $dbSipVirtual = \Config\Database::connect('thSipachaVirtual', true);
    $Usuarios = new Usuarios($dbSipVirtual);     
    $datosUsuarioActual = $Usuarios -> find ($usu_id);
    $ClasDiv   = "table-responsive table-hover";
    $ClasTabla = "table table-bordered table-striped";
    $idDiv     = ""; $element2 ="";
    $element = $MontoActual;
    $element .= "   
    <form  method='post' action='".BaseUrl()."/SipachaVirtualRetiros/EnviarRetiro'>
    <div class='".$ClasDiv."' id='".$idDiv."'>
    <table class='".$ClasTabla."'> 
    <tr><td colspan=2 align=center style='background-color:#0b054a'><p style='color:#FFFFFF;'><b>Enviar Retiro</b></p></td></tr>";
    $element .= "<tr><td>Titular:</td>";
    $element .= "<input name='ret_titularrec' type='hidden' value='".$datosUsuarioActual['name']." ".$datosUsuarioActual['apellido']."'>";
    $element .= "<td>".$datosUsuarioActual['name']." ".$datosUsuarioActual['apellido']."</td></tr>";       
    $element .= "<tr><td>Banco:</td>";    
    $dbSip = \Config\Database::connect('thSipacha', true);
    $Bancos   = new Bancos($dbSip); 
    $Retiros   = new Retiros($dbSip);
    $Configuracion = new Configuracion($dbSip);
    $datosConf = $Configuracion -> find (1);      
    $datosBanco = $Bancos -> find ($datosUsuarioActual['usu_ban_id']); 
    $element .= "<input name='ret_ban_id_receptor' type='hidden' value='".$datosUsuarioActual['usu_ban_id']."'>";
    $element .= " <td>".$datosBanco['ban_nombre']."</td>"; 
    $element .= "<input name='ret_cedularec' type='hidden' value='".$datosUsuarioActual['usu_cedula']."'>";  
    $element .= "<tr><td>Cedula:</td>"; 
    $element .= "<td>".$datosUsuarioActual['usu_cedula']."</td></tr>";         
    $element .= "<tr><td>Tipo de Cuenta:</td>";
    $element .= "<td>".$datosUsuarioActual['usu_tipocta']."</td></tr>";
    $element .= "<input name='ret_tipocta' type='hidden' value='".$datosUsuarioActual['usu_tipocta']."'>";       
    $element .= "<tr><td>Numero de Cuenta:</td>";
    $element .= "<td>".$datosUsuarioActual['usu_numcta']."</td></tr>"; 
    $element .= "<input name='ret_numcta' type='hidden' value='".$datosUsuarioActual['usu_numcta']."'>";              
    $element .= "<tr><td>Correo:</td>";
    $element .= "<td>".$datosUsuarioActual['email']."</td></tr>";  
    $element .= "<input name='ret_correorec' type='hidden' value='".$datosUsuarioActual['email']."'>";                           
    $element .= "<tr>";         
    $element .= "<tr><td>Monto:</td>";
    $element .= "<td><input type=number name='ret_montosol' id='ret_montosol' rounded border border-primary' min='".$datosConf['retiro_minimo']."' required integer></td></tr>";        
    $element .= "<tr>";
    $element .= "<td colspan=2><button type='submit' class='btn btn-info btn-block'> Enviar </button></td>";            
    $element .="</tr></table></div></form>";
    
    $builder = $Retiros -> builder ();
    $builder -> join('tab_bancos','tab_retiros.ret_ban_id_receptor = tab_bancos.ban_id','inner');
    $builder -> where('tab_retiros.ret_usu_id_sol',$usu_id) ;
    $builder -> where('tab_retiros.ret_pagado','0') ;
    $builder -> orderBy('ret_fechasol','DESC'); 
    $datosRetEnviados = $builder->get(); 
    $TotalReg = $datosRetEnviados->resultID->num_rows;
    $ClasDiv   = "table-responsive table-hover";
    $ClasTabla = "table table-bordered table-striped";  
    $idDiv     = ""; 
    $TitCol    = array('Fecha Retiro','Banco','Monto');
    $AnchoCol  = array('1'=>'30','2'=>'40','3'=>'30');
    if ($TotalReg >=1){
    $element2 = "   
    <div class='".$ClasDiv."' id='".$idDiv."'>
    <table align='center' border='1' class='".$ClasTabla."'> 
    <tr>
    <td colspan=2 align=left style='background-color:#0b054a'><p style='color:#FFFFFF;'><b>Retiro o Transferencias Por Pagar</b></p></td>
    <td colspan=1 align=right style='background-color:#0b054a'><p style='color:#FFFFFF;'><b>Total:  </b>".$TotalReg."</p></td></tr> 
    <tr> ";
    $i=1;
    foreach ($TitCol as $col) {  
        $element2 .= "
        <td width='".$AnchoCol[$i]."' style='background-color:#0b054a'> <p style='color:#FFFFFF;'><b>"
        .$col."</b></p></td> ";    
        $i=$i+1; 
    }
     
    $element2 .= "
    </tr>
    <tr>";
    foreach ($datosRetEnviados->getResultArray() as $row_item){
        $element2 .= " <td><small>".$row_item['ret_fechasol']."</small></td>";  
        $datosBanco = $Bancos -> find ($row_item['ret_ban_id_receptor']);
        $element2 .= " <td><small>".$datosBanco['ban_nombre']."</small></td>";                
        $element2 .= " <td><small>".number_format($row_item['ret_montosol'], 2,',', '.')."</small></td>";         
        $element2 .= "</tr>";  
    }    
    $element2 .="</table>";
    }

    $datos = array('Listado'=>$element2 ,'FormRetiro'=>$element,'datosUsuario'=>$datosUsuario,'MontoActual'=>$MontoActual,'mensaje'=>$mensaje,'titleMens'=>$titleMens,'claseMens'=>$claseMens);		
    return view('estructura/enviarretiro.php',$datos);        
    //------------------------------------------------------------------------------------



}        
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
public function EnviarRetiro(){

    RecogeFormPost();
    //Verifico Sesion de Usuario
    if (!session()->get('isLogged')){
        $mensaje   = "Presione clic en su opcion de menu.";
        $claseMens = "alert alert-danger";
        $titleMens = "<strong>¡Error!</strong> </br>";   
        $datos = array('mensaje'=>$mensaje,'titleMens'=>$titleMens,'claseMens'=>$claseMens);		
        return view('estructura/ingresomalo.php',$datos);
    } 
    $datosUsuario= $this->SessionUser();
    $MenuIzquierdo = $this->MenuIzquierdo();
    $usu_id = $datosUsuario['id'];

    $request=\Config\Services::request();
    $ret_montosol = $request->getPostGet('ret_montosol');   
    $ret_ban_id_receptor = $request->getPostGet('ret_ban_id_receptor'); 
    $ret_titularrec = $request->getPostGet('ret_titularrec');    
    $ret_cedularec = $request->getPostGet('ret_cedularec');
    $ret_correorec = $request->getPostGet('ret_correorec');
    $ret_tipocta = $request->getPostGet('ret_tipocta');
    $ret_numcta = $request->getPostGet('ret_numcta');
    
    //Verifico que el monto a retirar sea superior al monto disponible
    $dbSipVirtual = \Config\Database::connect('thSipachaVirtual', true);
    $Usuarios = new Usuarios($dbSipVirtual); 
    $datosUsuarioActual = $Usuarios -> find ($usu_id);
    $saldoDisponibleAct = $datosUsuarioActual['usu_montodisp'];
    $saldoDisponiblenew = $saldoDisponibleAct - $ret_montosol;
    if ($saldoDisponibleAct <$ret_montosol ){
        $mensaje   = "El retiro no puede superar el monto disponible";
        $claseMens = "alert alert-danger";
        $titleMens = "Error";   
        $url = BaseUrl() . "/SipachaVirtualRetiros/FormEnviarRetiro/".$mensaje."/".$claseMens."/".$titleMens;
        return redirect()->to($url);               
    }
    $datos =[
        'usu_montodisp' => $saldoDisponiblenew
    ];
    $UpdateUsuario = $Usuarios -> Update($usu_id,$datos); //Disminuye monto de retiro al usuario
    if ($UpdateUsuario===false) {
        var_dump($Usuarios->errors());
    }

    $dbSip = \Config\Database::connect('thSipacha', true);
    $Auditoria = new Auditoria($dbSip);      
    $Bancos   = new Bancos($dbSip); 
    $Retiros   = new Retiros($dbSip); 

    $datosUsuario= $this->SessionUser();
    $MenuIzquierdo = $this->MenuIzquierdo();
    $usu_id = $datosUsuario['id'];
    $MontoActual = $this->MontoDisponible($usu_id);    
    $fecha_actual = date("Y-m-d H:i:00",time());
    $datosBanco = $Bancos -> find ($ret_ban_id_receptor);
    $datos =[
            'ret_usu_id_sol' => $datosUsuario['id'], 
            'ret_fechasol' => $fecha_actual,
            'ret_montosol' => $ret_montosol,
            'ret_ban_id_emisor' =>  $ret_ban_id_receptor, 
            'ret_ban_id_receptor' => $ret_ban_id_receptor, 
            'ret_titularrec' => $ret_titularrec, 
            'ret_cedularec' => $ret_cedularec, 
            'ret_correorec' => $ret_correorec, 
            'ret_tipocta' => $ret_tipocta,
            'ret_numcta' => $ret_numcta,
            'ret_fechapagobanco' =>$fecha_actual,
            'ret_fechapago' => $fecha_actual,
            'ret_usu_login_sol'=> $datosUsuario['username'],
            'ret_usu_login_pagador'=> $datosUsuario['username']
    ]; 

    //------Valido que el retiro aun no haya sido enviado -------------    

    $insertRet    = $Retiros->insert($datos);
    print_r($datos);
    //exit();

    $au_descripcion="Envio solicitud de retiro en: ". $datosBanco['ban_nombre']." por un monto de Bs. ".number_format($ret_montosol, 2,',', '.')."  de fecha". cambiarfecha(date("Y-m-d H:i:00")) . ". <br>Se actualiza su monto disponible segun solicitud de retiro de Bs.:". number_format($saldoDisponibleAct, 2,',', '.') . " a Bs.". number_format($saldoDisponiblenew, 2,',', '.');
    $datosAuditoria = [
        'au_fecha'=>date("Y") . "-" . date("m") . "-" . date("d"),
        'au_hora'=>strftime("%H:%M:%S"),
        'au_evento'=>"INSERT",
        'au_descripcion'=>$au_descripcion,
        'au_ip'=>ObtenerIP(),
        'usu_id'=>$datosUsuario['id'],
        'au_usulogin'=>$datosUsuario['username'],
        'au_so'=>PHP_OS,
        'au_mostrar'=>1
        ];
    $audit    = $Auditoria->insert($datosAuditoria);  

    print_r ($datos);  
    $mensaje   = "Retiro enviado con exito.";
    $claseMens = "alert alert-success";
    $titleMens = "Felicidades";        
    $url = BaseUrl() . "/SipachaVirtualRetiros/FormEnviarRetiro/".$mensaje."/".$claseMens."/".$titleMens;
    return redirect()->to($url); 

}
}