<?php namespace App\Controllers;
//Conexiones
use Config\Database;
$dbSip  = \Config\Database::connect('thSipacha', true);

//Controladores
use CodeIgniter\Controller;
//Modelos
use App\Models\Auditoria;
use App\Models\Usuarios;
use App\Models\Bancos;
use App\Models\Propinas;
use App\Models\Configuracion;
//Librerias del Codeigneter4
$pager = \Config\Services::pager();

class SipachaVirtualPropinas extends Th
{
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
public function FormEnviarPropina($mensaje,$claseMens,$titleMens,$usu_id){
    //Verifico Sesion de Usuario
    $dbSipVirtual = \Config\Database::connect('thSipachaVirtual', true);
    $Usuarios = new Usuarios($dbSipVirtual);  
    $builder = $Usuarios -> builder ();
    $builder->where('id', $usu_id); 
    $datosUsuario = $builder->get(); 
    $datosUsuarioActual = $Usuarios -> find ($usu_id);
    $row_item = $datosUsuario -> getRow ();   
    if (isset( $row_item )){  
        $datosUsuario = [
            'id'        => $row_item -> id,
            'nombre'    => $row_item -> name,
            'apellido'  => $row_item -> apellido,
            'username'  => $row_item -> username,
            'usu_sexo'  => $row_item -> usu_sexo,
            'usu_rol_id'=> $row_item -> usu_rol_id,                
            'email'     => $row_item -> email,
            'isLogged'  => true
        ];
        session()->set($datosUsuario);  

    //------------------------------------------------------------------------------------------------
    $mensaje   = str_replace("%20"," ", $mensaje); 
    $claseMens = str_replace("%20"," ", $claseMens);      
    $datosUsuario= $this->SessionUser();
    $MenuIzquierdo = $this->MenuIzquierdo();
    $usu_id = $datosUsuario['id'];
    $MontoActual = $this->MontoDisponible($usu_id);
    $FormRetiro="";
    
    $ClasDiv   = "table-responsive table-hover";
    $ClasTabla = "table table-bordered table-striped";
    $idDiv     = ""; $element2 ="";
    $element = $MontoActual;
    $element .= "   
    <form  method='post' action='".BaseUrl()."/SipachaVirtualPropinas/EnviarPropina'>
    <div class='".$ClasDiv."' id='".$idDiv."'>
    <table class='".$ClasTabla."'> 
    <tr><td colspan=2 align=center style='background-color:#0b054a'><p style='color:#FFFFFF;'><b>Enviar Propina</b></p></td></tr>";
    $element .= "<tr><td>Titular:</td>";
    $element .= "<input name='pro_usuario' type='hidden' value='".$datosUsuarioActual['name']." ".$datosUsuarioActual['apellido']."'>";
    $element .= "<td>  ".$datosUsuarioActual['name']." ".$datosUsuarioActual['apellido']."</td></tr>";       
    
    $dbSip = \Config\Database::connect('thSipacha', true);
    $Propinas   = new Propinas($dbSip);
    $Configuracion = new Configuracion($dbSip);
    $datosConf = $Configuracion -> find (1);   
    $element .= "<tr><td rowspan='5'>Monto:</td>";   
    $element .= "";
    
    $element .= "<td><input type='radio' name='pro_monto' value='".$datosConf['propina1_monto']."' required>  ".number_format($datosConf['propina1_monto'], 2,',', '.')."</td></tr>";        
    $element .= "<td><input type='radio' name='pro_monto' value='".$datosConf['propina2_monto']."' required>  ".number_format($datosConf['propina2_monto'], 2,',', '.')."</td></tr>";        
    $element .= "<td><input type='radio' name='pro_monto' value='".$datosConf['propina3_monto']."' required>  ".number_format($datosConf['propina3_monto'], 2,',', '.')."</td></tr>";        
    $element .= "<td><input type='radio' name='pro_monto' value='".$datosConf['propina4_monto']."' required>  ".number_format($datosConf['propina4_monto'], 2,',', '.')."</td></tr>";              
    $element .= "<td><input type='radio' name='pro_monto' value='".$datosConf['propina5_monto']."' required>  ".number_format($datosConf['propina5_monto'], 2,',', '.')."</td></tr>";        
    $element .= "<tr>";
    $element .= "<td colspan=2><button type='submit' class='btn btn-info btn-block'> Enviar </button></td>";            
    $element .="</tr></table></div></form>";

    $datos = array('FormPropina'=>$element,'datosUsuario'=>$datosUsuario,'MontoActual'=>$MontoActual,'mensaje'=>$mensaje,'titleMens'=>$titleMens,'claseMens'=>$claseMens);		
    return view('estructura/enviarpropina.php',$datos);        
    //------------------------------------------------------------------------------------
    } 
    else {
        $mensaje   = "Presione clic en su opcion de menu.";
        $claseMens = "alert alert-danger";
        $titleMens = "<strong>¡Error!</strong> </br>";   
        $datos = array('mensaje'=>$mensaje,'titleMens'=>$titleMens,'claseMens'=>$claseMens);		
        return view('estructura/ingresomalo.php',$datos);
    }


}        
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
public function EnviarPropina(){

    //RecogeFormPost();

    //Verifico Sesion de Usuario
    if (!session()->get('isLogged')){
        $mensaje   = "Presione clic en su opcion de menu.";
        $claseMens = "alert alert-danger";
        $titleMens = "<strong>¡Error!</strong> </br>";   
        $datos = array('mensaje'=>$mensaje,'titleMens'=>$titleMens,'claseMens'=>$claseMens);		
        return view('estructura/ingresomalo.php',$datos);
    } 
    $datosUsuario= $this->SessionUser();
    $MenuIzquierdo = $this->MenuIzquierdo();
    $usu_id = $datosUsuario['id'];

    $request=\Config\Services::request();
    $pro_monto = $request->getPostGet('pro_monto');   

    //Verifico que el monto de la propina NO sea superior al monto disponible
    $dbSipVirtual = \Config\Database::connect('thSipachaVirtual', true);
    $Usuarios = new Usuarios($dbSipVirtual); 
    $datosUsuarioActual = $Usuarios -> find ($usu_id);
    $saldoDisponibleAct = $datosUsuarioActual['usu_montodisp'];
    $saldoDisponiblenew = $saldoDisponibleAct - $pro_monto;
    echo "saldoDisponibleAct".$saldoDisponibleAct;
    echo "<br>saldoDisponiblenew".$saldoDisponiblenew;
    if ($saldoDisponibleAct <$pro_monto ){
        $mensaje   = "La propina no puede superar el monto disponible";
        $claseMens = "alert alert-danger";
        $titleMens = "Error";   
        $url = BaseUrl() . "/SipachaVirtualPropinas/FormEnviarPropina/".$mensaje."/".$claseMens."/".$titleMens."/".$usu_id;
        return redirect()->to($url);               
    }
    $datos =[
        'usu_montodisp' => $saldoDisponiblenew
    ];
    $UpdateUsuario = $Usuarios -> Update($usu_id,$datos); //Disminuye monto de la propina al usuario
    if ($UpdateUsuario===false) {
        var_dump($Usuarios->errors());
    }

    $dbSip = \Config\Database::connect('thSipacha', true);
    $Auditoria = new Auditoria($dbSip);      
    $Propinas   = new Propinas($dbSip); 

    $datosUsuario= $this->SessionUser();
    $MenuIzquierdo = $this->MenuIzquierdo();
    $usu_id = $datosUsuario['id'];
    $MontoActual = $this->MontoDisponible($usu_id);    
    $fecha_actual = date("Y-m-d H:i:00",time());
    
    $datos =[
        'pro_usu_id'=> $datosUsuario['id'], 
        'pro_usu_login'=> $datosUsuario['username'], 
        'pro_monto'=> $pro_monto, 
        'pro_fecha' => date("Y") . "-" . date("m") . "-" . date("d")
    ]; 

    //------Valido que el retiro aun no haya sido enviado -------------    

    $insertProp    = $Propinas->insert($datos);
    print_r($datos);
    //exit();

    $au_descripcion="Envio una propina de Bs. ".number_format($pro_monto, 2,',', '.')."  en fecha". cambiarfecha($datos['pro_fecha']) . ". <br>Se actualiza su monto disponible segun propina otorgada de Bs.:". number_format($saldoDisponibleAct, 2,',', '.') . " a Bs.". number_format($saldoDisponiblenew, 2,',', '.');
    $datosAuditoria = [
        'au_fecha'=>date("Y") . "-" . date("m") . "-" . date("d"),
        'au_hora'=>strftime("%H:%M:%S"),
        'au_evento'=>"INSERT",
        'au_descripcion'=>$au_descripcion,
        'au_ip'=>ObtenerIP(),
        'usu_id'=>$datosUsuario['id'],
        'au_usulogin'=>$datosUsuario['username'],
        'au_so'=>PHP_OS,
        'au_mostrar'=>1
        ];
    $audit    = $Auditoria->insert($datosAuditoria);  

    print_r ($datos);  
    $mensaje   = "Propina enviada con exito.";
    $claseMens = "alert alert-success";
    $titleMens = "Felicidades";        
    $url = BaseUrl() . "/SipachaVirtualPropinas/FormEnviarPropina/".$mensaje."/".$claseMens."/".$titleMens."/".$usu_id;
    return redirect()->to($url); 

}
}