<?php namespace App\Controllers;
//Conexiones
//Controlador Th
//Controladores
use CodeIgniter\Controller;
//Modelos
use App\Models\Auditoria;
use App\Models\Usuarios;
use App\Models\Bancos;
use App\Models\Pais;
use App\Models\Configuracion;
//Librerias del Codeigneter4
$pager = \Config\Services::pager();

class SipachaVirtualPerfil extends Th
{
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
public function VerPerfil($mensaje,$titleMens,$claseMens,$usu_id){
    //Creo Sesion de Usuario
    $dbSipVirtual = \Config\Database::connect('thSipachaVirtual', true);
    $Usuarios = new Usuarios($dbSipVirtual);  
    $builder = $Usuarios -> builder ();
    $builder->where('id', $usu_id); 
    $datosUsuario = $builder->get(); 
    $datosUsuarioActual = $Usuarios -> find ($usu_id);
    $row_item = $datosUsuario -> getRow ();   
    if (isset( $row_item )){  
        $datosUsuario = [
            'id'        => $row_item -> id,
            'nombre'    => $row_item -> name,
            'apellido'  => $row_item -> apellido,
            'username'  => $row_item -> username,
            'usu_sexo'  => $row_item -> usu_sexo,
            'usu_rol_id'=> $row_item -> usu_rol_id,                
            'email'     => $row_item -> email,
            'isLogged'  => true
        ];
        session()->set($datosUsuario);  

    //------------------------------------------------------------------------------------------------    
    $datosUsuario= $this->SessionUser();
    $usu_id = $datosUsuario['id'];
    $MontoActual = $this->MontoDisponible($usu_id);
    $datosUsuarioAct = $Usuarios -> find ($usu_id);   
    $usu_sexo =  $this-> ListaDesplegableSexo($datosUsuarioAct['usu_sexo'],'usu_sexo','usu_sexo','custom-select mr-sm-2');

    $dbSip = \Config\Database::connect('thSipacha', true);
    $Bancos = new Bancos($dbSip);  
    $builder = $Bancos -> builder (); 
    $Bancos = $builder->get(); 
    $usu_banco =  $this-> ListaDesplegable($Bancos,'usu_ban_id','usu_ban_id','custom-select mr-sm-2','ban_id','ban_nombre',$datosUsuarioAct['usu_ban_id']);

    $Pais = new Pais($dbSip);  
    $builder = $Pais -> builder ();    
    $Pais = $builder->get(); 
    $usu_pais =  $this-> ListaDesplegable($Pais,'usu_pais_id','usu_pais_id','custom-select mr-sm-2','pais_id','pais_nombre',$datosUsuarioAct['usu_pais_id']);

    $datos = array('mensaje'=>$mensaje,'titleMens'=>$titleMens,'claseMens'=>$claseMens,'MontoActual'=>$MontoActual,'UsuarioPerfil'=>$datosUsuarioAct,'usu_sexo'=>$usu_sexo,'usu_banco'=>$usu_banco,'usu_pais'=>$usu_pais);
    return view('estructura/perfil.php',$datos);        
    //------------------------------------------------------------------------------------
    } 
    else {
        $mensaje   = "Presione clic en su opcion de menu.";
        $claseMens = "alert alert-danger";
        $titleMens = "<strong>¡Error!</strong> </br>";   
        $datos = array('mensaje'=>$mensaje,'titleMens'=>$titleMens,'claseMens'=>$claseMens);		
        return view('estructura/ingresomalo.php',$datos);
    }


}        
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
public function ListaDesplegableSexo($compara,$nameSelec,$nameid,$class){
    $element = '<select name="'.$nameSelec.'" id="'.$nameid.'" class="'.$class.'">';
    if ($compara=='F'){
        $element .= '<option value="F" selected>Femenino</option>';
        $element .= '<option value="M" >Masculino</option>';                
    } else {
        $element .= '<option value="F" >Femenino</option>';
        $element .= '<option value="M" selected>Masculino</option>';
    }
    $element .= '</select>';
    return $element;
}
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
public function EditarPerfil(){
    //Verifico Sesion de Usuario
    if (!session()->get('isLogged')){
        $mensaje   = "Presione clic en su opcion de menu.";
        $claseMens = "alert alert-danger";
        $titleMens = "<strong>¡Error!</strong> </br>";   
        $datos = array('mensaje'=>$mensaje,'titleMens'=>$titleMens,'claseMens'=>$claseMens);		
        return view('estructura/ingresomalo.php',$datos);
    }
    $dbSipVirtual = \Config\Database::connect('thSipachaVirtual', true);
    $Usuarios = new Usuarios($dbSipVirtual);  

    $datosUsuario= $this->SessionUser();
    $usu_id = $datosUsuario['id'];
    $MontoActual = $this->MontoDisponible($usu_id);
    $datosUsuarioAct = $Usuarios -> find ($usu_id);   
    $usu_sexo =  $this-> ListaDesplegableSexo($datosUsuarioAct['usu_sexo'],'usu_sexo','usu_sexo','custom-select mr-sm-2');

    $request=\Config\Services::request();
    //RecogeFormPost();
    $datos =[
        'name' => $request->getPostGet('usu_nombre'),
        'usu_nombre' => $request->getPostGet('usu_nombre'),
        'apellido' => $request->getPostGet('usu_apellido'),
        'usu_apellido' => $request->getPostGet('usu_apellido'),        
        'usu_ban_id' => $request->getPostGet('usu_ban_id'),
        'usu_sexo' => $request->getPostGet('usu_sexo'),
        'usu_pais_id' => $request->getPostGet('usu_pais_id'),
        'usu_tlf1' => $request->getPostGet('usu_tlf1'),   
        'usu_twitter' => $request->getPostGet('usu_twitter')
    ];
    //print_r ($datos);
    /*
    $builder = $Usuarios -> builder ();
    $builder->replace($datos);
    $builder->where('usu_id', $usu_id);
    $builder->update(); // //Modifico el Perfil del Usuario
    */
    $UpdateUsuario = $Usuarios -> Update($usu_id,$datos); 

    // Inserto la Auditoria
    $dbSip = \Config\Database::connect('thSipacha', true);
    $Auditoria = new Auditoria($dbSip);      
    $au_descripcion ="Modifico el perfil de usuario";
    //echo $au_descripcion; 
    $datosAuditoria = [
        'au_fecha'=>date("Y") . "-" . date("m") . "-" . date("d"),
        'au_hora'=>strftime("%H:%M:%S"),
        'au_evento'=>"INSERT",
        'au_descripcion'=>$au_descripcion,
        'au_ip'=>ObtenerIP(),
        'usu_id'=>$usu_id,
        'au_usulogin'=>$datosUsuario['username'],
        'au_so'=>PHP_OS,
        'au_mostrar'=>1
        ];
    $InsertAudit= $Auditoria->insert($datosAuditoria);

    $Bancos = new Bancos($dbSip);  
    $builder = $Bancos -> builder (); 
    $Bancos = $builder->get(); 
    $usu_banco =  $this-> ListaDesplegable($Bancos,'usu_ban_id','usu_ban_id','custom-select mr-sm-2','ban_id','ban_nombre',$datosUsuarioAct['usu_ban_id']);

    $Pais = new Pais($dbSip);  
    $builder = $Pais -> builder ();    
    $Pais = $builder->get(); 
    $usu_pais =  $this-> ListaDesplegable($Pais,'usu_pais_id','usu_pais_id','custom-select mr-sm-2','pais_id','pais_nombre',$datosUsuarioAct['usu_pais_id']);
    $mensaje   = "Perfil Editado de manera exitosa";
    $claseMens = "alert alert-success";
    $titleMens = "Felicidades"; 
    $datos = array('mensaje'=>$mensaje,'titleMens'=>$titleMens,'claseMens'=>$claseMens,'MontoActual'=>$MontoActual,'UsuarioPerfil'=>$datosUsuarioAct,'usu_sexo'=>$usu_sexo,'usu_banco'=>$usu_banco,'usu_pais'=>$usu_pais);
    return view('estructura/perfil.php',$datos); 

}
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
}