<?php namespace App\Controllers;
//Conexiones
//Controlador Th
//Controladores
use CodeIgniter\Controller;
//Modelos
use App\Models\Auditoria;
use App\Models\AuditoriaBod;
use App\Models\AuditoriaAnim;
use App\Models\Usuarios;
use App\Models\Bancos;
use App\Models\Pais;
use App\Models\Configuracion;
//Librerias del Codeigneter4
$pager = \Config\Services::pager();

class SipachaVirtualMovimientosAdmin extends Th
{
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
public function AuditoriaTodosLosUsuarios(){
    //Verifico Sesion de Usuario
    if (!session()->get('isLogged')){
        $mensaje   = "Presione clic en su opcion de menu.";
        $claseMens = "alert alert-danger";
        $titleMens = "<strong>¡Error!</strong> </br>";   
        $datos = array('mensaje'=>$mensaje,'titleMens'=>$titleMens,'claseMens'=>$claseMens);		
        return view('estructura/ingresomalo.php',$datos);
    } 
    
    $datosUsuario= $this->SessionUser();
    $MenuIzquierdo = $this->MenuIzquierdo(); 

    $dbSipVirtual = \Config\Database::connect('thSipachaVirtual', true);

    $Usuarios = new Usuarios($dbSipVirtual);      
    $request=\Config\Services::request();


    $datos = array('datosUsuario'=>$datosUsuario,'MenuIzquierdo'=>$MenuIzquierdo);				
    return view('auditoriaadmin/auditoriagenerica',$datos);
    
}

//---------------------------------------------------------------------------------------------------------------------
public function ListarTodosLosUsuarios(){
    $dbSipVirtual = \Config\Database::connect('thSipachaVirtual', true);

    $Usuarios = new Usuarios($dbSipVirtual);      
    $request=\Config\Services::request();
    $ClasDiv   = "table-responsive table-hover";
    $ClasTabla = "table table-bordered table-striped";  
    $idDiv     = "";  
    $TitCol    = array('Id','Usuario','Disponible','Propio','Estatus');
    $CampCol   = array('1'=>'id','2'=>'username','3'=>'usu_montodisp','4'=>'usu_propio','5'=>'block');
    $AnchoCol  = array('1'=>'20','2'=>'10','3'=>'10','4'=>'10','5'=>'10');

    $criterio = $request->getPostGet('txtbusca');
    $ordenCampo = $request->getPostGet('ordenCampo');
    $ordencriterio = $request->getPostGet('ordencriterio');

    if ($criterio !="undefined"){
        $builderUsuarios = $Usuarios -> builder ();
        $builderUsuarios->like('username', $criterio, 'both');
        echo "Buscando Usuarios con: ".$criterio ;
        if (! empty($ordenCampo)){   
            $builderUsuarios->orderBy($ordenCampo,$ordencriterio);            
        }               
    } 
    else
    {
        $builderUsuarios = $Usuarios -> builder ();
        if (! empty($ordenCampo)){ 
            $builderUsuarios->orderBy($ordenCampo,$ordencriterio); 
        }else {
            $builderUsuarios->orderBy('id','ASC'); 
        }
        echo "Sin criterio de busqueda";       
    } 
    $datosUsuarios = $builderUsuarios->get();
    $TotalReg = $builderUsuarios->resultID->num_rows;
    //echo $TotalReg ;
    
    $element = "   
    <div class='".$ClasDiv."' id='".$idDiv."'>
    <table class='".$ClasTabla."'> 
    <thead class='thead-dark'>
    <tr>
    <td colspan=1 align=left><a href='' onclick='window.print();' class='btn btn-info' role='button'><i class='fas fa-vote-yea'></i></a></td>
    <td colspan=4 align=right><b>Total Registros:</b>".$TotalReg."</td></tr> 
    <tr> ";
    
    $i=1;
    foreach ($TitCol as $col) {  
        if ($i!=1){
        $element .= "
        <th width='".$AnchoCol[$i]."'>
        <i class='fas fa-arrow-alt-circle-up'   onclick=ordenar('".$CampCol[$i]."','ASC')></i>
        <i class='fas fa-arrow-alt-circle-down' onclick=ordenar('".$CampCol[$i]."','DESC')></i>   "
        .$col."</th> ";
        } else {
            $element .= " <th width='".$AnchoCol[$i]."' align='center'>
            <i class='fas fa-arrow-alt-circle-up'   onclick=ordenar('".$CampCol[$i]."','ASC')></i>
            <i class='fas fa-arrow-alt-circle-down' onclick=ordenar('".$CampCol[$i]."','DESC')></i> 
            "
            .$col."</th> ";                
        } 
        $i=$i+1; 
    }
     
    $element .= "
    </tr>
    </thead>
    <tr>";
    foreach ($datosUsuarios->getResultArray() as $row_item){
        //$element .= " <td><form action= '".BaseUrl()."SipachaVirtualMovimientosAdmin/AuditoriaDetBod' method='POST'><input type='hidden' name='auditoria' value='bod'><input type='hidden' name='usu_id' value='".$row_item['id']."'> <input type='submit' value='Ver'><i class='fas fa-search-plus'></i> </form><small>".$row_item['id']."</small></td>";      
        //$element .= " <td><form action= '".BaseUrl()."SipachaVirtualMovimientosAdmin/AuditoriaDetBod' method='POST'><input type='hidden' name='auditoria' value='bod'><input type='hidden' name='usu_id' value='".$row_item['id']."'> <input type='submit' value='+'></form></td>";      
        $element .= " <td>
        <a href='".BaseUrl()."SipachaVirtualMovimientosAdmin/AuditoriaDetBod?auditoria=bod&usu_id=".$row_item['id']."'<i class='fas fa-briefcase'></i> </a>
        <a href='".BaseUrl()."SipachaVirtualMovimientosAdmin/AuditoriaDetCarr?auditoria=cab&usu_id=".$row_item['id']."'<i class='fas fa-horse-head'></i> </a>
        <a href='".BaseUrl()."SipachaVirtualMovimientosAdmin/AuditoriaDetAni?auditoria=ani&usu_id=".$row_item['id']."'<i class='fas fa-cat'></i> </a>
        </td>";      
        $element .= " <td>".$row_item['username']."</td>";  
        $element .= " <td>".number_format($row_item['usu_montodisp'], 2,',', '.')."</td>";          

        if ($row_item['usu_propio']==1){
            $element .= " <td>SI</td>";     
        }else {
            $element .= " <td>NO</td>";     
        }    
        if ($row_item['block']==1){
            $element .= " <td>SI</td>";     
        }else{
            $element .= " <td>NO</td>";     
        }            
        //$element .= " <td>".$row_item['block']."</td>";     
        //$element .= " <td>".$row_item['usu_propio']."</td>";   
        
        $element .= "</tr>";  
    }    
    $element .="</table>";
    echo $element;
}      
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
public function AuditoriaDetCarr(){
    //Verifico Sesion de Usuario
    if (!session()->get('isLogged')){
        $mensaje   = "Presione clic en su opcion de menu.";
        $claseMens = "alert alert-danger";
        $titleMens = "<strong>¡Error!</strong> </br>";   
        $datos = array('mensaje'=>$mensaje,'titleMens'=>$titleMens,'claseMens'=>$claseMens);		
        return view('estructura/ingresomalo.php',$datos);
    }     
    //Creo Sesion de Usuario
    //------------------------------------------------------------------------------------------------    
    $request=\Config\Services::request();
    $auditoria = $request->getPostGet('auditoria');
    $usu_id = $request->getPostGet('usu_id');
    $dbSipVirtual = \Config\Database::connect('thSipachaVirtual', true);
    $Usuarios = new Usuarios($dbSipVirtual);     
    $datosUsuario =  $Usuarios -> find($usu_id);
    //------------------------------------------------------------------------------------------------    
    $MontoActual = $this->MontoDisponible($usu_id);
    $MenuIzquierdo = $this->MenuIzquierdo(); 

    
    $datos = array('MontoActual'=> $MontoActual,'datosUsuario'=>$datosUsuario,'MenuIzquierdo'=>$MenuIzquierdo);				
    return view('auditoriaadmin/auditoriadetcarr',$datos);
    
}



//---------------------------------------------------------------------------------------------------------------------
public function RepAuditoriaCarreras(){
 
    $dbSip     = \Config\Database::connect('thSipacha',true);
    $Auditoria = new Auditoria($dbSip);       
    $request=\Config\Services::request();
    $ClasDiv   = "table-responsive table-hover";
    $ClasTabla = "table table-bordered table-striped";  
    $idDiv     = "";      
    $TitCol    = array('Fecha','Hora','Auditoria','IP','SO');
    $CampCol   = array('1'=>'au_fecha','2'=>'au_hora','3'=>'au_descripcion','4'=>'au_ip','5'=>'au_so');
    $AnchoCol  = array('1'=>'5','2'=>'15','3'=>'20','4'=>'20','5'=>'20');

    $usu_id = $request->getPostGet('usu_id');
    $criterio = $request->getPostGet('txtbusca');
    $ordenCampo = $request->getPostGet('ordenCampo');
    $ordencriterio = $request->getPostGet('ordencriterio');

    if ($criterio !="undefined"){
        $builderAuditoria = $Auditoria -> builder ();
        $builderAuditoria->where('usu_id', $usu_id);
        $builderAuditoria->like('au_descripcion', $criterio, 'both');
        $builderAuditoria->orlike('au_fecha', $criterio, 'both');        
   
        echo "Buscando Auditoria en Centro Hipico con: ".$criterio ;
        if (! empty($ordenCampo)){   
            $builderAuditoria->where('usu_id', $usu_id);
            $builderAuditoria->orderBy($ordenCampo,$ordencriterio);            
        } else {
            $builderAuditoria->where('usu_id', $usu_id);
            $builderAuditoria->orderBy('au_id','DESC'); 
        }              
    } 
    else
    {
        $builderAuditoria = $Auditoria -> builder ();
        $builderAuditoria->where('usu_id', $usu_id);
        if (! empty($ordenCampo)){ 
            $builderAuditoria->orderBy($ordenCampo,$ordencriterio); 
        }else {
            $builderAuditoria->orderBy('au_id','DESC'); 
        }
        echo "Sin criterio de busqueda";       
    } 
    $datosAuditoria = $builderAuditoria->get();
    $TotalReg = $builderAuditoria->resultID->num_rows;
   
    $element = "   
    <div class='".$ClasDiv."' id='".$idDiv."'>
    <table class='".$ClasTabla."'> 
    <thead class='thead-dark'>
    <tr>
    <td colspan=1 align=left><a href='' onclick='window.print();' class='btn btn-info' role='button'><i class='fas fa-vote-yea'></i></a></td>
    <td colspan=4 align=right><b>Total Registros:</b>".$TotalReg."</td></tr> 
    <tr> ";
    $i=1;
    foreach ($TitCol as $col) {  
            $element .= " <th width='".$AnchoCol[$i]."' align='center'>
            <i class='fas fa-arrow-alt-circle-up'   onclick=ordenar('".$CampCol[$i]."','ASC')></i>
            <i class='fas fa-arrow-alt-circle-down' onclick=ordenar('".$CampCol[$i]."','DESC')></i> 
            "
            .$col."</th> ";                
            $i=$i+1;
    }
    $element .= "
    </tr>
    </thead>
    <tr>";
    foreach ($datosAuditoria->getResultArray() as $row_item){
        $element.="<td>".cambiarfecha($row_item['au_fecha'])."</td>";
        $element.="<td>".date("g:i a",strtotime($row_item['au_hora']))."</td>";
        $element.="<td>".$row_item['au_descripcion']."</td>";
        $element.="<td>".$row_item['au_ip']."</td>";
        $element.="<td>".$row_item['au_so']."</td>";
        $element.="</tr><tr>";
    }    
    $element .="</tr></table>";   
    echo $element;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

public function AuditoriaDetAni(){
    //Verifico Sesion de Usuario
    if (!session()->get('isLogged')){
        $mensaje   = "Presione clic en su opcion de menu.";
        $claseMens = "alert alert-danger";
        $titleMens = "<strong>¡Error!</strong> </br>";   
        $datos = array('mensaje'=>$mensaje,'titleMens'=>$titleMens,'claseMens'=>$claseMens);		
        return view('estructura/ingresomalo.php',$datos);
    }     
    //Creo Sesion de Usuario
    //------------------------------------------------------------------------------------------------    
    $request=\Config\Services::request();
    $auditoria = $request->getPostGet('auditoria');
    $usu_id = $request->getPostGet('usu_id');
    $dbSipVirtual = \Config\Database::connect('thSipachaVirtual', true);
    $Usuarios = new Usuarios($dbSipVirtual);     
    $datosUsuario =  $Usuarios -> find($usu_id);
    //------------------------------------------------------------------------------------------------    
    $MontoActual = $this->MontoDisponible($usu_id);
    $MenuIzquierdo = $this->MenuIzquierdo(); 
    //$ListadoAuditoria = $this->ReporteAuditoriaBodegon($usu_id,$auditoria); 
    $MenuIzquierdo[18]=" menu-open active";
    $MenuIzquierdo[19]="active"; 
    $MenuIzquierdo[20]="active"; 
    $dbSipVirtual = \Config\Database::connect('thSipachaVirtual', true);

    $MontoActual = $this->MontoDisponible($usu_id);   
    $datos = array('MontoActual'=> $MontoActual,'datosUsuario'=>$datosUsuario,'datosUsuario'=>$datosUsuario,'MenuIzquierdo'=>$MenuIzquierdo);				
    return view('auditoriaadmin/auditoriadetani',$datos);
    
}



//---------------------------------------------------------------------------------------------------------------------

//---------------------------------------------------------------------------------------------------------------------
public function RepAuditoriaAnimalitos(){
    //$Auditoria = new Auditoria($dbBod);          

    $request=\Config\Services::request();
    $ClasDiv   = "table-responsive table-hover";
    $ClasTabla = "table table-bordered table-striped";  
    $idDiv     = "";      
    $TitCol    = array('Fecha','Hora','Auditoria','IP','SO');
    $CampCol   = array('1'=>'au_fecha','2'=>'au_hora','3'=>'au_descripcion','4'=>'au_ip','5'=>'au_so');
    $AnchoCol  = array('1'=>'5','2'=>'15','3'=>'20','4'=>'20','5'=>'20');

    $usu_id = $request->getPostGet('usu_id');
    $criterio = $request->getPostGet('txtbusca');
    $ordenCampo = $request->getPostGet('ordenCampo');
    $ordencriterio = $request->getPostGet('ordencriterio');

    
    $dbSip     = \Config\Database::connect('thSipacha',true);
    $Auditoria = new AuditoriaAnim($dbSip);   

    if ($criterio !="undefined"){
        $builderAuditoria = $Auditoria -> builder ();
        $builderAuditoria->where('usu_id', $usu_id);
        $builderAuditoria->like('au_descripcion', $criterio, 'both');
        $builderAuditoria->orlike('au_fecha', $criterio, 'both');
        

        echo "Buscando Auditoria en animalitos con: ".$criterio ;
        if (! empty($ordenCampo)){   
            $builderAuditoria->where('usu_id', $usu_id);
            $builderAuditoria->orderBy($ordenCampo,$ordencriterio);            
        } else {
            $builderAuditoria->where('usu_id', $usu_id);
            $builderAuditoria->orderBy('au_id', 'DESC');            
        }        
    } 
    else
    {
        $builderAuditoria = $Auditoria -> builder ();
        $builderAuditoria->where('usu_id', $usu_id);
        if (! empty($ordenCampo)){ 
            $builderAuditoria->orderBy($ordenCampo,$ordencriterio); 
        }else {
            $builderAuditoria->orderBy('au_id','DESC'); 
        }
        echo "Sin criterio de busqueda";       
    } 

    $datosAuditoria = $builderAuditoria->get();
    $TotalReg = $builderAuditoria->resultID->num_rows;
   
    $element = "   
    <div class='".$ClasDiv."' id='".$idDiv."'>
    <table class='".$ClasTabla."'> 
    <thead class='thead-dark'>
    <tr>
    <td colspan=1 align=left><a href='' onclick='window.print();' class='btn btn-info' role='button'><i class='fas fa-vote-yea'></i></a></td>
    <td colspan=4 align=right><b>Total Registros:</b>".$TotalReg."</td></tr> 
    <tr> ";
    $i=1;
    foreach ($TitCol as $col) {  
            $element .= " <th width='".$AnchoCol[$i]."' align='center'>
            <i class='fas fa-arrow-alt-circle-up'   onclick=ordenar('".$CampCol[$i]."','ASC')></i>
            <i class='fas fa-arrow-alt-circle-down' onclick=ordenar('".$CampCol[$i]."','DESC')></i> 
            "
            .$col."</th> ";                
            $i=$i+1;
    }
    $element .= "
    </tr>
    </thead>
    <tr>";

    
    foreach ($datosAuditoria->getResultArray() as $row_item){
        $element.="<td>".cambiarfecha($row_item['au_fecha'])."</td>";  
        $element.="<td>".date("g:i a",strtotime($row_item['au_hora']))."</td>";
        $element.="<td>".$row_item['au_descripcion']."</td>";
        $element.="<td>".$row_item['au_ip']."</td>";
        $element.="<td>".$row_item['au_so']."</td>";
        $element.="</tr><tr>";
    }    
    $element .="</tr></table>";   
    echo $element;
}
//---------------------------------------------------------------------------------------------------------------------
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

public function AuditoriaDetBod(){
    //Verifico Sesion de Usuario
    if (!session()->get('isLogged')){
        $mensaje   = "Presione clic en su opcion de menu.";
        $claseMens = "alert alert-danger";
        $titleMens = "<strong>¡Error!</strong> </br>";   
        $datos = array('mensaje'=>$mensaje,'titleMens'=>$titleMens,'claseMens'=>$claseMens);		
        return view('estructura/ingresomalo.php',$datos);
    }     
    //Creo Sesion de Usuario
    //------------------------------------------------------------------------------------------------    
    $request=\Config\Services::request();
    $auditoria = $request->getPostGet('auditoria');
    $usu_id = $request->getPostGet('usu_id');
    $dbSipVirtual = \Config\Database::connect('thSipachaVirtual', true);
    $Usuarios = new Usuarios($dbSipVirtual);     
    $datosUsuario =  $Usuarios -> find($usu_id);
    //------------------------------------------------------------------------------------------------    
    $MontoActual = $this->MontoDisponible($usu_id);
    $MenuIzquierdo = $this->MenuIzquierdo();  
    $datos = array('MontoActual'=> $MontoActual,'datosUsuario'=>$datosUsuario,'datosUsuario'=>$datosUsuario,'MenuIzquierdo'=>$MenuIzquierdo);				
    return view('auditoriaadmin/auditoriadetbod',$datos);
    
}



//---------------------------------------------------------------------------------------------------------------------
public function RepAuditoriaBodegon(){
    $Auditoria = new AuditoriaBod($dbBod);      
    $request=\Config\Services::request();
    $ClasDiv   = "table-responsive table-hover";
    $ClasTabla = "table table-bordered table-striped";  
    $idDiv     = "";      
    $TitCol    = array('Fecha','Hora','Auditoria','IP','SO');
    $CampCol   = array('1'=>'au_fecha','2'=>'au_hora','3'=>'au_descripcion','4'=>'au_ip','5'=>'au_so');
    $AnchoCol  = array('1'=>'5','2'=>'15','3'=>'20','4'=>'20','5'=>'20');

    $usu_id = $request->getPostGet('usu_id');
    $criterio = $request->getPostGet('txtbusca');
    $ordenCampo = $request->getPostGet('ordenCampo');
    $ordencriterio = $request->getPostGet('ordencriterio');

    if ($criterio !="undefined"){
        $builderAuditoria = $Auditoria -> builder ();
        $builderAuditoria->where('au_usu_id', $usu_id);
        $builderAuditoria->like('au_descripcion', $criterio, 'both');
        $builderAuditoria->orlike('au_fecha', $criterio, 'both');        
        echo "Buscando Compras con: ".$criterio ;
        if (! empty($ordenCampo)){   

            $builderAuditoria->orderBy($ordenCampo,$ordencriterio);            
        } else{

            $builderAuditoria->orderBy('au_id','DESC'); 
        }              
    } 
    else
    {
        $builderAuditoria = $Auditoria -> builder ();
        $builderAuditoria->where('au_usu_id', $usu_id);
        if (! empty($ordenCampo)){ 
            $builderAuditoria->orderBy($ordenCampo,$ordencriterio); 
        }else {
            $builderAuditoria->orderBy('au_id','DESC'); 
        }
        echo "Sin criterio de busqueda";       
    } //ListaDesplegableEstatus
    $datosAuditoria = $builderAuditoria->get();
    $TotalReg = $builderAuditoria->resultID->num_rows;
   
    $element = "   
    <div class='".$ClasDiv."' id='".$idDiv."'>
    <table class='".$ClasTabla."'> 
    <thead class='thead-dark'>
    <tr>
    <td colspan=1 align=left><a href='' onclick='window.print();' class='btn btn-info' role='button'><i class='fas fa-vote-yea'></i></a></td>
    <td colspan=4 align=right><b>Total Registros:</b>".$TotalReg."</td></tr> 
    <tr> ";
    $i=1;
    foreach ($TitCol as $col) {  
            $element .= " <th width='".$AnchoCol[$i]."' align='center'>
            <i class='fas fa-arrow-alt-circle-up'   onclick=ordenar('".$CampCol[$i]."','ASC')></i>
            <i class='fas fa-arrow-alt-circle-down' onclick=ordenar('".$CampCol[$i]."','DESC')></i> 
            "
            .$col."</th> ";                
            $i=$i+1;
    }
    $element .= "
    </tr>
    </thead>
    <tr>";
    foreach ($datosAuditoria->getResultArray() as $row_item){
        $element.="<td>".cambiarfecha($row_item['au_fecha'])."</td>";
        $element.="<td>".date("g:i a",strtotime($row_item['au_hora']))."</td>";
        $element.="<td>".$row_item['au_descripcion']."</td>";
        $element.="<td>".$row_item['au_ip']."</td>";
        $element.="<td>".$row_item['au_so']."</td>";
        $element.="</tr><tr>";
    }    
    $element .="</tr></table>";   
    echo $element;
}

//---------------------------------------------------------------------------------------------------------------------


}
