<?php namespace App\Controllers;
//Conexiones
//Controlador Th
//Controladores
use CodeIgniter\Controller;
//Modelos
use App\Models\Auditoria;
use App\Models\AuditoriaBod;
use App\Models\AuditoriaAnim;
use App\Models\Usuarios;
use App\Models\Bancos;
use App\Models\Pais;
use App\Models\Configuracion;
//Librerias del Codeigneter4
$pager = \Config\Services::pager();
class SipachaVirtualMisMovimientos extends Th
{

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
public function AuditoriaDetCarr(){
    //Creo Sesion de Usuario
    //------------------------------------------------------------------------------------------------    
    $request=\Config\Services::request();
    $auditoria = $request->getPostGet('auditoria');
    $usu_id = $request->getPostGet('usu_id');
    $dbSipVirtual = \Config\Database::connect('thSipachaVirtual', true);
    $Usuarios = new Usuarios($dbSipVirtual);   
    $builder = $Usuarios -> builder ();
    $builder->where('id', $usu_id); 
    $datosUsuario = $builder->get(); 
    $row_item = $datosUsuario -> getRow ();   
    if (isset( $row_item )){  
        $datosUsuario = [
            'id'        => $row_item -> id,
            'nombre'    => $row_item -> name,
            'apellido'  => $row_item -> apellido,
            'username'  => $row_item -> username,
            'usu_sexo'  => $row_item -> usu_sexo,
            'usu_rol_id'=> $row_item -> usu_rol_id,                
            'email'     => $row_item -> email,
            'isLogged'  => true
        ];
        session()->set($datosUsuario);  
    }
    else{
        session()->destroy();
    }
    //Verifico Sesion de Usuario
    if (!session()->get('isLogged')){
        $mensaje   = "Presione clic en su opcion de menu.";
        $claseMens = "alert alert-danger";
        $titleMens = "<strong>¡Error!</strong> </br>";   
        $datos = array('mensaje'=>$mensaje,'titleMens'=>$titleMens,'claseMens'=>$claseMens);		
        return view('estructura/ingresomalo.php',$datos);
    } 
    //------------------------------------------------------------------------------------------------    

    $datosUsuario= $this->SessionUser();
    $usu_id = $datosUsuario['id'];
    $MontoActual = $this->MontoDisponible($usu_id);
    $MenuIzquierdo = $this->MenuIzquierdo(); 

    
    $datos = array('MontoActual'=> $MontoActual,'datosUsuario'=>$datosUsuario,'MenuIzquierdo'=>$MenuIzquierdo);				
    return view('auditoria/auditoriadetcarr',$datos);
    
}



//---------------------------------------------------------------------------------------------------------------------
public function RepAuditoriaCarreras(){
 
    $dbSip     = \Config\Database::connect('thSipacha',true);
    $Auditoria = new Auditoria($dbSip);       
    $request=\Config\Services::request();
    $ClasDiv   = "table-responsive table-hover";
    $ClasTabla = "table table-bordered table-striped";  
    $idDiv     = "";      
    $TitCol    = array('Fecha','Hora','Auditoria');
    $CampCol   = array('1'=>'au_fecha','2'=>'au_hora','3'=>'au_descripcion');
    $AnchoCol  = array('1'=>'20','2'=>'20','3'=>'60');

    $usu_id = $request->getPostGet('usu_id');
    $criterio = $request->getPostGet('txtbusca');
    $ordenCampo = $request->getPostGet('ordenCampo');
    $ordencriterio = $request->getPostGet('ordencriterio');

    if ($criterio !="undefined"){
        $builderAuditoria = $Auditoria -> builder ();
        $builderAuditoria->where('usu_id', $usu_id);
        $builderAuditoria->like('au_descripcion', $criterio, 'both');
        $builderAuditoria->orlike('au_fecha', $criterio, 'both');        
   
        echo "Buscando Auditoria en Centro Hipico con: ".$criterio ;
        if (! empty($ordenCampo)){   
            $builderAuditoria->where('usu_id', $usu_id);
            $builderAuditoria->orderBy($ordenCampo,$ordencriterio);            
        } else {
            $builderAuditoria->where('usu_id', $usu_id);
            $builderAuditoria->orderBy('au_id','DESC'); 
        }              
    } 
    else
    {
        $builderAuditoria = $Auditoria -> builder ();
        $builderAuditoria->where('usu_id', $usu_id);
        if (! empty($ordenCampo)){ 
            $builderAuditoria->orderBy($ordenCampo,$ordencriterio); 
        }else {
            $builderAuditoria->orderBy('au_id','DESC'); 
        }
        echo "Sin criterio de busqueda";       
    } 
    $datosAuditoria = $builderAuditoria->get();
    $TotalReg = $builderAuditoria->resultID->num_rows;
   
    $element = "   
    <div class='".$ClasDiv."' id='".$idDiv."'>
    <table class='".$ClasTabla."'> 
    <thead class='thead-dark'>
    <tr>
    <td colspan=1 align=left><a href='' onclick='window.print();' class='btn btn-info' role='button'><i class='fas fa-vote-yea'></i></a></td>
    <td colspan=4 align=right><b>Total Registros:</b>".$TotalReg."</td></tr> 
    <tr> ";
    $i=1;
    foreach ($TitCol as $col) {  
            $element .= " <th width='".$AnchoCol[$i]."' align='center'>
            <i class='fas fa-arrow-alt-circle-up'   onclick=ordenar('".$CampCol[$i]."','ASC')></i>
            <i class='fas fa-arrow-alt-circle-down' onclick=ordenar('".$CampCol[$i]."','DESC')></i> 
            "
            .$col."</th> ";                
            $i=$i+1;
    }
    $element .= "
    </tr>
    </thead>
    <tr>";
    foreach ($datosAuditoria->getResultArray() as $row_item){
        $element.="<td>".cambiarfecha($row_item['au_fecha'])."</td>";
        $element.="<td>".date("g:i a",strtotime($row_item['au_hora']))."</td>";
        $element.="<td>".$row_item['au_descripcion']."</td>";
        //$element.="<td>".$row_item['au_ip']."</td>";
        //$element.="<td>".$row_item['au_so']."</td>";
        $element.="</tr><tr>";
    }    
    $element .="</tr></table>";   
    echo $element;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

public function AuditoriaDetAni(){
    //Verifico Sesion de Usuario
    if (!session()->get('isLogged')){
        $mensaje   = "Presione clic en su opcion de menu.";
        $claseMens = "alert alert-danger";
        $titleMens = "<strong>¡Error!</strong> </br>";   
        $datos = array('mensaje'=>$mensaje,'titleMens'=>$titleMens,'claseMens'=>$claseMens);		
        return view('estructura/ingresomalo.php',$datos);
    } 
    else{
    $session    = session();
    $username   = session()->get('username');
    $request=\Config\Services::request();

    $auditoria = $request->getPostGet('auditoria');
    $usu_id = $request->getPostGet('usu_id');

    $datosUsuario= $this->SessionUser();
    //$datosTotales= $this->DatosListados();
    $MenuIzquierdo = $this->MenuIzquierdo(); 
    //$ListadoAuditoria = $this->ReporteAuditoriaBodegon($usu_id,$auditoria); 
    $MenuIzquierdo[18]=" menu-open active";
    $MenuIzquierdo[19]="active"; 
    $MenuIzquierdo[20]="active"; 

    $dbSipVirtual = \Config\Database::connect('thSipachaVirtual', true);

    $Usuarios = new Usuarios($dbSipVirtual);      
    $request=\Config\Services::request();

    $datosUsuAuditado      = $Usuarios->find($usu_id);
    $MontoActual = $this->MontoDisponible($usu_id);   
    $datos = array('MontoActual'=> $MontoActual,'datosUsuario'=>$datosUsuario,'datosUsuario'=>$datosUsuario,'MenuIzquierdo'=>$MenuIzquierdo);				
    return view('auditoria/auditoriadetani',$datos);
    }
}



//---------------------------------------------------------------------------------------------------------------------
public function RepAuditoriaAnimalitos(){
    //$Auditoria = new Auditoria($dbBod);          

    $request=\Config\Services::request();
    $ClasDiv   = "table-responsive table-hover";
    $ClasTabla = "table table-bordered table-striped";  
    $idDiv     = "";      
    $TitCol    = array('Fecha','Hora','Auditoria');
    $CampCol   = array('1'=>'au_fecha','2'=>'au_hora','3'=>'au_descripcion');
    $AnchoCol  = array('1'=>'20','2'=>'20','3'=>'60');

    $usu_id = $request->getPostGet('usu_id');
    $criterio = $request->getPostGet('txtbusca');
    $ordenCampo = $request->getPostGet('ordenCampo');
    $ordencriterio = $request->getPostGet('ordencriterio');

    
    $dbSip     = \Config\Database::connect('thSipacha',true);
    $Auditoria = new AuditoriaAnim($dbSip);   

    if ($criterio !="undefined"){
        $builderAuditoria = $Auditoria -> builder ();
        $builderAuditoria->where('usu_id', $usu_id);
        $builderAuditoria->like('au_descripcion', $criterio, 'both');
        $builderAuditoria->orlike('au_fecha', $criterio, 'both');
        

        echo "Buscando Auditoria en animalitos con: ".$criterio ;
        if (! empty($ordenCampo)){   
            $builderAuditoria->where('usu_id', $usu_id);
            $builderAuditoria->orderBy($ordenCampo,$ordencriterio);            
        } else {
            $builderAuditoria->where('usu_id', $usu_id);
            $builderAuditoria->orderBy('au_id', 'DESC');            
        }        
    } 
    else
    {
        $builderAuditoria = $Auditoria -> builder ();
        $builderAuditoria->where('usu_id', $usu_id);
        if (! empty($ordenCampo)){ 
            $builderAuditoria->orderBy($ordenCampo,$ordencriterio); 
        }else {
            $builderAuditoria->orderBy('au_id','DESC'); 
        }
        echo "Sin criterio de busqueda";       
    } 

    $datosAuditoria = $builderAuditoria->get();
    $TotalReg = $builderAuditoria->resultID->num_rows;
   
    $element = "   
    <div class='".$ClasDiv."' id='".$idDiv."'>
    <table class='".$ClasTabla."'> 
    <thead class='thead-dark'>
    <tr>
    <td colspan=1 align=left><a href='' onclick='window.print();' class='btn btn-info' role='button'><i class='fas fa-vote-yea'></i></a></td>
    <td colspan=4 align=right><b>Total Registros:</b>".$TotalReg."</td></tr> 
    <tr> ";
    $i=1;
    foreach ($TitCol as $col) {  
            $element .= " <th width='".$AnchoCol[$i]."' align='center'>
            <i class='fas fa-arrow-alt-circle-up'   onclick=ordenar('".$CampCol[$i]."','ASC')></i>
            <i class='fas fa-arrow-alt-circle-down' onclick=ordenar('".$CampCol[$i]."','DESC')></i> 
            "
            .$col."</th> ";                
            $i=$i+1;
    }
    $element .= "
    </tr>
    </thead>
    <tr>";

    
    foreach ($datosAuditoria->getResultArray() as $row_item){
        $element.="<td>".cambiarfecha($row_item['au_fecha'])."</td>";  
        $element.="<td>".date("g:i a",strtotime($row_item['au_hora']))."</td>";
        $element.="<td>".$row_item['au_descripcion']."</td>";
        //$element.="<td>".$row_item['au_ip']."</td>";
        //$element.="<td>".$row_item['au_so']."</td>";
        $element.="</tr><tr>";
    }    
    $element .="</tr></table>";   
    echo $element;
}

//---------------------------------------------------------------------------------------------------------------------
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

public function AuditoriaDetBod(){
    //Verifico Sesion de Usuario
    if (!session()->get('isLogged')){
        $mensaje   = "Presione clic en su opcion de menu.";
        $claseMens = "alert alert-danger";
        $titleMens = "<strong>¡Error!</strong> </br>";   
        $datos = array('mensaje'=>$mensaje,'titleMens'=>$titleMens,'claseMens'=>$claseMens);		
        return view('estructura/ingresomalo.php',$datos);
    } 
    else{
    $session    = session();
    $username   = session()->get('username');
    $request=\Config\Services::request();

    $auditoria = $request->getPostGet('auditoria');
    $usu_id = $request->getPostGet('usu_id');

    $datosUsuario= $this->SessionUser();
    //$datosTotales= $this->DatosListados();
    $MenuIzquierdo = $this->MenuIzquierdo(); 
    //$ListadoAuditoria = $this->ReporteAuditoriaBodegon($usu_id,$auditoria); 
    $MenuIzquierdo[18]=" menu-open active";
    $MenuIzquierdo[19]="active"; 
    $MenuIzquierdo[20]="active"; 

    $dbSipVirtual = \Config\Database::connect('thSipachaVirtual', true);

    $Usuarios = new Usuarios($dbSipVirtual);      
    $request=\Config\Services::request();

    $datosUsuAuditado      = $Usuarios->find($usu_id);
    $MontoActual = $this->MontoDisponible($usu_id);   
    $datos = array('MontoActual'=> $MontoActual,'datosUsuario'=>$datosUsuario,'datosUsuario'=>$datosUsuario,'MenuIzquierdo'=>$MenuIzquierdo);				
    return view('auditoria/auditoriadetbod',$datos);
    }
}



//---------------------------------------------------------------------------------------------------------------------
public function RepAuditoriaBodegon(){
    $Auditoria = new AuditoriaBod($dbBod);      
    $request=\Config\Services::request();
    $ClasDiv   = "table-responsive table-hover";
    $ClasTabla = "table table-bordered table-striped";  
    $idDiv     = "";      
    $TitCol    = array('Fecha','Hora','Auditoria');
    $CampCol   = array('1'=>'au_fecha','2'=>'au_hora','3'=>'au_descripcion');
    $AnchoCol  = array('1'=>'20','2'=>'20','3'=>'60');

    $usu_id = $request->getPostGet('usu_id');
    $criterio = $request->getPostGet('txtbusca');
    $ordenCampo = $request->getPostGet('ordenCampo');
    $ordencriterio = $request->getPostGet('ordencriterio');

    if ($criterio !="undefined"){
        $builderAuditoria = $Auditoria -> builder ();
        $builderAuditoria->where('au_usu_id', $usu_id);
        $builderAuditoria->like('au_descripcion', $criterio, 'both');
        $builderAuditoria->orlike('au_fecha', $criterio, 'both');        
        echo "Buscando Compras con: ".$criterio ;
        if (! empty($ordenCampo)){   

            $builderAuditoria->orderBy($ordenCampo,$ordencriterio);            
        } else{

            $builderAuditoria->orderBy('au_id','DESC'); 
        }              
    } 
    else
    {
        $builderAuditoria = $Auditoria -> builder ();
        $builderAuditoria->where('au_usu_id', $usu_id);
        if (! empty($ordenCampo)){ 
            $builderAuditoria->orderBy($ordenCampo,$ordencriterio); 
        }else {
            $builderAuditoria->orderBy('au_id','DESC'); 
        }
        echo "Sin criterio de busqueda";       
    } //ListaDesplegableEstatus
    $datosAuditoria = $builderAuditoria->get();
    $TotalReg = $builderAuditoria->resultID->num_rows;
   
    $element = "   
    <div class='".$ClasDiv."' id='".$idDiv."'>
    <table class='".$ClasTabla."'> 
    <thead class='thead-dark'>
    <tr>
    <td colspan=1 align=left><a href='' onclick='window.print();' class='btn btn-info' role='button'><i class='fas fa-vote-yea'></i></a></td>
    <td colspan=4 align=right><b>Total Registros:</b>".$TotalReg."</td></tr> 
    <tr> ";
    $i=1;
    foreach ($TitCol as $col) {  
            $element .= " <th width='".$AnchoCol[$i]."' align='center'>
            <i class='fas fa-arrow-alt-circle-up'   onclick=ordenar('".$CampCol[$i]."','ASC')></i>
            <i class='fas fa-arrow-alt-circle-down' onclick=ordenar('".$CampCol[$i]."','DESC')></i> 
            "
            .$col."</th> ";                
            $i=$i+1;
    }
    $element .= "
    </tr>
    </thead>
    <tr>";
    foreach ($datosAuditoria->getResultArray() as $row_item){
        $element.="<td>".cambiarfecha($row_item['au_fecha'])."</td>";
        $element.="<td>".date("g:i a",strtotime($row_item['au_hora']))."</td>";
        $element.="<td>".$row_item['au_descripcion']."</td>";
        //$element.="<td>".$row_item['au_ip']."</td>";
        //$element.="<td>".$row_item['au_so']."</td>";
        $element.="</tr><tr>";
    }    
    $element .="</tr></table>";   
    echo $element;
}

//---------------------------------------------------------------------------------------------------------------------


}
