<?php namespace App\Controllers;
//Conexiones
use Config\Database;
$dbSip  = \Config\Database::connect('thSipacha', true);

//Controladores
use CodeIgniter\Controller;
//Modelos
use App\Models\Auditoria;
use App\Models\Usuarios;
use App\Models\Bancos;
use App\Models\Depositos;
use App\Models\Configuracion;
//Librerias del Codeigneter4
$pager = \Config\Services::pager();

class SipachaVirtualDepositos extends Th
{
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    public function ListaDesplegable($datos,$nameSelec,$nameid,$class,$id,$name,$compara){
        $element = '<select name="'.$nameSelec.'" id="'.$nameid.'" class="'.$class.'">';
        foreach ($datos->getResultArray() as $dato)
        {
        if ($dato[$id]==$compara){
            $element .= '<option value="'.$dato[$id].'" selected>'.$dato[$name].'</option>';
        }else{
            $element .= '<option value="'.$dato[$id].'">'.$dato[$name].'</option>';
        }
        }
        $element .= '</select>';
        return $element;
   }
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
public function FormEnviarDeposito($mensaje,$claseMens, $titleMens){

    //Verifico Sesion de Usuario
    $session = session();
    if (!session()->get('isLogged')){
        $mensaje   = "Presione clic en su opcion de menu.";
        $claseMens = "alert alert-danger";
        $titleMens = "<strong>¡Error!</strong> </br>";   
        $datos = array('mensaje'=>$mensaje,'titleMens'=>$titleMens,'claseMens'=>$claseMens);		
        return view('estructura/ingresomalo.php',$datos);
    }  	
    $mensaje   = str_replace("%20"," ", $mensaje); 
    $claseMens = str_replace("%20"," ", $claseMens);      
    $datosUsuario= $this->SessionUser();
    $MenuIzquierdo = $this->MenuIzquierdo();
    $usu_id = $datosUsuario['id'];
    $MontoActual = $this->MontoDisponible($usu_id);
    $dbSip = \Config\Database::connect('thSipacha', true);
    $Bancos   = new Bancos($dbSip); 
    $Depositos   = new Depositos($dbSip); 
    $Configuracion = new Configuracion($dbSip);
    $datosConf = $Configuracion -> find (1); 
    $FormDeposito="";
    $datosBancos =  $Bancos -> distinct() -> where('tab_bancos.ban_id <>','1') -> builder () ->get(); 
    $builder = $Bancos -> builder ();
    $builder -> distinct();
    $builder -> join('tab_titulares','tab_titulares.ban_id = tab_bancos.ban_id','inner');
    $builder -> where('tab_bancos.ban_id <>','1') ;
    $datosBancosTH = $builder->get(); 
    $datosBancosUsu =$this->ListaDesplegable($datosBancos,'ban_id_usu','ban_id_usu','custom-select','ban_id','ban_nombre',''); 
    $datosBancosTH =$this->ListaDesplegable($datosBancosTH,'ban_id','ban_id','custom-select','ban_id','ban_nombre',''); 
    $ClasDiv   = "table-responsive table-hover";
    $ClasTabla = "table table-bordered table-striped";
    $idDiv     = ""; 
    $element = $MontoActual;
    $element .= "   
    <form  method='post' action='".BaseUrl()."/SipachaVirtualDepositos/EnviarDeposito'>
    <div class='".$ClasDiv."' id='".$idDiv."'>
    <table class='".$ClasTabla."'> 
    <tr><td colspan=2 align=center style='background-color:#0b054a'><p style='color:#FFFFFF;'><b>Enviar Deposito</b></p></td></tr>";
    $element .= "<tr><td>Tipo Pago:</td>";
    $element .= "<td>
    <SELECT NAME='dep_tipo'>
    <OPTION VALUE='1'selected> Transferencia </OPTION> 
    <OPTION VALUE='0' >Pago Movil </OPTION>     
    </SELECT>
    </td></tr>";    
    $element .= "<tr><td>Su Banco:</td>";
    $element .= "<td>".$datosBancosUsu."</td></tr>";
    $element .= "<tr><td>Nuestro Banco:</td>";
    $element .= "<td>".$datosBancosTH."</td></tr>";   
    $element .= "<tr><td>Referencia:</td>";
    $element .= "<td><input type=number name='dep_referencia' id='dep_referencia' rounded border border-primary' min='1000' required integer></td></tr>";        
    $element .= "<tr><td>Fecha:</td>";
    $element .= "<td>
    <div class='input-group date' id='datetimepicker1'>
    <input type='text' name='dep_fecha' class='form-control' />
    <span class='input-group-addon'>
        <span class='glyphicon glyphicon-calendar'></span>
    </span>
    </div>  
    </td></tr>";        
    $element .= "<tr><td>Monto:</td>";
    $element .= "<td><input type=number name='dep_monto' id='monto' rounded border border-primary' min='".$datosConf['deposito_minimo']."' required integer></td></tr>";        
    $element .= "<tr>";
    $element .= "<td colspan=2><button type='submit' class='btn btn-info btn-block'> Enviar </button></td>";            
    $element .="</tr></table></div></form>";
    $builder = $Depositos -> builder ();
    $builder -> join('tab_bancos','tab_depositos.ban_id = tab_bancos.ban_id','inner');
    $builder -> where('tab_depositos.usu_id',$usu_id) ;
    $builder -> where('tab_depositos.dep_invalidado','0') ;
    $builder -> where('tab_depositos.dep_validado','0') ;
    $builder -> orderBy('dep_fechaenvio','DESC'); 
    $datosDepEnviados = $builder->get(); 
    $TotalReg = $datosDepEnviados->resultID->num_rows;
    $ClasDiv   = "";
    $ClasTabla = "";  
    $idDiv     = ""; 
    $TitCol    = array('Fecha Envio','Banco Emisor','Banco Receptor','Fecha Deposito','Tipo','Referencia','Monto');
    $AnchoCol  = array('1'=>'15','2'=>'15','3'=>'10','4'=>'20','5'=>'10','6'=>'10','7'=>'10');
    if ($TotalReg >=1){
    $element2 = "   
    <div class='".$ClasDiv."' id='".$idDiv."'>
    <table align='center' border='1' class='".$ClasTabla."'> 
    <tr>
    <td colspan=6 align=left style='background-color:#0b054a'><p style='color:#FFFFFF;'><b>Deposito o Transferencias enviadas por validar</b></p></td>
    <td colspan=1 align=right style='background-color:#0b054a'><p style='color:#FFFFFF;'><b>Total:  </b>".$TotalReg."</p></td></tr> 
    <tr> ";
    $i=1;
    foreach ($TitCol as $col) {  
        $element2 .= "
        <td width='".$AnchoCol[$i]."' style='background-color:#0b054a'> <p style='color:#FFFFFF;'><b>"
        .$col."</b></p></td> ";    
        $i=$i+1; 
    }
     
    $element2 .= "
    </tr>
    <tr>";
    foreach ($datosDepEnviados->getResultArray() as $row_item){
        $element2 .= " <td><small>".$row_item['dep_fechaenvio']."</small></td>";  
        $datosBanco = $Bancos -> find ($row_item['ban_id_usu']);
        $element2 .= " <td><small>".$datosBanco['ban_nombre']."</small></td>";          
        $datosBanco = $Bancos -> find ($row_item['ban_id']);
        $element2 .= " <td><small>".$datosBanco['ban_nombre']."</small></td>";
        $element2 .= " <td><small>".cambiarfecha($row_item['dep_fecha'])."</small></td>";  
        if ($row_item['dep_tipo']==1) {
            $element2 .= " <td><small>Transferencia</small></td>";  
        }
        if ($row_item['dep_tipo']==0) {
            $element2 .= " <td><small>Pago Movil</small></td>";  
        }        
        $element2 .= " <td><small>".$row_item['dep_referencia']."</small></td>";   
        $element2 .= " <td><small>".number_format($row_item['dep_monto'], 2,',', '.')."</small></td>";         
        $element2 .= "</tr>";  
    }    
    $element2 .="</table>";
    } else {
        $element2 ="";
    }
    $datos = array('Listado'=>$element2 ,'FormDeposito'=>$element,'datosBancosUsu'=>$datosBancosUsu,'datosBancosTH'=>$datosBancosTH,'datosUsuario'=>$datosUsuario,'MontoActual'=>$MontoActual,'mensaje'=>$mensaje,'titleMens'=>$titleMens,'claseMens'=>$claseMens);		
    return view('estructura/enviardeposito.php',$datos);        
    //------------------------------------------------------------------------------------




}        
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
public function EnviarDeposito(){

    RecogeFormPost();
    //Verifico Sesion de Usuario
    if (!session()->get('isLogged')){
        $mensaje   = "Presione clic en su opcion de menu.";
        $claseMens = "alert alert-danger";
        $titleMens = "<strong>¡Error!</strong> </br>";   
        $datos = array('mensaje'=>$mensaje,'titleMens'=>$titleMens,'claseMens'=>$claseMens);		
        return view('estructura/ingresomalo.php',$datos);
    } 

    $request=\Config\Services::request();
    $fecha_actual = strtotime(date("d-m-Y H:i:00",time()));  //$fecha_actual
    $dep_fecha = $request->getPostGet('dep_fecha');
    $dep_fecha   = str_replace("/","-", $dep_fecha); 
    $dep_fechaV = strtotime($dep_fecha);  //Fecha del Deposito
    
    //Valido la Fecha del Deposito no puede ser mayor a la fecha actual
    if ($dep_fechaV > $fecha_actual){
        $mensaje   = "La Fecha No puede ser mayor a la fecha actual.";
        $claseMens = "alert alert-danger";
        $titleMens = "Error";        
        $url = BaseUrl() . "/SipachaVirtualDepositos/FormEnviarDeposito/".$mensaje."/".$claseMens."/".$titleMens;
        return redirect()->to($url); 
    }

    $dbSip = \Config\Database::connect('thSipacha', true);
    $Auditoria = new Auditoria($dbSip);      
    $Bancos   = new Bancos($dbSip); 
    $Depositos   = new Depositos($dbSip); 

    $datosUsuario= $this->SessionUser();
    $MenuIzquierdo = $this->MenuIzquierdo();
    $usu_id = $datosUsuario['id'];
    $MontoActual = $this->MontoDisponible($usu_id);    
    $fecha_actual = date("Y-m-d H:i:00",time());
    $dep_tipo = $request->getPostGet('dep_tipo'); 
    $dep_referencia = $request->getPostGet('dep_referencia');  
    $ban_id_usu = $request->getPostGet('ban_id_usu'); 
    $ban_id = $request->getPostGet('ban_id'); 
    $dep_monto = $request->getPostGet('dep_monto'); 
    $datosBancoEmisor = $Bancos -> find ($ban_id_usu);
    $datosBancoReceptor = $Bancos -> find ($ban_id);
    $datos =[
        'usu_id' => $datosUsuario['id'],
        'ban_id' => $ban_id,
        'ban_id_usu' => $ban_id_usu ,
        'dep_fecha' => cambiarfecha($dep_fecha) ,
        'dep_monto' =>  $dep_monto ,
        'dep_tipo' => $dep_tipo,
        'dep_referencia' => $dep_referencia,
        'dep_referenciabco' => $dep_referencia,
        'dep_fechaenvio' => $fecha_actual 
    ]; 

    //------Valido que el deposito aun no haya sido enviado -------------    
    $builder = $Depositos -> builder ();
    $builder ->where('usu_id',$datos['usu_id']);
    $builder ->where('ban_id',$datos['ban_id']);
    $builder ->where('ban_id_usu',$datos['ban_id_usu']);
    $builder ->where('dep_fecha',$datos['dep_fecha']);
    $builder ->where('dep_monto',$datos['dep_monto']);
    $builder ->where('dep_referencia',$datos['dep_referencia']);
    $datosDep = $builder->get();     
    $existe = $datosDep->resultID->num_rows;
    if ($existe >=1){
        $mensaje   = "Este deposito o transferencia ya fue enviado por usted, espere su validacion.";
        $claseMens = "alert alert-danger";
        $titleMens = "Error";        
        $url = BaseUrl() . "/SipachaVirtualDepositos/FormEnviarDeposito/".$mensaje."/".$claseMens."/".$titleMens;
        return redirect()->to($url); 
    }    
    
    $insertDep    = $Depositos->insert($datos);

    $au_descripcion="Envio un deposito para ser validado: <br> del ". $datosBancoEmisor['ban_nombre']." al ".$datosBancoReceptor['ban_nombre']." con la Referencia: $dep_referencia <br>por un monto de Bs. ".number_format($dep_monto, 2,',', '.')." de fecha". cambiarfecha($dep_fecha);
    $datosAuditoria = [
        'au_fecha'=>date("Y") . "-" . date("m") . "-" . date("d"),
        'au_hora'=>strftime("%H:%M:%S"),
        'au_evento'=>"INSERT",
        'au_descripcion'=>$au_descripcion,
        'au_ip'=>ObtenerIP(),
        'usu_id'=>$datosUsuario['id'],
        'au_usulogin'=>$datosUsuario['username'],
        'au_so'=>PHP_OS,
        'au_mostrar'=>1
        ];
    $audit    = $Auditoria->insert($datosAuditoria);  

    print_r ($datos);  
    $mensaje   = "Deposito enviado con exito.";
    $claseMens = "alert alert-success";
    $titleMens = "Felicidades";        
    $url = BaseUrl() . "/SipachaVirtualDepositos/FormEnviarDeposito/".$mensaje."/".$claseMens."/".$titleMens;
    return redirect()->to($url); 

}
}